/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.util.LineTokenizer;

public final class StripSection
extends BaseParamFilterReader
implements ChainableReader {
    private static final String BEGIN_KEY = "beginBlock";
    private static final String END_KEY = "endBlock";
    private String beginBlock = null;
    private String endBlock = null;
    private LineTokenizer lineTokenizer = null;
    private String line = null;
    private int linePos = 0;
    private boolean inSection = false;

    public StripSection() {
    }

    public StripSection(Reader in) {
        super(in);
        this.lineTokenizer = new LineTokenizer();
        this.lineTokenizer.setIncludeDelims(true);
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        while (this.line == null || this.line.length() == 0) {
            this.line = this.lineTokenizer.getToken(this.in);
            if (this.line == null) {
                return -1;
            }
            this.line = this.stripSection(this.line);
            this.linePos = 0;
        }
        char ch = this.line.charAt(this.linePos);
        ++this.linePos;
        if (this.linePos == this.line.length()) {
            this.line = null;
        }
        return ch;
    }

    public final void setBeginBlock(String tmp) {
        this.beginBlock = tmp;
    }

    public final void setEndBlock(String tmp) {
        this.endBlock = tmp;
    }

    public final Reader chain(Reader rdr) {
        StripSection newFilter = new StripSection(rdr);
        newFilter.setBeginBlock(this.beginBlock);
        newFilter.setEndBlock(this.endBlock);
        newFilter.setInitialized(true);
        return newFilter;
    }

    private final void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (BEGIN_KEY.equals(params[i].getName())) {
                    this.beginBlock = params[i].getValue();
                    continue;
                }
                if (!END_KEY.equals(params[i].getName())) continue;
                this.endBlock = params[i].getValue();
            }
        }
    }

    private String stripSection(String line) {
        if (line.indexOf(this.beginBlock) > -1) {
            this.inSection = true;
        }
        if (this.inSection) {
            if (line.indexOf(this.endBlock) > -1) {
                this.inSection = false;
            }
            return null;
        }
        return line;
    }
}

