/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.ant.tasks;

import java.io.File;
import java.security.Key;
import org.apache.commons.codec.binary.Hex;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.aspcfs.modules.service.base.Record;
import org.aspcfs.modules.service.base.TransactionStatus;
import org.aspcfs.modules.setup.beans.RegistrationBean;
import org.aspcfs.utils.HTTPUtils;
import org.aspcfs.utils.PrivateString;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class RegisterTask
extends Task {
    public static final String fs = System.getProperty("file.separator");
    private String organization = null;
    private String firstName = null;
    private String lastName = null;
    private String email = null;
    private String profile = null;
    private String webPath = null;

    public void setOrganization(String tmp) {
        this.organization = tmp;
    }

    public void setFirstName(String tmp) {
        this.firstName = tmp;
    }

    public void setLastName(String tmp) {
        this.lastName = tmp;
    }

    public void setEmail(String tmp) {
        this.email = tmp;
    }

    public void setProfile(String tmp) {
        this.profile = tmp;
    }

    public void setWebPath(String tmp) {
        this.webPath = tmp;
    }

    public void execute() throws BuildException {
        try {
            Key key = null;
            File thisFile = new File(this.webPath + "zlib2.jar");
            key = !thisFile.exists() ? PrivateString.generateEncodedKeyFile(this.webPath + "zlib2.jar") : PrivateString.loadEncodedKey(this.webPath + "zlib2.jar");
            RegistrationBean bean = new RegistrationBean();
            bean.setNameFirst(this.firstName);
            bean.setNameLast(this.lastName);
            bean.setCompany(this.organization);
            bean.setEmail(this.email);
            bean.setProfile(this.profile);
            bean.setZlib2(new String(Hex.encodeHex((byte[])key.getEncoded())));
            bean.setText(PrivateString.encrypt(key, "ENTERPRISE-4.1"));
            String response = null;
            response = bean.getSsl() ? HTTPUtils.sendPacket("https://registration.centriccrm.com/LicenseServer.do?command=SubmitRegistration&ent1source=ent1source", bean.toXmlString()) : HTTPUtils.sendPacket("http://registration.centriccrm.com/LicenseServer.do?command=SubmitRegistration&ent1source=ent1source", bean.toXmlString());
            XMLUtils responseXML = new XMLUtils(response);
            Element responseNode = responseXML.getFirstChild("response");
            TransactionStatus thisStatus = new TransactionStatus(responseNode);
            if (thisStatus.getStatusCode() == 0) {
                System.out.println("Transmitting registration...");
                Record record = (Record)thisStatus.getRecordList().get(0);
                String text = (String)record.get("license");
                if (text != null) {
                    StringUtils.saveText(this.webPath + "input.txt", text);
                    System.out.println("Registration sent.  A license was installed for Centric CRM.");
                }
            } else {
                System.out.println("Registration failed... A license was not obtained from Dark Horse Ventures");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

