/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.ant.tasks;

import bsh.Interpreter;
import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.aspcfs.modules.system.base.DatabaseVersion;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;

public class UpgradeDatabaseTask
extends Task {
    public static final String fs = System.getProperty("file.separator");
    private String sitecode = null;
    private String driver = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private String baseFile = null;
    private String servletJar = null;
    private String fileLibraryPath = null;
    private String specificDatabase = null;
    private String locale = "";
    private String params = null;
    private String languagePath = null;
    private String iceletsPath = null;
    private String prefsPath = null;

    public void setSitecode(String tmp) {
        this.sitecode = tmp;
    }

    public void setDriver(String tmp) {
        this.driver = tmp;
    }

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setUser(String tmp) {
        this.user = tmp;
    }

    public void setPassword(String tmp) {
        this.password = tmp;
    }

    public void setBaseFile(String tmp) {
        this.baseFile = tmp;
    }

    public void setServletJar(String tmp) {
        this.servletJar = tmp;
    }

    public void setFileLibraryPath(String tmp) {
        this.fileLibraryPath = tmp;
    }

    public void setSpecificDatabase(String tmp) {
        this.specificDatabase = tmp;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setLanguagePath(String languagePath) {
        this.languagePath = languagePath;
    }

    public void setIceletsPath(String iceletsPath) {
        this.iceletsPath = iceletsPath;
    }

    public void setPrefsPath(String prefsPath) {
        this.prefsPath = prefsPath;
    }

    public void execute() throws BuildException {
        String fsEval = System.getProperty("file.separator");
        if ("\\".equals(fsEval)) {
            fsEval = "\\\\";
            this.servletJar = StringUtils.replace(this.servletJar, "\\", "\\\\");
            this.fileLibraryPath = StringUtils.replace(this.fileLibraryPath, "\\", "\\\\");
            this.languagePath = StringUtils.replace(this.languagePath, "\\", "\\\\");
            this.iceletsPath = StringUtils.replace(this.iceletsPath, "\\", "\\\\");
            this.prefsPath = StringUtils.replace(this.prefsPath, "\\", "\\\\");
        }
        System.out.println("Checking databases to process...");
        try {
            HashMap<String, String> siteInfo;
            ConnectionPool sqlDriver = new ConnectionPool();
            sqlDriver.setDebug(true);
            sqlDriver.setTestConnections(false);
            sqlDriver.setAllowShrinking(true);
            sqlDriver.setMaxConnections(10);
            sqlDriver.setMaxIdleTime(60000);
            sqlDriver.setMaxDeadTime(600000);
            ArrayList<String> files = new ArrayList<String>();
            boolean multiMode = false;
            if (this.baseFile.indexOf(".txt") > -1) {
                StringUtils.loadText(this.baseFile, files, true);
                multiMode = true;
                System.out.println("Files: " + files.size());
            } else {
                files.add(this.baseFile);
            }
            ConnectionElement ce = new ConnectionElement(this.url, this.user, this.password);
            ce.setDriver(this.driver);
            ce.setAllowCloseOnIdle(false);
            Connection dbGk = sqlDriver.getConnection(ce);
            ArrayList siteList = new ArrayList();
            if (this.params == null || this.params.indexOf("mode=upgrade") == -1) {
                HashMap<String, String> siteInfo2 = new HashMap<String, String>();
                siteInfo2.put("url", this.url);
                siteInfo2.put("dbName", this.specificDatabase);
                siteInfo2.put("user", this.user);
                siteInfo2.put("password", this.password);
                siteInfo2.put("driver", this.driver);
                siteList.add(siteInfo2);
            } else if (this.specificDatabase != null && !"".equals(this.specificDatabase)) {
                SiteList dbList = new SiteList();
                dbList.setSiteCode(this.sitecode);
                dbList.setDatabaseName(this.specificDatabase);
                dbList.buildList(dbGk);
                if (dbList.size() > 0) {
                    Site thisSite = (Site)((Object)dbList.get(0));
                    siteInfo = new HashMap();
                    siteInfo.put("url", thisSite.getDatabaseUrl());
                    siteInfo.put("dbName", thisSite.getDatabaseName());
                    siteInfo.put("user", thisSite.getDatabaseUsername());
                    siteInfo.put("password", thisSite.getDatabasePassword());
                    siteInfo.put("driver", thisSite.getDatabaseDriver());
                    siteList.add(siteInfo);
                } else {
                    HashMap<String, String> siteInfo3 = new HashMap<String, String>();
                    siteInfo3.put("url", this.url);
                    siteInfo3.put("dbName", this.specificDatabase);
                    siteInfo3.put("user", this.user);
                    siteInfo3.put("password", this.password);
                    siteInfo3.put("driver", this.driver);
                    siteList.add(siteInfo3);
                }
            } else {
                PreparedStatement pst = dbGk.prepareStatement("SELECT DISTINCT dbhost, dbname, dbuser, dbpw, driver FROM sites WHERE sitecode = ? AND enabled = ? ");
                pst.setString(1, this.sitecode);
                pst.setBoolean(2, true);
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    siteInfo = new HashMap<String, String>();
                    siteInfo.put("url", rs.getString("dbhost"));
                    siteInfo.put("dbName", rs.getString("dbname"));
                    siteInfo.put("user", rs.getString("dbuser"));
                    siteInfo.put("password", rs.getString("dbpw"));
                    siteInfo.put("driver", rs.getString("driver"));
                    if (this.specificDatabase != null && !"".equals(this.specificDatabase) && !this.specificDatabase.equals((String)siteInfo.get("dbName"))) continue;
                    siteList.add(siteInfo);
                }
                rs.close();
                pst.close();
            }
            File baseFilePath = new File(this.baseFile);
            for (String thisFile : files) {
                if (multiMode) {
                    thisFile = baseFilePath.getParent() + fs + thisFile;
                }
                System.out.println("File: " + thisFile);
                if (thisFile.indexOf("gk") > -1) {
                    this.executeScript(dbGk, thisFile, fsEval, null);
                    this.executeSql(dbGk, thisFile, fsEval);
                } else {
                    if (siteList.size() == 0) {
                        throw new BuildException("ERROR: Database not found");
                    }
                    for (HashMap hashMap : siteList) {
                        ce = new ConnectionElement((String)hashMap.get("url"), (String)hashMap.get("user"), (String)hashMap.get("password"));
                        ce.setDriver((String)hashMap.get("driver"));
                        ce.setAllowCloseOnIdle(false);
                        Connection db = sqlDriver.getConnection(ce);
                        this.executeScript(db, thisFile, fsEval, (String)hashMap.get("dbName"));
                        this.executeSql(db, thisFile, fsEval);
                        this.updateDBVersion(db, thisFile);
                        sqlDriver.free(db);
                    }
                }
                System.out.println(" ");
            }
            sqlDriver.closeAllConnections();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new BuildException("Script Error: " + e.getMessage());
        }
    }

    private void executeScript(Connection db, String thisScriptFile, String fsEval, String dbName) throws Exception {
        String scriptFile = thisScriptFile;
        if (scriptFile.endsWith(".bsh")) {
            if (!new File(scriptFile).exists()) {
                scriptFile = new File(scriptFile).getParentFile().getParentFile().getParentFile().getPath() + fs + "upgrade" + fs + new File(scriptFile).getName();
            }
            if (!new File(scriptFile).exists()) {
                throw new Exception("BSH FILE NOT FOUND: " + thisScriptFile);
            }
            Interpreter script = new Interpreter();
            script.eval("addClassPath(bsh.cwd + \"" + fsEval + "build" + fsEval + "lib" + fsEval + "aspcfs.jar\")");
            script.eval("addClassPath(bsh.cwd + \"" + fsEval + "build" + fsEval + "lib" + fsEval + "darkhorseventures.jar\")");
            script.eval("addClassPath(bsh.cwd + \"" + fsEval + "build" + fsEval + "lib" + fsEval + "zeroio-iteam.jar\")");
            script.eval("addClassPath(bsh.cwd + \"" + fsEval + "build" + fsEval + "lib" + fsEval + "jcrontab.jar\")");
            script.eval("addClassPath(bsh.cwd + \"" + fsEval + "lib" + fsEval + "log4j-1.2.9.jar\")");
            script.eval("addClassPath(bsh.cwd + \"" + fsEval + "lib" + fsEval + "bcprov-jdk14-121.jar\")");
            script.eval("addClassPath(bsh.cwd + \"" + fsEval + "lib" + fsEval + "commons-codec-1.3.jar\")");
            script.eval("addClassPath(\"" + this.servletJar + "\")");
            script.set("db", (Object)db);
            script.set("fileLibraryPath", (Object)(this.fileLibraryPath + fs));
            script.set("languagePath", (Object)(this.languagePath + fs));
            script.set("iceletsPath", (Object)(this.iceletsPath + fs));
            script.set("prefsPath", (Object)(this.prefsPath + fs));
            script.set("locale", (Object)this.locale);
            File directory = new File(this.fileLibraryPath + fs + dbName);
            if (directory.exists()) {
                script.set("dbFileLibraryPath", (Object)(this.fileLibraryPath + fs + dbName + fs));
            } else {
                script.set("dbFileLibraryPath", (Object)(this.fileLibraryPath + fs + "WEB-INF" + fs + "fileLibrary" + fs + dbName + fs));
            }
            script.set("params", (Object)this.params);
            System.out.println("Executing: " + scriptFile);
            script.source(scriptFile);
        }
    }

    private void executeSql(Connection db, String sqlFile, String fsEval) throws Exception {
        if (sqlFile.endsWith(".sql")) {
            if (!new File(sqlFile).exists()) {
                throw new Exception("SQL FILE NOT FOUND: " + sqlFile);
            }
            try {
                db.setAutoCommit(false);
                System.out.println("SQL Script executing: " + sqlFile);
                DatabaseUtils.executeSQL(db, sqlFile);
                db.commit();
                System.out.println("SQL Script complete: " + sqlFile);
            }
            catch (SQLException sq) {
                db.rollback();
                System.out.println("SQL ERROR: " + sq.getMessage());
                throw new Exception(sq);
            }
            finally {
                db.setAutoCommit(true);
            }
        }
    }

    private void updateDBVersion(Connection db, String baseName) throws Exception {
        if (new File(baseName).exists()) {
            try {
                boolean newFile = true;
                String fileName = this.baseFile.substring(this.baseFile.indexOf("upgrade") + 8);
                PreparedStatement pst = db.prepareStatement("SELECT version_id FROM database_version WHERE script_filename = ? ");
                pst.setString(1, fileName);
                ResultSet rs = pst.executeQuery();
                if (rs.next()) {
                    newFile = false;
                }
                rs.close();
                pst.close();
                if (newFile) {
                    String scriptVersion = fileName.substring(0, fileName.indexOf("."));
                    if (scriptVersion.indexOf("gk") > 0) {
                        scriptVersion = scriptVersion.substring(0, scriptVersion.indexOf("gk"));
                    }
                    DatabaseVersion databaseVersion = new DatabaseVersion();
                    databaseVersion.setScriptFilename(fileName);
                    databaseVersion.setScriptVersion(scriptVersion);
                    databaseVersion.insert(db);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

