/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.utils.SMTPMessage;

public class ReportBuilder {
    protected Date start = new Date();
    protected StringBuffer output = new StringBuffer();
    protected String baseName = "";
    protected String dbUser = "";
    protected String dbPass = "";
    protected int totalRecords = 0;

    protected String getIP() {
        String tmp = "";
        try {
            InetAddress localaddr = InetAddress.getLocalHost();
            tmp = localaddr.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return tmp;
    }

    protected String getHostName() {
        String tmp = "";
        try {
            InetAddress localaddr = InetAddress.getLocalHost();
            tmp = localaddr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (tmp.indexOf(".") == -1) {
            tmp = tmp + ".darkhorseventures.com";
        }
        return tmp;
    }

    protected void sendReport(Connection db, String flag, StringBuffer output) throws SQLException {
        UserList userList = new UserList();
        userList.setBuildContact(true);
        userList.setBuildContactDetails(true);
        userList.setRoleType(0);
        userList.buildList(db);
        Iterator i = userList.iterator();
        StringBuffer log = new StringBuffer();
        while (i.hasNext()) {
            User thisUser = (User)((Object)i.next());
            if (thisUser.getContact().getEmailAddress("Work").indexOf("@") <= 0) continue;
            SMTPMessage mail = new SMTPMessage();
            mail.setHost("127.0.0.1");
            mail.setFrom(this.baseName + "@" + this.getHostName());
            mail.addTo(thisUser.getContact().getEmailAddress("Business"));
            mail.setSubject("Report [1 day: " + this.totalRecords + " record" + (this.totalRecords != 1 ? "s" : "") + "]");
            mail.setBody(output.toString());
            mail.setType("text/html");
            if (mail.send() != 2) continue;
            log.append("Send error: " + mail.getErrorMsg() + "<br><br>");
            System.err.println("ReportBuilder Error: Report could not be sent");
            System.err.println(mail.getErrorMsg());
        }
        SMTPMessage mail = new SMTPMessage();
        mail.setHost("mail.darkhorseventures.com");
        mail.setFrom("notifier_error@" + this.getHostName());
        mail.addTo("mrajkowski@darkhorseventures.com");
        mail.setSubject("Report [1 day: " + this.totalRecords + " record" + (this.totalRecords != 1 ? "s" : "") + "]");
        mail.setBody("Emails generated: " + userList.size() + "<br><br>" + log.toString());
        mail.setType("text/html");
        if (mail.send() == 2) {
            System.err.println("ReportBuilder Error: Report could not be sent");
            System.err.println(mail.getErrorMsg());
        }
    }

    protected void sendAdminReport(String exc) {
        SMTPMessage mail = new SMTPMessage();
        mail.setHost("mail.darkhorseventures.com");
        mail.setFrom("notifier_error@" + this.getHostName());
        mail.addTo("mrajkowski@darkhorseventures.com");
        mail.setSubject("Admin Alert");
        mail.setBody("<PRE>Any Errors Follow:<br>" + exc.toString() + "</PRE>");
        mail.setType("text/html");
        if (mail.send() == 2) {
            System.err.println("ReportBuilder Error: Mail could not be sent");
            System.err.println(mail.getErrorMsg());
        }
    }
}

