/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.help;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.aspcfs.apps.help.HelpModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExportHelp {
    ArrayList helpModules;

    public ExportHelp() {
    }

    public ExportHelp(String[] args) {
        this.helpModules = new ArrayList();
        this.buildHelpInformation(args);
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length != 4 && args.length != 5) {
            System.out.println("Synopsis: java ExportHelp [filepath][driver][uri][user] <passwd>");
        } else {
            new ExportHelp(args);
        }
    }

    void buildHelpInformation(String[] args) {
        ConnectionPool sqlDriver = null;
        System.out.println("Starting...");
        boolean recordCount = false;
        try {
            sqlDriver = new ConnectionPool();
        }
        catch (SQLException e) {
            System.err.println(e);
        }
        Connection db = null;
        try {
            String filePath = args[0];
            String driver = args[1];
            String uri = args[2];
            String username = args[3];
            String passwd = "";
            if (args.length == 5) {
                passwd = args[4];
            }
            sqlDriver.setForceClose(false);
            sqlDriver.setMaxConnections(5);
            ConnectionElement thisElement = new ConnectionElement(uri, username, passwd);
            thisElement.setDriver(driver);
            db = sqlDriver.getConnection(thisElement);
            this.buildTOCIncludedHelpModules(db);
            this.buildNonTocHelpModules(db);
            for (HelpModule tempHelpModule : this.helpModules) {
                tempHelpModule.buildHelpContents(db);
            }
            System.out.println("built description");
            this.buildXML(filePath);
            sqlDriver.free(db);
            System.out.println("Built XML file and released database connection");
            return;
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    void buildTOCIncludedHelpModules(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT module_id, category, hm.category_id as catId, module_brief_description, module_detail_description, contentorder FROM help_module hm, permission_category pc, help_tableof_contents hc WHERE hm.category_id = pc.category_id AND pc.category_id = hc.category_id AND hm.category_id = hc.category_id AND contentlevel = 2 ORDER BY contentorder ASC");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            HelpModule tempHelpModule = new HelpModule();
            tempHelpModule.buildRecord(rs);
            tempHelpModule.setContentLevel(2);
            this.helpModules.add(tempHelpModule);
        }
        System.out.println("built data structure");
        rs.close();
        pst.close();
    }

    void buildNonTocHelpModules(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT help_module.category_id as id1, help_tableof_contents.category_id as id2 FROM help_module LEFT OUTER JOIN help_tableof_contents ON (help_tableof_contents.category_id = help_module.category_id)");
        ResultSet rs = pst.executeQuery();
        ArrayList<String> categoryIds = new ArrayList<String>();
        while (rs.next()) {
            if (!String.valueOf(rs.getInt("id2")).equals("0")) continue;
            categoryIds.add(String.valueOf(rs.getInt("id1")));
        }
        rs.close();
        pst.close();
        if (categoryIds.size() == 0) {
            return;
        }
        String nonTocCategories = "(";
        Iterator itr = categoryIds.iterator();
        while (itr.hasNext()) {
            nonTocCategories = nonTocCategories + (String)itr.next();
            if (!itr.hasNext()) continue;
            nonTocCategories = nonTocCategories + ",";
        }
        nonTocCategories = nonTocCategories + ")";
        pst = db.prepareStatement("SELECT module_id, category, hm.category_id as catId, module_brief_description, module_detail_description, constant FROM help_module hm, permission_category pc WHERE pc.category_id = hm.category_id AND pc.category_id IN " + nonTocCategories);
        rs = pst.executeQuery();
        while (rs.next()) {
            HelpModule tempHelpModule = new HelpModule(rs);
            tempHelpModule.setContentLevel(0);
            this.helpModules.add(tempHelpModule);
        }
        rs.close();
        pst.close();
    }

    void buildXML(String filePath) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document d = db.newDocument();
            Element system = d.createElement("helpSystem");
            Iterator i = this.helpModules.iterator();
            boolean n = false;
            while (i.hasNext()) {
                HelpModule tempHelpModule = (HelpModule)i.next();
                system.appendChild(tempHelpModule.buildXML(d));
            }
            d.appendChild(system);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new File(filePath));
            DOMSource source = new DOMSource(d);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

