/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.help;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HelpContent {
    private int id = -1;
    private String action = null;
    private String section = null;
    private String sub = null;
    private String title = null;
    private String description = null;
    private int tocId = -1;
    private int parent = -1;
    private int contentLevel = -1;
    private int contentOrder = -1;
    private ArrayList features;
    private ArrayList rules;
    private ArrayList notes;
    private ArrayList tips;
    private boolean insert = false;

    public HelpContent() {
        this.features = new ArrayList();
        this.rules = new ArrayList();
        this.notes = new ArrayList();
        this.tips = new ArrayList();
    }

    public HelpContent(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("help_id");
        this.action = rs.getString("module");
        this.section = rs.getString("section");
        this.sub = rs.getString("subsection");
        this.title = rs.getString("title");
        this.description = rs.getString("description");
        this.tocId = rs.getInt("content_id");
        this.parent = rs.getInt("parent");
        this.contentLevel = rs.getInt("contentlevel");
        this.contentOrder = rs.getInt("contentorder");
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setAction(String tmp) {
        this.action = tmp;
    }

    public void setSection(String tmp) {
        this.section = tmp;
    }

    public void setSub(String tmp) {
        this.sub = tmp;
    }

    public void setTitle(String tmp) {
        this.title = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setTocId(int tmp) {
        this.tocId = tmp;
    }

    public void setParent(int tmp) {
        this.parent = tmp;
    }

    public void setContentLevel(int tmp) {
        this.contentLevel = tmp;
    }

    public void setContentLevel(String tmp) {
        this.contentLevel = Integer.parseInt(tmp);
    }

    public void setContentOrder(int tmp) {
        this.contentOrder = tmp;
    }

    public void setContentOrder(String tmp) {
        this.contentOrder = Integer.parseInt(tmp);
    }

    public void setFeatures(ArrayList tmp) {
        this.features = tmp;
    }

    public void setRules(ArrayList tmp) {
        this.rules = tmp;
    }

    public void setNotes(ArrayList tmp) {
        this.notes = tmp;
    }

    public void setTips(ArrayList tmp) {
        this.tips = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getAction() {
        return this.action;
    }

    public String getSection() {
        return this.section;
    }

    public String getSub() {
        return this.sub;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getTocId() {
        return this.tocId;
    }

    public int getParent() {
        return this.parent;
    }

    public int getContentLevel() {
        return this.contentLevel;
    }

    public int getContentOrder() {
        return this.contentOrder;
    }

    public ArrayList getFeatures() {
        return this.features;
    }

    public ArrayList getRules() {
        return this.rules;
    }

    public ArrayList getNotes() {
        return this.notes;
    }

    public ArrayList getTips() {
        return this.tips;
    }

    public boolean getInsert() {
        return this.insert;
    }

    public boolean insertHelpContent(Connection db, int linkId, int tmpCategoryId) throws SQLException {
        this.insert = true;
        this.id = DatabaseUtils.getNextSeq(db, "help_contents_help_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO help_contents (" + (this.id > -1 ? "help_id, " : "") + "link_module_id, category_id, " + DatabaseUtils.addQuotes(db, "module") + ", " + DatabaseUtils.addQuotes(db, "section") + ", subsection, title, description, enteredby, modifiedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, linkId);
        pst.setInt(++i, tmpCategoryId);
        pst.setString(++i, this.action);
        pst.setString(++i, this.section);
        pst.setString(++i, this.sub);
        pst.setString(++i, this.title);
        pst.setString(++i, this.description);
        pst.setInt(++i, 0);
        pst.setInt(++i, 0);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "help_contents_help_id_seq", this.id);
        this.insertFeatures(db);
        this.insertNotes(db);
        this.insertRules(db);
        this.insertTips(db);
        return true;
    }

    boolean insertFeatures(Connection db) throws SQLException {
        Iterator itr = this.features.iterator();
        int level = 1;
        while (itr.hasNext()) {
            String featureDesc = (String)itr.next();
            int fid = DatabaseUtils.getNextSeq(db, "help_features_feature_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO help_features (" + (fid > -1 ? "feature_id, " : "") + "link_help_id, description, " + DatabaseUtils.addQuotes(db, "level") + ", enteredby, modifiedby, enabled) " + "VALUES (" + (fid > -1 ? "?, " : "") + "?, ?,?, ?, ?, ?) ");
            int i = 0;
            if (fid > -1) {
                pst.setInt(++i, fid);
            }
            pst.setInt(++i, this.id);
            pst.setString(++i, featureDesc);
            pst.setInt(++i, level);
            pst.setInt(++i, 0);
            pst.setInt(++i, 0);
            pst.setBoolean(++i, true);
            pst.execute();
            pst.close();
            ++level;
        }
        return true;
    }

    boolean insertNotes(Connection db) throws SQLException {
        for (String noteDesc : this.notes) {
            int helpNoteId = DatabaseUtils.getNextSeq(db, "help_notes_note_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO help_notes (" + (helpNoteId > -1 ? "note_id, " : "") + "link_help_id, description, enteredby, modifiedby, enabled) " + "VALUES (" + (helpNoteId > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
            int i = 0;
            if (helpNoteId > -1) {
                pst.setInt(++i, helpNoteId);
            }
            pst.setInt(++i, this.id);
            pst.setString(++i, noteDesc);
            pst.setInt(++i, 0);
            pst.setInt(++i, 0);
            pst.setBoolean(++i, true);
            pst.execute();
            pst.close();
        }
        return true;
    }

    boolean insertRules(Connection db) throws SQLException {
        for (String ruleDesc : this.rules) {
            int rid = DatabaseUtils.getNextSeq(db, "help_business_rules_rule_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO help_business_rules (" + (rid > -1 ? "rule_id, " : "") + "link_help_id, description, enteredby, modifiedby, enabled) " + "VALUES (" + (rid > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
            int i = 0;
            if (rid > -1) {
                pst.setInt(++i, rid);
            }
            pst.setInt(++i, this.id);
            pst.setString(++i, ruleDesc);
            pst.setInt(++i, 0);
            pst.setInt(++i, 0);
            pst.setBoolean(++i, true);
            pst.execute();
            pst.close();
        }
        return true;
    }

    boolean insertTips(Connection db) throws SQLException {
        for (String tipDesc : this.tips) {
            int tid = DatabaseUtils.getNextSeq(db, "help_tips_tip_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO help_tips (" + (tid > -1 ? "tip_id, " : "") + "link_help_id, description, enteredby, modifiedby, enabled) " + "VALUES (" + (tid > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
            int i = 0;
            if (tid > -1) {
                pst.setInt(++i, tid);
            }
            pst.setInt(++i, this.id);
            pst.setString(++i, tipDesc);
            pst.setInt(++i, 0);
            pst.setInt(++i, 0);
            pst.setBoolean(++i, true);
            pst.execute();
            pst.close();
        }
        return true;
    }

    public void buildDescription(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT description FROM help_features WHERE link_help_id = ? ORDER BY " + DatabaseUtils.addQuotes(db, "level") + "");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        if (this.features == null) {
            this.features = new ArrayList();
        }
        while (rs.next()) {
            this.features.add(rs.getString("description"));
        }
        rs.close();
        pst.close();
        if (this.notes == null) {
            this.notes = new ArrayList();
        }
        pst = db.prepareStatement("SELECT description FROM help_notes WHERE link_help_id = ?");
        pst.setInt(1, this.getId());
        rs = pst.executeQuery();
        while (rs.next()) {
            this.notes.add(rs.getString("description"));
        }
        rs.close();
        pst.close();
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        pst = db.prepareStatement("SELECT description FROM help_business_rules WHERE link_help_id = ?");
        pst.setInt(1, this.getId());
        rs = pst.executeQuery();
        while (rs.next()) {
            this.rules.add(rs.getString("description"));
        }
        rs.close();
        pst.close();
        if (this.tips == null) {
            this.tips = new ArrayList();
        }
        pst = db.prepareStatement("SELECT description FROM help_tips WHERE link_help_id = ?");
        pst.setInt(1, this.getId());
        rs = pst.executeQuery();
        while (rs.next()) {
            this.tips.add(rs.getString("description"));
        }
        rs.close();
        pst.close();
    }

    public Node buildXML(Document d) {
        Element pageDescription = d.createElement("pageDescription");
        pageDescription.setAttribute("contentLevel", String.valueOf(this.getContentLevel()));
        Element action = d.createElement("action");
        Element section = d.createElement("section");
        Element subSection = d.createElement("subSection");
        Element title = d.createElement("title");
        Element description = d.createElement("description");
        action.appendChild(d.createTextNode(this.getAction()));
        if (this.getSection() != null) {
            section.appendChild(d.createTextNode(this.getSection()));
        }
        if (this.getSub() != null) {
            subSection.appendChild(d.createTextNode(this.getSub()));
        }
        if (this.getTitle() != null) {
            title.appendChild(d.createTextNode(this.getTitle()));
        }
        if (this.getDescription() != null) {
            description.appendChild(d.createTextNode(XMLUtils.toXMLValue(this.getDescription())));
        }
        pageDescription.appendChild(action);
        pageDescription.appendChild(section);
        pageDescription.appendChild(subSection);
        pageDescription.appendChild(title);
        pageDescription.appendChild(description);
        this.buildDescriptionXML(d, pageDescription);
        return pageDescription;
    }

    public void buildDescriptionXML(Document d, Node pageDescription) {
        Element description;
        Element features = d.createElement("features");
        Element notes = d.createElement("notes");
        Element rules = d.createElement("rules");
        Element tips = d.createElement("tips");
        Iterator i = this.getFeatures().iterator();
        while (i.hasNext()) {
            description = d.createElement("featureDescription");
            description.appendChild(d.createTextNode(XMLUtils.toXMLValue((String)i.next())));
            features.appendChild(description);
        }
        i = this.getNotes().iterator();
        while (i.hasNext()) {
            description = d.createElement("noteDescription");
            description.appendChild(d.createTextNode(XMLUtils.toXMLValue((String)i.next())));
            notes.appendChild(description);
        }
        i = this.getRules().iterator();
        while (i.hasNext()) {
            description = d.createElement("ruleDescription");
            description.appendChild(d.createTextNode(XMLUtils.toXMLValue((String)i.next())));
            rules.appendChild(description);
        }
        i = this.getTips().iterator();
        while (i.hasNext()) {
            description = d.createElement("tipDescription");
            description.appendChild(d.createTextNode(XMLUtils.toXMLValue((String)i.next())));
            tips.appendChild(description);
        }
        pageDescription.appendChild(features);
        pageDescription.appendChild(notes);
        pageDescription.appendChild(rules);
        pageDescription.appendChild(tips);
    }

    public String fetchTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.sub != null) {
            return this.section + " - " + this.sub;
        }
        if (this.section != null && this.sub == null) {
            return this.section;
        }
        if (this.action != null && this.section == null) {
            return this.action;
        }
        return "DUMMY";
    }
}

