/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.help;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.apps.help.HelpContent;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HelpModule {
    private int id = -1;
    private String category = null;
    private int categoryId = -1;
    private String briefDescription = null;
    private String detailDescription = null;
    private int pageId = -1;
    private int constantForCategory = -1;
    private int contentLevel = -1;
    ArrayList helpContents = new ArrayList();
    private boolean insert = false;

    public HelpModule() {
    }

    public HelpModule(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCategory(String tmp) {
        this.category = tmp;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void setBriefDescription(String tmp) {
        this.briefDescription = tmp;
    }

    public void setDetailDescription(String tmp) {
        this.detailDescription = tmp;
    }

    public void setPageId(int tmp) {
        this.pageId = tmp;
    }

    public void setPageId(String tmp) {
        this.pageId = Integer.parseInt(tmp);
    }

    public void setContentLevel(int tmp) {
        this.contentLevel = tmp;
    }

    public void setContentLevel(String tmp) {
        this.contentLevel = Integer.parseInt(tmp);
    }

    public void setConstantForCategory(int tmp) {
        this.constantForCategory = tmp;
    }

    public void setConstantForCategory(String tmp) {
        this.constantForCategory = Integer.parseInt(tmp);
    }

    public void setHelpContents(ArrayList tmp) {
        this.helpContents = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getCategory() {
        return this.category;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public String getBriefDescription() {
        return this.briefDescription;
    }

    public String getDetailDescription() {
        return this.detailDescription;
    }

    public int getConstantForCategory() {
        return this.constantForCategory;
    }

    public ArrayList getHelpContents() {
        return this.helpContents;
    }

    public boolean getInsert() {
        return this.insert;
    }

    public int getPageId() {
        return this.pageId;
    }

    public int getContentLevel() {
        return this.contentLevel;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("catId");
        this.categoryId = rs.getInt("catId");
        this.category = rs.getString("category");
        this.briefDescription = rs.getString("module_brief_description");
        this.detailDescription = rs.getString("module_detail_description");
        this.constantForCategory = rs.getInt("constant");
    }

    public boolean insertModule(Connection db) throws SQLException {
        this.insert = true;
        this.id = DatabaseUtils.getNextSeq(db, "help_module_module_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO help_module (" + (this.id > -1 ? "module_id, " : "") + "category_id, module_brief_description, module_detail_description) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.categoryId);
        pst.setString(++i, this.briefDescription);
        pst.setString(++i, this.detailDescription);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "help_module_module_id_seq", this.id);
        for (HelpContent tmpHelpContent : this.helpContents) {
            tmpHelpContent.insertHelpContent(db, this.id, this.categoryId);
        }
        return true;
    }

    public void buildHelpContents(Connection db) throws SQLException {
        System.out.println("Building Help Contents for:" + this.category);
        PreparedStatement pst = db.prepareStatement("SELECT help_id, " + DatabaseUtils.addQuotes(db, "module") + ", " + DatabaseUtils.addQuotes(db, "section") + ", subsection, title, description, content_id, parent, contentlevel, contentorder " + "FROM help_contents hc, help_tableof_contents htc, help_tableofcontentitem_links hi " + "WHERE hc.category_id= ? " + "AND htc.content_id = hi.global_link_id " + "AND hi.linkto_content_id = hc.help_id " + "ORDER BY contentorder ASC ");
        pst.setInt(1, this.categoryId);
        ResultSet rs = pst.executeQuery();
        ArrayList<HelpContent> itemsAtLevel3 = new ArrayList<HelpContent>();
        ArrayList<HelpContent> itemsAtLevel4 = new ArrayList<HelpContent>();
        ArrayList<HelpContent> itemsAtLevel5 = new ArrayList<HelpContent>();
        while (rs.next()) {
            HelpContent tmpHelpContent = new HelpContent(rs);
            if (tmpHelpContent.getContentLevel() == 3) {
                itemsAtLevel3.add(tmpHelpContent);
            }
            if (tmpHelpContent.getContentLevel() == 4) {
                itemsAtLevel4.add(tmpHelpContent);
            }
            if (tmpHelpContent.getContentLevel() != 5) continue;
            itemsAtLevel5.add(tmpHelpContent);
        }
        rs.close();
        pst.close();
        for (HelpContent tmpHelpContent3 : itemsAtLevel3) {
            this.helpContents.add(tmpHelpContent3);
            ArrayList childrenof3 = this.fetchChildren(tmpHelpContent3, itemsAtLevel4);
            for (HelpContent tmpHelpContent4 : childrenof3) {
                this.helpContents.add(tmpHelpContent4);
                ArrayList childrenof4 = this.fetchChildren(tmpHelpContent4, itemsAtLevel5);
                for (HelpContent tmpHelpContent5 : childrenof4) {
                    this.helpContents.add(tmpHelpContent5);
                }
            }
        }
        this.helpContents.addAll(this.buildNonTocHelpContents(db));
        for (HelpContent tempHelpContent : this.helpContents) {
            tempHelpContent.buildDescription(db);
        }
    }

    private ArrayList buildNonTocHelpContents(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT help_id, " + DatabaseUtils.addQuotes(db, "module") + ", " + DatabaseUtils.addQuotes(db, "section") + ", subsection, title, description " + "FROM help_contents hc " + "WHERE hc.category_id=? ");
        pst.setInt(1, this.categoryId);
        ResultSet rs = pst.executeQuery();
        ArrayList<HelpContent> tempHelpContents = new ArrayList<HelpContent>();
        while (rs.next()) {
            Iterator itr = this.helpContents.iterator();
            boolean found = false;
            int tempId = rs.getInt("help_id");
            while (itr.hasNext()) {
                HelpContent tempHelpContent = (HelpContent)itr.next();
                if (tempHelpContent.getId() != tempId) continue;
                found = true;
                break;
            }
            if (found) continue;
            HelpContent tmpHelpContent = new HelpContent();
            tmpHelpContent.setId(tempId);
            tmpHelpContent.setAction(rs.getString("module"));
            tmpHelpContent.setSection(rs.getString("section"));
            tmpHelpContent.setSub(rs.getString("subsection"));
            tmpHelpContent.setTitle(rs.getString("title"));
            tmpHelpContent.setDescription(rs.getString("description"));
            tmpHelpContent.setContentLevel(0);
            tempHelpContents.add(tmpHelpContent);
        }
        rs.close();
        pst.close();
        return tempHelpContents;
    }

    private ArrayList fetchChildren(HelpContent tmpHelpItem, ArrayList items) {
        Iterator itr = items.iterator();
        ArrayList<HelpContent> tmpList = new ArrayList<HelpContent>();
        while (itr.hasNext()) {
            HelpContent tmpItem = (HelpContent)itr.next();
            if (tmpItem.getParent() != tmpHelpItem.getTocId()) continue;
            tmpList.add(tmpItem);
        }
        return tmpList;
    }

    public Node buildXML(Document d) {
        Element module = d.createElement("module");
        module.setAttribute("name", this.getCategory());
        module.setAttribute("constant", String.valueOf(this.getConstantForCategory()));
        module.setAttribute("contentLevel", String.valueOf(this.getContentLevel()));
        Element briefDescription = d.createElement("briefDescription");
        Element detailDescription = d.createElement("detailDescription");
        if (this.getBriefDescription() != null) {
            briefDescription.appendChild(d.createTextNode(XMLUtils.toXMLValue(this.getBriefDescription())));
        }
        if (this.getDetailDescription() != null) {
            detailDescription.appendChild(d.createTextNode(XMLUtils.toXMLValue(this.getDetailDescription())));
        }
        module.appendChild(briefDescription);
        module.appendChild(detailDescription);
        Iterator i = this.helpContents.iterator();
        int n = 0;
        while (i.hasNext()) {
            HelpContent tempHC = (HelpContent)i.next();
            module.appendChild(tempHC.buildXML(d));
            ++n;
        }
        System.out.println("help items for " + this.getCategory() + " - " + n);
        return module;
    }
}

