/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.help;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.aspcfs.apps.help.HelpContent;
import org.aspcfs.apps.help.HelpModule;
import org.aspcfs.apps.help.TableOfContentItem;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportHelp {
    ArrayList helpModules = new ArrayList();
    ArrayList permissionCategories = new ArrayList();
    ArrayList tableOfContents = new ArrayList();

    public ImportHelp() {
    }

    public ImportHelp(String[] args) {
        ConnectionPool sqlDriver = null;
        try {
            sqlDriver = new ConnectionPool();
        }
        catch (SQLException e) {
            System.err.println(e);
        }
        Connection db = null;
        try {
            String filePath = args[0];
            String driver = args[1];
            String uri = args[2];
            String username = args[3];
            String passwd = "";
            if (args.length == 5) {
                passwd = args[4];
            }
            sqlDriver.setForceClose(false);
            sqlDriver.setMaxConnections(5);
            ConnectionElement thisElement = new ConnectionElement(uri, username, passwd);
            thisElement.setDriver(driver);
            db = sqlDriver.getConnection(thisElement);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Reading Help Data from XML...");
            }
            this.buildHelpInformation(filePath);
            this.buildExistingPermissionCategories(db);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Inserting data into help_module, help_contents, features, tips, etc...");
            }
            this.insertHelpRecords(db);
            this.buildTableOfContents();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Inserting table of content records...");
            }
            this.insertTableOfContents(db);
            sqlDriver.free(db);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Finished");
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 4 && args.length != 5) {
            System.out.println("Usage: java ImportHelp [filepath][driver][uri][user] <passwd>");
        } else {
            System.setProperty("DEBUG", "1");
            new ImportHelp(args);
        }
        System.exit(0);
    }

    public boolean insertHelpRecords(Connection db) throws SQLException {
        for (HelpModule tempHelpModule : this.helpModules) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println(" " + tempHelpModule.getCategory());
            }
            int categoryId = -1;
            categoryId = this.existPermissionCategory(tempHelpModule.getConstantForCategory());
            if (categoryId != -1) {
                tempHelpModule.setId(categoryId);
                tempHelpModule.setCategoryId(categoryId);
                tempHelpModule.insertModule(db);
                continue;
            }
            if (System.getProperty("DEBUG") == null) continue;
            System.out.println(" * " + tempHelpModule.getCategory() + " Does not exist in the new database");
        }
        return true;
    }

    public boolean insertTableOfContents(Connection db) throws SQLException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (TableOfContentItem tmpItem : this.tableOfContents) {
            if (tmpItem.getLevel() > 1) {
                tmpItem.setParent((Integer)map.get(new Integer(tmpItem.getLevel() - 1)));
            }
            map.put(new Integer(tmpItem.getLevel()), new Integer(tmpItem.insert(db)));
        }
        return true;
    }

    public int existPermissionCategory(int category) {
        for (PermissionCategory pc : this.permissionCategories) {
            if (category != pc.getConstant()) continue;
            return pc.getId();
        }
        return -1;
    }

    public boolean buildExistingPermissionCategories(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM permission_category ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            PermissionCategory tempPermissionCategory = new PermissionCategory(rs);
            this.permissionCategories.add(tempPermissionCategory);
        }
        rs.close();
        pst.close();
        return true;
    }

    public void buildHelpInformation(String filePath) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document d = db.parse(filePath);
            Element root = d.getDocumentElement();
            this.processNode(root);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void processNode(Node node) {
        NodeList moduleList = ((Element)node).getElementsByTagName("module");
        for (int i = 0; i < moduleList.getLength(); ++i) {
            Node module = moduleList.item(i);
            NamedNodeMap moduleNMP = module.getAttributes();
            HelpModule helpModule = new HelpModule();
            helpModule.setCategory(moduleNMP.getNamedItem("name").getNodeValue());
            helpModule.setConstantForCategory(Integer.parseInt(moduleNMP.getNamedItem("constant").getNodeValue()));
            helpModule.setContentLevel(moduleNMP.getNamedItem("contentLevel").getNodeValue());
            NodeList briefDescription = ((Element)module).getElementsByTagName("briefDescription");
            helpModule.setBriefDescription(XMLUtils.toString(briefDescription.item(0).getFirstChild().getNodeValue()));
            NodeList detailDescription = ((Element)module).getElementsByTagName("detailDescription");
            helpModule.setDetailDescription(XMLUtils.toString(detailDescription.item(0).getFirstChild().getNodeValue()));
            NodeList pageList = ((Element)module).getElementsByTagName("pageDescription");
            if (System.getProperty("DEBUG") != null) {
                System.out.println(" " + helpModule.getCategory() + ": " + pageList.getLength());
            }
            for (int j = 0; j < pageList.getLength(); ++j) {
                Node page = pageList.item(j);
                NamedNodeMap pageNMP = page.getAttributes();
                HelpContent helpContent = new HelpContent();
                helpContent.setContentLevel(pageNMP.getNamedItem("contentLevel").getNodeValue());
                NodeList action = ((Element)page).getElementsByTagName("action");
                helpContent.setAction(action.item(0).getFirstChild().getNodeValue());
                NodeList section = ((Element)page).getElementsByTagName("section");
                helpContent.setSection(section.item(0).getFirstChild() != null ? section.item(0).getFirstChild().getNodeValue() : null);
                NodeList subSection = ((Element)page).getElementsByTagName("subSection");
                helpContent.setSub(subSection.item(0).getFirstChild() != null ? subSection.item(0).getFirstChild().getNodeValue() : null);
                NodeList title = ((Element)page).getElementsByTagName("title");
                helpContent.setTitle(title.item(0).getFirstChild() != null ? title.item(0).getFirstChild().getNodeValue() : null);
                NodeList description = ((Element)page).getElementsByTagName("description");
                helpContent.setDescription(description.item(0).getFirstChild() != null ? XMLUtils.toString(description.item(0).getFirstChild().getNodeValue()) : null);
                int k = 0;
                NodeList featureList = ((Element)page).getElementsByTagName("featureDescription");
                for (k = 0; k < featureList.getLength(); ++k) {
                    helpContent.getFeatures().add(XMLUtils.toString(featureList.item(k).getFirstChild().getNodeValue()));
                }
                NodeList ruleList = ((Element)page).getElementsByTagName("ruleDescription");
                for (k = 0; k < ruleList.getLength(); ++k) {
                    helpContent.getRules().add(XMLUtils.toString(ruleList.item(k).getFirstChild().getNodeValue()));
                }
                NodeList noteList = ((Element)page).getElementsByTagName("noteDescription");
                for (k = 0; k < noteList.getLength(); ++k) {
                    helpContent.getNotes().add(XMLUtils.toString(noteList.item(k).getFirstChild().getNodeValue()));
                }
                NodeList tipList = ((Element)page).getElementsByTagName("tipDescription");
                for (k = 0; k < tipList.getLength(); ++k) {
                    helpContent.getTips().add(XMLUtils.toString(tipList.item(k).getFirstChild().getNodeValue()));
                }
                helpModule.getHelpContents().add(helpContent);
            }
            this.helpModules.add(helpModule);
        }
    }

    public void buildTableOfContents() {
        Iterator moduleItr = this.helpModules.iterator();
        int moduleOrder = 5;
        TableOfContentItem tempTopTOCItem = new TableOfContentItem();
        tempTopTOCItem.buildRecord();
        this.tableOfContents.add(tempTopTOCItem);
        while (moduleItr.hasNext()) {
            HelpModule tempHelpModule = (HelpModule)moduleItr.next();
            if (!tempHelpModule.getInsert() || tempHelpModule.getContentLevel() == 0) continue;
            Iterator contentItr = tempHelpModule.getHelpContents().iterator();
            TableOfContentItem tempModuleTOCItem = new TableOfContentItem();
            tempModuleTOCItem.buildRecord(tempHelpModule.getCategory(), tempHelpModule.getCategoryId(), moduleOrder);
            this.tableOfContents.add(tempModuleTOCItem);
            moduleOrder += 5;
            int contentOrder = 5;
            while (contentItr.hasNext()) {
                HelpContent tempHelpContent = (HelpContent)contentItr.next();
                if (!tempHelpContent.getInsert() || tempHelpContent.getContentLevel() == 0) continue;
                TableOfContentItem tempContentTOCItem = new TableOfContentItem();
                tempContentTOCItem.buildRecord(tempHelpModule.getCategoryId(), tempHelpContent.fetchTitle(), contentOrder, tempHelpContent.getContentLevel(), tempHelpContent.getId());
                this.tableOfContents.add(tempContentTOCItem);
                contentOrder += 5;
            }
        }
    }
}

