/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.icelets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ExportPortalTemplates {
    public ExportPortalTemplates() {
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java ExportPortalTemplates [sourcefilepath][destinationfilepath]");
        } else {
            System.setProperty("DEBUG", "1");
            new ExportPortalTemplates(args);
        }
        System.exit(0);
    }

    public ExportPortalTemplates(String[] args) {
        try {
            String sourceFilePath = args[0];
            String destinationFilePath = args[1];
            String fs = System.getProperty("file.separator");
            this.zipTemplates(sourceFilePath + fs + "portal_templates", destinationFilePath + fs + "WEB-INF" + fs + "portal_templates");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    public void zipTemplates(String sourcePath, String destinationPath) throws Exception {
        String fs = System.getProperty("file.separator");
        File sourceDirectory = new File(sourcePath);
        if (sourceDirectory.isDirectory()) {
            String[] locale = sourceDirectory.list();
            for (int localeCount = 0; localeCount < locale.length; ++localeCount) {
                File localeDirectory;
                if (locale[localeCount].startsWith(".") || !(localeDirectory = new File(sourcePath + fs + locale[localeCount])).isDirectory()) continue;
                String[] template = localeDirectory.list();
                for (int templateCount = 0; templateCount < template.length; ++templateCount) {
                    if (template[templateCount].startsWith(".")) continue;
                    new File(destinationPath + fs + locale[localeCount]).mkdirs();
                    ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(destinationPath + fs + locale[localeCount] + fs + template[templateCount] + ".zip"));
                    zipOutputStream.setLevel(-1);
                    this.zipAllFiles(new File(sourcePath + fs + locale[localeCount] + fs + template[templateCount]), zipOutputStream);
                    zipOutputStream.close();
                }
            }
        } else {
            System.out.println("Incorrect directory specified for portal templates");
        }
    }

    private void zipAllFiles(File dir, ZipOutputStream out) throws Exception {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].startsWith(".")) continue;
                this.zipAllFiles(new File(dir, children[i]), out);
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(dir);
            byte[] buffer = new byte[in.available()];
            String dirPath = dir.getPath();
            String pathInZip = "";
            String[] paths = dir.getPath().split("website");
            if (paths.length != 2) {
                throw new Exception("Could not create package");
            }
            pathInZip = "website" + paths[1];
            out.putNextEntry(new ZipEntry(pathInZip));
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.closeEntry();
            in.close();
        }
    }
}

