/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.icelets;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.aspcfs.modules.website.base.Icelet;
import org.aspcfs.modules.website.base.IceletList;
import org.aspcfs.modules.website.base.IceletProperty;
import org.aspcfs.modules.website.base.IceletPropertyMap;
import org.aspcfs.modules.website.base.RowColumn;
import org.aspcfs.modules.website.base.RowColumnList;

public class ImportIcelets {
    public ImportIcelets() {
    }

    public static void main(String[] args) {
        if (args.length != 4 && args.length != 5) {
            System.out.println("Usage: java ImportIcelets [filepath][driver][uri][user] <passwd>");
        } else {
            System.setProperty("DEBUG", "1");
            new ImportIcelets(args);
        }
        System.exit(0);
    }

    public ImportIcelets(String[] args) {
        ConnectionPool sqlDriver = null;
        try {
            sqlDriver = new ConnectionPool();
            String filePath = args[0];
            String driver = args[1];
            String uri = args[2];
            String username = args[3];
            String passwd = "";
            if (args.length == 5) {
                passwd = args[4];
            }
            sqlDriver.setForceClose(false);
            sqlDriver.setMaxConnections(5);
            ConnectionElement thisElement = new ConnectionElement(uri, username, passwd);
            thisElement.setDriver(driver);
            Connection db = sqlDriver.getConnection(thisElement);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Reading Icelets from XML...");
            }
            HashMap iceletMap = IceletList.load(filePath);
            ImportIcelets.insertIceletList(db, iceletMap);
            sqlDriver.free(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    public static void insertIceletList(Connection db, HashMap iceletMap) throws Exception {
        IceletList persistantIceletList = new IceletList();
        persistantIceletList.buildList(db);
        Set iceletSet = iceletMap.keySet();
        for (String key : iceletSet) {
            Icelet newIcelet = (Icelet)((Object)iceletMap.get(key));
            String iceletClass = newIcelet.getConfiguratorClass();
            int version = newIcelet.getVersion();
            Iterator persistantIceletIterator = persistantIceletList.iterator();
            boolean foundIcelet = false;
            boolean foundPreviousVersion = false;
            Icelet persistantIcelet = null;
            while (persistantIceletIterator.hasNext()) {
                persistantIcelet = (Icelet)((Object)persistantIceletIterator.next());
                if (!persistantIcelet.getConfiguratorClass().equals(iceletClass)) continue;
                foundIcelet = true;
                if (persistantIcelet.getVersion() >= version) break;
                foundPreviousVersion = true;
                break;
            }
            if (!foundIcelet) {
                newIcelet.setEnabled(true);
                newIcelet.insert(db);
            }
            if (!foundPreviousVersion) continue;
            persistantIcelet.setName(newIcelet.getName());
            persistantIcelet.setDescription(newIcelet.getDescription());
            persistantIcelet.setConfiguratorClass(newIcelet.getConfiguratorClass());
            persistantIcelet.setEnabled(true);
            persistantIcelet.setVersion(newIcelet.getVersion());
            persistantIcelet.update(db);
            ImportIcelets.updateRowColumnProperties(db, persistantIcelet, newIcelet);
        }
    }

    public static void updateRowColumnProperties(Connection db, Icelet persistantIcelet, Icelet newIcelet) throws Exception {
        RowColumnList rowColumnList = new RowColumnList();
        rowColumnList.setBuildIceletPropertyMap(true);
        rowColumnList.setBuildIcelet(true);
        rowColumnList.setIceletId(persistantIcelet.getId());
        rowColumnList.buildList(db);
        for (RowColumn rowColumn : rowColumnList) {
            if (rowColumn.getIceletId() != persistantIcelet.getId()) continue;
            IceletPropertyMap persistantIceletPropertyMap = rowColumn.getIceletPropertyMap();
            IceletPropertyMap iceletPropertyMap = newIcelet.getIceletPropertyMap();
            Set persistantIceletPropertySet = persistantIceletPropertyMap.keySet();
            for (Integer key : persistantIceletPropertySet) {
                if (iceletPropertyMap.containsKey(key)) continue;
                IceletProperty persistantIceletProperty = (IceletProperty)((Object)persistantIceletPropertyMap.get(key));
                persistantIceletProperty.delete(db);
            }
            Set iceletPropertySet = iceletPropertyMap.keySet();
            for (Integer key : iceletPropertySet) {
                IceletProperty iceletProperty = (IceletProperty)((Object)iceletPropertyMap.get(key));
                if (!iceletProperty.getAutoAdd()) continue;
                iceletProperty.setValue(iceletProperty.getDefaultValue());
                iceletProperty.setRowColumnId(rowColumn.getId());
                iceletProperty.setEnteredBy(0);
                iceletProperty.setModifiedBy(0);
                iceletProperty.insert(db);
            }
        }
    }
}

