/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.icelets;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import org.aspcfs.modules.website.utils.SiteImporter;

public class ImportWebsite {
    public ImportWebsite() {
    }

    public static void main(String[] args) {
        if (args.length != 5 && args.length != 6) {
            System.out.println("Usage: java ImportWebsite [filepath][webapp path][driver][uri][user] <passwd>");
        } else {
            System.setProperty("DEBUG", "1");
            new ImportWebsite(args);
        }
        System.exit(0);
    }

    public ImportWebsite(String[] args) {
        ConnectionPool sqlDriver = null;
        try {
            sqlDriver = new ConnectionPool();
            String filePath = args[0];
            String webappPath = args[1];
            String driver = args[2];
            String uri = args[3];
            String username = args[4];
            String passwd = "";
            if (args.length == 6) {
                passwd = args[5];
            }
            sqlDriver.setForceClose(false);
            sqlDriver.setMaxConnections(5);
            ConnectionElement thisElement = new ConnectionElement(uri, username, passwd);
            thisElement.setDriver(driver);
            Connection db = sqlDriver.getConnection(thisElement);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Reading website from ZIP...");
            }
            new SiteImporter(filePath, webappPath, db);
            sqlDriver.free(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

