/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.lookuplists;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspcfs.apps.lookuplists.LookupLists;
import org.aspcfs.utils.DatabaseUtils;

public class ImportLookupLists {
    private LookupLists lookupLists = null;
    private ArrayList completeLookupListList = null;
    private HashMap customLookupListHandlers = null;
    private ArrayList lookupListsWithCompleteTableNameAsKey = null;
    private ArrayList lookupListsWithLevelAsIsFromAttributeList = null;
    private HashMap globallyUniqueIds = null;
    private ArrayList lookupListsWithNoLevelColumn = null;
    private HashMap lookupListsWithNoDescription = null;

    public ImportLookupLists() {
    }

    public static void main(String[] args) {
        if (args.length != 4 && args.length != 5) {
            System.out.println("Usage: java ImportLookupLists [filepath][driver][uri][user] <passwd>");
        } else {
            System.setProperty("DEBUG", "1");
            new ImportLookupLists(args);
        }
        System.exit(0);
    }

    public ImportLookupLists(String[] args) {
        ConnectionPool sqlDriver = null;
        try {
            sqlDriver = new ConnectionPool();
            String filePath = args[0];
            String driver = args[1];
            String uri = args[2];
            String username = args[3];
            String passwd = "";
            if (args.length == 5) {
                passwd = args[4];
            }
            sqlDriver.setForceClose(false);
            sqlDriver.setMaxConnections(5);
            ConnectionElement thisElement = new ConnectionElement(uri, username, passwd);
            thisElement.setDriver(driver);
            Connection db = sqlDriver.getConnection(thisElement);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Reading Lookup Lists from XML...");
            }
            this.importLookups(db, filePath);
            sqlDriver.free(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    public void importLookups(Connection db, String filePath) throws Exception {
        this.initializeCustomHandlers();
        this.lookupLists = new LookupLists();
        this.completeLookupListList = this.lookupLists.buildLookupLists(filePath, this.customLookupListHandlers, this.lookupListsWithNoDescription);
        this.globallyUniqueIds = this.lookupLists.getGloballyUniqueIds();
        this.insertLookupListList(db);
    }

    private void insertLookupListList(Connection db) throws Exception {
        Iterator lookupListListIterator = this.completeLookupListList.iterator();
        System.out.println("\nInserting values into:");
        while (lookupListListIterator.hasNext()) {
            HashMap lookupListObjects = (HashMap)lookupListListIterator.next();
            ArrayList rowElements = (ArrayList)lookupListObjects.get("rows");
            HashMap columnTypes = (HashMap)lookupListObjects.get("attributes");
            String tableName = (String)lookupListObjects.get("tableName");
            String key = (String)lookupListObjects.get("key");
            Boolean useLevelAsIs = (Boolean)lookupListObjects.get("useLevelAsIs");
            Iterator rowElementsIterator = rowElements.iterator();
            System.out.println(tableName);
            int count = 0;
            while (rowElementsIterator.hasNext()) {
                HashMap row = (HashMap)rowElementsIterator.next();
                this.insertLookupListElement(db, tableName, key, useLevelAsIs, row, columnTypes, ++count * 10);
            }
        }
    }

    private void insertLookupListElement(Connection db, String tableName, String key, Boolean useLevelAsIs, HashMap row, HashMap columnTypes, int level) throws Exception {
        int dbId = -1;
        String primaryKey = key == null || "".equals(key) ? "code" : key;
        StringBuffer sqlString = new StringBuffer();
        StringBuffer sqlColumnNames = new StringBuffer();
        StringBuffer sqlColumnValues = new StringBuffer();
        sqlString.append("INSERT INTO " + DatabaseUtils.getTableName(db, tableName));
        Set columnNames = row.keySet();
        Iterator columnNameIterator = columnNames.iterator();
        boolean hasColumns = false;
        boolean enabledFound = false;
        int locallyUniqueId = -1;
        String enabledValue = "";
        boolean defaultItemFound = false;
        String defaultItemValue = "";
        boolean firstColumn = true;
        while (columnNameIterator.hasNext()) {
            hasColumns = true;
            String columnName = (String)columnNameIterator.next();
            if ("enabled".equals(columnName)) {
                enabledFound = true;
                enabledValue = (String)row.get(columnName);
                continue;
            }
            if ("default_item".equals(columnName)) {
                defaultItemFound = true;
                defaultItemValue = (String)row.get(columnName);
                continue;
            }
            if ("LUID".equals(columnName)) {
                locallyUniqueId = Integer.parseInt((String)row.get(columnName));
                continue;
            }
            if ("level".equals(columnName)) continue;
            sqlColumnNames.append((!firstColumn ? ", " : "") + (columnName.equals("type") ? DatabaseUtils.addQuotes(db, "type") : columnName));
            sqlColumnValues.append((!firstColumn ? ", " : "") + "?");
            firstColumn = false;
        }
        if (hasColumns) {
            String sequenceName = null;
            sequenceName = this.needsCompleteTableNameForKey(tableName) ? tableName + "_" + primaryKey + "_seq" : (tableName.length() > 22 ? tableName.substring(0, 22) : tableName) + "_" + primaryKey + "_seq";
            dbId = DatabaseUtils.getNextSeq(db, sequenceName);
            if (dbId > -1) {
                sqlColumnNames.append(", " + primaryKey);
            }
            sqlColumnNames.append((enabledFound ? ", enabled" : "") + (defaultItemFound ? ", default_item" : "") + (this.hasLevelColumn(tableName) ? ", " + DatabaseUtils.addQuotes(db, "level") + " " : ""));
            StringBuffer sqlColumnNamesString = new StringBuffer();
            sqlColumnNamesString.append(" ( " + sqlColumnNames.toString() + " ) ");
            if (dbId > -1) {
                sqlColumnValues.append(", ? ");
            }
            sqlColumnValues.append((enabledFound ? ", ? " : "") + (defaultItemFound ? ", ? " : "") + (this.hasLevelColumn(tableName) ? ", ? " : ""));
            StringBuffer sqlColumnValuesString = new StringBuffer();
            sqlColumnNamesString.append(" VALUES ( " + sqlColumnValues.toString() + " ) ");
            PreparedStatement pst = db.prepareStatement(sqlString.toString() + sqlColumnNamesString.toString() + sqlColumnValuesString.toString());
            StringTokenizer st = new StringTokenizer(sqlColumnNames.toString(), ",");
            int i = 0;
            while (st.hasMoreTokens()) {
                String columnName = st.nextToken().trim();
                String columnType = "";
                if ("enabled".equals(columnName) || "default_item".equals(columnName) || "level".equals(columnName) || DatabaseUtils.addQuotes(db, "level").equals(columnName)) {
                    if (!"level".equals(columnName) && (!DatabaseUtils.addQuotes(db, "level").equals(columnName) || !useLevelAsIs.booleanValue())) continue;
                    try {
                        if ((String)row.get("level") != null) {
                            level = Integer.parseInt((String)row.get("level"));
                            continue;
                        }
                        level = Integer.parseInt((String)row.get(DatabaseUtils.addQuotes(db, "level")));
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (DatabaseUtils.addQuotes(db, "type").equals(columnName)) {
                    columnName = "type";
                }
                columnType = (String)columnTypes.get(columnName);
                if (columnName.equals(primaryKey) && dbId > -1) {
                    pst.setInt(++i, dbId);
                    continue;
                }
                if (columnType == null) {
                    pst.setString(++i, (String)row.get(columnName));
                    continue;
                }
                if ("integer".equals(columnType)) {
                    pst.setInt(++i, Integer.parseInt((String)row.get(columnName)));
                    continue;
                }
                if ("string".equals(columnType)) {
                    pst.setString(++i, (String)row.get(columnName));
                    continue;
                }
                if ("boolean".equals(columnType)) {
                    pst.setBoolean(++i, "true".equals((String)row.get(columnName)));
                    continue;
                }
                if (columnType.indexOf("LUID") == -1) continue;
                pst.setInt(++i, (Integer)this.globallyUniqueIds.get((String)row.get(columnName)));
            }
            if (enabledFound) {
                pst.setBoolean(++i, !"false".equals(enabledValue));
            }
            if (defaultItemFound) {
                pst.setBoolean(++i, "true".equals(defaultItemValue));
            }
            if (this.hasLevelColumn(tableName)) {
                pst.setInt(++i, level);
            }
            pst.execute();
            pst.close();
            dbId = DatabaseUtils.getCurrVal(db, sequenceName, dbId);
            if (locallyUniqueId != -1) {
                this.globallyUniqueIds.put(tableName + "." + locallyUniqueId, new Integer(dbId));
            }
        }
    }

    private void initializeCustomHandlers() {
        this.customLookupListHandlers = new HashMap();
        this.customLookupListHandlers.put("lookup_relationship_types", "lookupRelationshipTypes");
        this.customLookupListHandlers.put("product_option_configurator", "productOptionConfigurator");
        this.customLookupListHandlers.put("field_types", "fieldTypes");
        this.customLookupListHandlers.put("survey", "survey");
        this.customLookupListHandlers.put("web_layout", "webLayout");
        this.customLookupListHandlers.put("web_style", "webStyle");
        this.lookupListsWithCompleteTableNameAsKey = new ArrayList();
        this.lookupListsWithCompleteTableNameAsKey.add("lookup_document_store_permission_category");
        this.lookupListsWithCompleteTableNameAsKey.add("lookup_document_store_role");
        this.lookupListsWithCompleteTableNameAsKey.add("lookup_document_store_permission");
        this.lookupListsWithCompleteTableNameAsKey.add("lookup_project_permission_category");
        this.lookupListsWithCompleteTableNameAsKey.add("lookup_project_permission");
        this.lookupListsWithCompleteTableNameAsKey.add("lookup_orderaddress_types");
        this.lookupListsWithCompleteTableNameAsKey.add("lookup_relationship_types");
        this.lookupListsWithCompleteTableNameAsKey.add("product_option_configurator");
        this.lookupListsWithLevelAsIsFromAttributeList = new ArrayList();
        this.lookupListsWithLevelAsIsFromAttributeList.add("lookup_document_store_role");
        this.lookupListsWithLevelAsIsFromAttributeList.add("lookup_project_role");
        this.lookupListsWithNoLevelColumn = new ArrayList();
        this.lookupListsWithNoLevelColumn.add("field_types");
        this.lookupListsWithNoLevelColumn.add("product_option_configurator");
        this.lookupListsWithNoLevelColumn.add("search_fields");
        this.lookupListsWithNoLevelColumn.add("survey");
        this.lookupListsWithNoLevelColumn.add("action_plan_constants");
        this.lookupListsWithNoLevelColumn.add("step_action_map");
        this.lookupListsWithNoLevelColumn.add("web_layout");
        this.lookupListsWithNoLevelColumn.add("web_style");
        this.lookupListsWithNoDescription = new HashMap();
        this.lookupListsWithNoDescription.put("step_action_map", "step_action_map");
    }

    private boolean needsCompleteTableNameForKey(String tableName) {
        for (String tmpTableName : this.lookupListsWithCompleteTableNameAsKey) {
            if (!tableName.equals(tmpTableName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasLevelColumn(String tableName) {
        for (String tmpTableName : this.lookupListsWithNoLevelColumn) {
            if (!tableName.equals(tmpTableName)) continue;
            return false;
        }
        return true;
    }
}

