/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.lookuplists;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class LookupLists {
    private HashMap globallyUniqueIds = null;

    public void setGloballyUniqueIds(HashMap tmp) {
        this.globallyUniqueIds = tmp;
    }

    public HashMap getGloballyUniqueIds() {
        return this.globallyUniqueIds;
    }

    public ArrayList buildLookupLists(String filePath, HashMap customLookupListHandlers, HashMap lookupListsWithNoDescription) throws Exception {
        System.out.println("Reading from file:" + filePath);
        File configFile = new File(filePath);
        XMLUtils xml = new XMLUtils(configFile);
        ArrayList lookupTables = new ArrayList();
        XMLUtils.getAllChildren(xml.getDocumentElement(), "lookup", lookupTables);
        Iterator lookupTableIterator = lookupTables.iterator();
        ArrayList lookupListList = new ArrayList();
        this.globallyUniqueIds = new HashMap();
        System.out.println("Reading values for lookup lists");
        while (lookupTableIterator.hasNext()) {
            Element lookupTable = (Element)lookupTableIterator.next();
            String tableName = lookupTable.getAttribute("table");
            String key = lookupTable.getAttribute("key");
            System.out.println(tableName);
            boolean useLevelAsIs = false;
            HashMap<String, Object> lookupListObjects = new HashMap<String, Object>();
            ArrayList lookupElements = new ArrayList();
            ArrayList lookupColumnTypes = new ArrayList();
            XMLUtils.getAllChildren(lookupTable, "attribute", lookupColumnTypes);
            Iterator lookupColumnTypeIterator = lookupColumnTypes.iterator();
            HashMap<String, String> columnTypes = new HashMap<String, String>();
            while (lookupColumnTypeIterator.hasNext()) {
                Element lookupColumn = (Element)lookupColumnTypeIterator.next();
                NamedNodeMap attributes = lookupColumn.getAttributes();
                String name = attributes.getNamedItem("name").getNodeValue();
                String type = attributes.getNamedItem("type").getNodeValue();
                columnTypes.put(name, type);
            }
            lookupListObjects.put("attributes", columnTypes);
            XMLUtils.getAllChildren(lookupTable, "record", lookupElements);
            Iterator lookupElementIterator = lookupElements.iterator();
            ArrayList rowElements = new ArrayList();
            while (lookupElementIterator.hasNext()) {
                Element lookupElement = (Element)lookupElementIterator.next();
                NamedNodeMap attributes = lookupElement.getAttributes();
                int numberOfAttributes = attributes.getLength();
                int count = 0;
                HashMap<String, String> columnValues = new HashMap<String, String>();
                while (count < numberOfAttributes) {
                    Node attribute;
                    if ("level".equals((attribute = attributes.item(count++)).getNodeName())) {
                        useLevelAsIs = true;
                    }
                    if ("LUID".equals(attribute.getNodeName())) {
                        this.globallyUniqueIds.put(tableName + "." + attribute.getNodeValue(), " ");
                    }
                    columnValues.put(attribute.getNodeName(), attribute.getNodeValue());
                }
                if (customLookupListHandlers.containsKey(tableName)) {
                    this.buildMultipleDescriptions(columnValues, lookupElement);
                } else if (!lookupListsWithNoDescription.containsKey(tableName)) {
                    columnValues.put("description", XMLUtils.getNodeText(lookupElement));
                }
                rowElements.add(columnValues);
            }
            lookupListObjects.put("rows", rowElements);
            lookupListObjects.put("tableName", tableName);
            lookupListObjects.put("key", key);
            lookupListObjects.put("useLevelAsIs", new Boolean(useLevelAsIs));
            lookupListList.add(lookupListObjects);
        }
        return lookupListList;
    }

    public void buildMultipleDescriptions(HashMap columnValues, Element lookupElement) {
        ArrayList items = new ArrayList();
        XMLUtils.getAllChildren(lookupElement, items);
        for (Node item : items) {
            columnValues.put(item.getNodeName(), XMLUtils.getNodeText(item));
        }
    }
}

