/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.notifier;

import com.darkhorseventures.database.ConnectionPool;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersion;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipOutputStream;
import org.aspcfs.apps.ReportBuilder;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.Usage;
import org.aspcfs.modules.base.Notification;
import org.aspcfs.modules.base.Report;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.communications.base.CampaignList;
import org.aspcfs.modules.communications.base.MessageAttachment;
import org.aspcfs.modules.communications.base.Recipient;
import org.aspcfs.modules.communications.base.RecipientList;
import org.aspcfs.modules.contacts.base.Call;
import org.aspcfs.modules.contacts.base.CallList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactInformationFormatter;
import org.aspcfs.modules.contacts.base.ContactReport;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponentEmail;
import org.aspcfs.modules.pipeline.base.OpportunityComponentList;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.utils.AppUtils;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.HTTPUtils;
import org.aspcfs.utils.ImageUtils;
import org.aspcfs.utils.PrivateString;
import org.aspcfs.utils.SiteUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.ZipUtils;

public class Notifier
extends ReportBuilder {
    private Map config = new HashMap();
    private ArrayList taskList = new ArrayList();
    private Timestamp today = null;
    private Timestamp yesterday = null;
    public static final String fs = System.getProperty("file.separator");
    public static final String lf = System.getProperty("line.separator");

    public Notifier() {
        Calendar calToday = Calendar.getInstance();
        this.today = new Timestamp(calToday.getTimeInMillis());
        Calendar calYesterday = Calendar.getInstance();
        calYesterday.set(11, -25);
        this.yesterday = new Timestamp(calYesterday.getTimeInMillis());
    }

    public void setConfig(Map config) {
        this.config = config;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: Notifier [config file]");
            System.out.println("ExitValue: 2");
        }
        Notifier thisNotifier = new Notifier();
        thisNotifier.execute(args);
        System.exit(0);
    }

    public static void doTask(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: Notifier [config file]");
            System.out.println("ExitValue: 2");
        }
        Notifier thisNotifier = new Notifier();
        thisNotifier.execute(args);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ExitValue: 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] args) {
        String filename = args[0];
        if (args.length > 1) {
            for (int taskCount = 1; taskCount < args.length; ++taskCount) {
                this.getTaskList().add(args[taskCount]);
            }
        } else {
            this.getTaskList().add("org.aspcfs.apps.notifier.task.NotifyOpportunityOwners");
            this.getTaskList().add("org.aspcfs.apps.notifier.task.NotifyCommunicationsRecipients");
            this.getTaskList().add("org.aspcfs.apps.notifier.task.NotifyCallOwners");
        }
        AppUtils.loadConfig(filename, this.config);
        if (this.config.containsKey("FILELIBRARY")) {
            this.baseName = (String)this.config.get("GATEKEEPER.URL");
            this.dbUser = (String)this.config.get("GATEKEEPER.USER");
            this.dbPass = (String)this.config.get("GATEKEEPER.PASSWORD");
            Connection db = null;
            try {
                SiteList siteList = SiteUtils.getSiteList(this.config);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Notifier-> Start Date: " + this.yesterday.toString() + "\nAlert End Date: " + this.today.toString());
                }
                for (Site thisSite : siteList) {
                    Class.forName(thisSite.getDatabaseDriver());
                    db = DatabaseUtils.getConnection(thisSite.getDatabaseUrl(), thisSite.getDatabaseUsername(), thisSite.getDatabasePassword());
                    this.baseName = thisSite.getSiteCode();
                    if (this.getTaskList().size() == 1) {
                        Iterator classes = this.getTaskList().iterator();
                        while (classes.hasNext()) {
                            try {
                                Class<?> thisClass = Class.forName((String)classes.next());
                                Class[] paramClass = new Class[]{Class.forName("java.sql.Connection"), HashMap.class, HashMap.class};
                                Constructor<?> constructor = thisClass.getConstructor(paramClass);
                                Object[] paramObject = new Object[]{db, thisSite, this.getConfig()};
                                Object theTask = constructor.newInstance(paramObject);
                                theTask = null;
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.out);
                            }
                        }
                    }
                    if (this.getTaskList().contains("org.aspcfs.apps.notifier.task.NotifyOpportunityOwners")) {
                        this.output.append(this.buildOpportunityAlerts(db, thisSite));
                    }
                    if (this.getTaskList().contains("org.aspcfs.apps.notifier.task.NotifyCommunicationsRecipients")) {
                        this.output.append(this.buildCommunications(db, thisSite, null));
                    }
                    if (this.getTaskList().contains("org.aspcfs.apps.notifier.task.NotifyCallOwners")) {
                        this.output.append(this.buildCallAlerts(db, thisSite));
                    }
                    db.close();
                }
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(this.output.toString());
                }
            }
            catch (Exception exc) {
                exc.printStackTrace(System.out);
                System.err.println("Notifier-> BuildReport Error: " + exc.toString());
            }
            finally {
                if (db != null) {
                    try {
                        db.close();
                        db = null;
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public String buildOpportunityAlerts(Connection db, Site siteInfo) throws SQLException {
        Report thisReport = new Report();
        thisReport.setBorderSize(0);
        thisReport.addColumn("User");
        OpportunityComponentList thisList = new OpportunityComponentList();
        thisList.setAlertRangeStart(this.yesterday);
        thisList.setAlertRangeEnd(this.today);
        thisList.buildList(db);
        int notifyCount = 0;
        for (OpportunityComponent thisComponent : thisList) {
            Notification thisNotification = new Notification();
            thisNotification.setHost((String)this.config.get("MAILSERVER"));
            thisNotification.setUserToNotify(thisComponent.getOwner());
            thisNotification.setModule("Opportunities");
            thisNotification.setItemId(thisComponent.getId());
            thisNotification.setItemModified(thisComponent.getAlertDate());
            if (thisNotification.isNew(db)) {
                OpportunityHeader thisOpportunity = new OpportunityHeader(db, thisComponent.getHeaderId());
                String relationshipType = null;
                String relationshipName = null;
                if (thisOpportunity.getAccountLink() > 0) {
                    try {
                        Organization thisOrganization = new Organization(db, thisOpportunity.getAccountLink());
                        relationshipType = "Organization";
                        relationshipName = thisOrganization.getName();
                    }
                    catch (Exception ignore) {}
                } else if (thisOpportunity.getContactLink() > 0) {
                    try {
                        Contact thisContact = new Contact(db, thisOpportunity.getContactLink());
                        relationshipType = "Contact";
                        relationshipName = thisContact.getNameFull();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                thisNotification.setFrom((String)this.config.get("EMAILADDRESS"));
                thisNotification.setSiteCode(this.baseName);
                String dbNamePath = (String)this.config.get("FILELIBRARY") + siteInfo.getDatabaseName() + fs;
                String templateFile = dbNamePath + "templates_" + siteInfo.getLanguage() + ".xml";
                if (!FileUtils.fileExists(templateFile)) {
                    templateFile = dbNamePath + "templates_en_US.xml";
                }
                try {
                    OpportunityComponentEmail componentEmail = new OpportunityComponentEmail();
                    componentEmail.setRelationshipType(relationshipType);
                    componentEmail.setRelationshipName(relationshipName);
                    componentEmail.setOpportunity(thisOpportunity);
                    componentEmail.setComponent(thisComponent);
                    componentEmail.setUrl(this.generateLink(siteInfo, "LeadsComponents.do?command=DetailsComponent&id=" + thisComponent.getId()));
                    componentEmail.render(templateFile);
                    thisNotification.setSubject(componentEmail.getSubject());
                    thisNotification.setMessageToSend(componentEmail.getBody());
                    thisNotification.setType(1);
                    thisNotification.setTypeText("Email");
                    thisNotification.notifyUser(db);
                    ++notifyCount;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!thisNotification.hasErrors()) continue;
            System.out.println("Notifier Error 297-> " + thisNotification.getErrorMessage());
            if (System.getProperty("DEBUG") == null) continue;
            System.out.println("Notifier-> Opportunity Component: " + thisComponent.getId());
        }
        thisReport.setHeader("Opportunity Alerts Report for " + this.start.toString() + lf + "Total Records: " + notifyCount);
        return thisReport.getDelimited();
    }

    public String buildCallAlerts(Connection db, Site siteInfo) throws SQLException {
        Report thisReport = new Report();
        thisReport.setBorderSize(0);
        thisReport.addColumn("User");
        CallList thisList = new CallList();
        thisList.setAlertRangeStart(this.yesterday);
        thisList.setAlertRangeEnd(this.today);
        thisList.buildList(db);
        int notifyCount = 0;
        for (Call thisCall : thisList) {
            Notification thisNotification = new Notification();
            thisNotification.setHost((String)this.config.get("MAILSERVER"));
            thisNotification.setUserToNotify(thisCall.getEnteredBy());
            thisNotification.setModule("Calls");
            thisNotification.setItemId(thisCall.getId());
            thisNotification.setItemModified(thisCall.getAlertDate());
            if (thisNotification.isNew(db)) {
                thisNotification.setSiteCode(this.baseName);
                thisNotification.setFrom((String)this.config.get("EMAILADDRESS"));
                thisNotification.setSubject("Call Alert: " + thisCall.getSubject());
                thisNotification.setMessageToSend("* THIS IS AN AUTOMATED MESSAGE, PLEASE DO NOT REPLY<br><br>The following activity in Centric CRM has an alert set: <br><br>Contact: " + StringUtils.toHtml(thisCall.getContactName()) + "<br>" + "Notes: " + StringUtils.toHtml(thisCall.getNotes()) + "<br>" + "<br>" + this.generateCFSUrl(siteInfo, "ExternalContactsCalls.do?command=Details&id=" + thisCall.getId() + "&contactId=" + thisCall.getContactId()));
                thisNotification.setType(1);
                thisNotification.setTypeText("Email");
                thisNotification.notifyUser(db);
                ++notifyCount;
            }
            if (!thisNotification.hasErrors()) continue;
            System.err.println("Notifier Error 359-> " + thisNotification.getErrorMessage());
        }
        thisReport.setHeader("Opportunity Alerts Report for " + this.start.toString() + "<br>" + "Total Records: " + notifyCount);
        return thisReport.getDelimited();
    }

    public String buildCommunications(Connection db, Site siteInfo, ConnectionPool cp) throws Exception {
        String dbName = siteInfo.getDatabaseName();
        Report thisReport = new Report();
        thisReport.setBorderSize(0);
        thisReport.addColumn("Report");
        CampaignList thisList = new CampaignList();
        thisList.setActiveRangeStart(this.yesterday);
        thisList.setActiveRangeEnd(this.today);
        thisList.setActive(1);
        thisList.setReady(1);
        thisList.setEnabled(1);
        thisList.buildList(db);
        if (System.getProperty("DEBUG") != null && thisList.size() > 0) {
            System.out.println("Notifier-> Active Campaigns: " + thisList.size());
        }
        String filePath = (String)this.config.get("FILELIBRARY") + fs + dbName + fs + "keys" + fs;
        File f = new File(filePath);
        f.mkdirs();
        PrivateString thisKey = new PrivateString(filePath + "survey2.key");
        String schema = "http";
        if ("true".equals((String)this.config.get("FORCESSL"))) {
            schema = "https";
        }
        Iterator i = thisList.iterator();
        int notifyCount = 0;
        while (i.hasNext()) {
            Campaign thisCampaign = (Campaign)((Object)i.next());
            thisCampaign.setStatusId(3);
            if (thisCampaign.lockProcess(db) != 1) continue;
            int campaignCount = 0;
            int sentCount = 0;
            boolean hasBcc = thisCampaign.getBcc() != null && !"".equals(thisCampaign.getBcc());
            boolean hasCc = thisCampaign.getCc() != null && !"".equals(thisCampaign.getCc());
            ArrayList<String> faxLog = new ArrayList<String>();
            ContactReport letterLog = new ContactReport();
            FileItemList attachments = new FileItemList();
            FileItemList fileItemList = new FileItemList();
            fileItemList.setLinkModuleId(16);
            fileItemList.setLinkItemId(thisCampaign.getId());
            fileItemList.buildList(db);
            if (System.getProperty("DEBUG") != null && fileItemList.size() > 0) {
                System.out.println("Notifier-> Campaign file attachments: " + fileItemList.size());
            }
            for (FileItem thisItem : fileItemList) {
                FileItem actualItem = new FileItem();
                actualItem.setClientFilename(thisItem.getClientFilename());
                actualItem.setDirectory((String)this.config.get("FILELIBRARY") + fs + dbName + fs + "communications" + fs);
                actualItem.setFilename(thisItem.getFilename());
                actualItem.setSize(thisItem.getSize());
                attachments.add((Object)actualItem);
            }
            for (MessageAttachment messageAttachment : thisCampaign.getMessageAttachments()) {
                FileItem thisItem = messageAttachment.getFileItem();
                if (thisItem == null) continue;
                thisItem.buildVersionList(db);
                FileItemVersion itemToDownload = thisItem.getVersion(thisItem.getVersion());
                FileItem actualItem = new FileItem();
                if (itemToDownload == null) continue;
                actualItem.setClientFilename(thisItem.getClientFilename());
                if (thisItem.getLinkModuleId() == 508200600) {
                    actualItem.setDirectory((String)this.config.get("FILELIBRARY") + fs + dbName + fs + "communications" + fs);
                } else if (thisItem.getLinkModuleId() == 1) {
                    actualItem.setDirectory((String)this.config.get("FILELIBRARY") + fs + dbName + fs + "accounts" + fs);
                } else if (thisItem.getLinkModuleId() == 2) {
                    actualItem.setDirectory((String)this.config.get("FILELIBRARY") + fs + dbName + fs + "contacts" + fs);
                } else if (thisItem.getLinkModuleId() == 4) {
                    actualItem.setDirectory((String)this.config.get("FILELIBRARY") + fs + dbName + fs + "projects" + fs);
                } else if (thisItem.getLinkModuleId() == 20041083) {
                    actualItem.setDirectory((String)this.config.get("FILELIBRARY") + fs + dbName + fs + "documents" + fs);
                }
                actualItem.setFilename(itemToDownload.getFilename());
                actualItem.setSize(thisItem.getSize());
                attachments.add((Object)actualItem);
            }
            RecipientList recipientList = new RecipientList();
            recipientList.setCampaignId(thisCampaign.getId());
            recipientList.setHasNullSentDate(true);
            recipientList.setBuildContact(false);
            recipientList.buildList(db);
            int runId = -1;
            Iterator iList = recipientList.iterator();
            if (iList.hasNext()) {
                runId = thisCampaign.insertRun(db);
            } else {
                thisCampaign.setStatusId(5);
                thisCampaign.setStatus("No Recipients");
                thisCampaign.setBuildGroupMaps(true);
                thisCampaign.buildUserGroupMaps(db);
                thisCampaign.update(db);
            }
            while (iList.hasNext()) {
                ++campaignCount;
                Recipient thisRecipient = (Recipient)((Object)iList.next());
                if (cp != null) {
                    cp.renew(db);
                }
                Contact thisContact = new Contact(db, thisRecipient.getContactId());
                Notification thisNotification = new Notification();
                thisNotification.setHost((String)this.config.get("MAILSERVER"));
                thisNotification.setContactToNotify(thisContact.getId());
                thisNotification.setModule("Communications Manager");
                thisNotification.setDatabaseName(dbName);
                thisNotification.setItemId(thisCampaign.getId());
                thisNotification.setFileAttachments(attachments);
                thisNotification.setCampaignType(thisCampaign.getType());
                thisNotification.setItemModified(thisCampaign.getActiveDate());
                if (thisNotification.isNew(db)) {
                    thisNotification.setFrom(thisCampaign.getReplyTo());
                    thisNotification.setSubject(thisCampaign.getSubject());
                    thisNotification.setMessageIdToSend(thisCampaign.getMessageId());
                    if (hasBcc) {
                        thisNotification.setBcc(thisCampaign.getBcc());
                        hasBcc = false;
                    }
                    if (hasCc) {
                        thisNotification.setCc(thisCampaign.getCc());
                        hasCc = false;
                    }
                    Template template = new Template();
                    template.setText(thisCampaign.getMessage());
                    String value = template.getValue("surveyId");
                    if (value != null) {
                        template.addParseElement("${surveyId=" + value + "}", URLEncoder.encode(PrivateString.encrypt(thisKey.getKey(), "id=" + value + ",cid=" + thisContact.getId()), "UTF-8"));
                    }
                    if ((value = template.getValue("survey_url_address")) != null) {
                        String serverName = template.getValue("server_name");
                        template.addParseElement("${server_name=" + serverName + "}", "");
                        String addressCurrentURLParameters = URLEncoder.encode(PrivateString.encrypt(thisKey.getKey(), "addressNoChangeId=" + value + ",cid=" + thisContact.getId() + ",campaignId=" + thisCampaign.getId()), "UTF-8");
                        String addressCurrentURL = "If this information is accurate click <a href=\"" + schema + "://" + serverName + "/ProcessAddressSurvey.do?id=" + addressCurrentURLParameters + "\">here</a>";
                        String addressUpdateURLParameters = URLEncoder.encode(PrivateString.encrypt(thisKey.getKey(), "addressSurveyId=" + value + ",cid=" + thisContact.getId() + ",campaignId=" + thisCampaign.getId()), "UTF-8");
                        String addressUpdateURL = ", if you would like to update your contact information click <a href=\"" + schema + "://" + serverName + "/ProcessAddressSurvey.do?id=" + addressUpdateURLParameters + "\">here</a>.";
                        template.addParseElement("${survey_url_address=" + value + "}", "<br />" + addressCurrentURL + addressUpdateURL + "<br />");
                    }
                    if ((value = template.getValue("addressSurveyId")) != null) {
                        template.addParseElement("${addressSurveyId=" + value + "}", URLEncoder.encode(PrivateString.encrypt(thisKey.getKey(), "addressSurveyId=" + value + ",cid=" + thisContact.getId() + ",campaignId=" + thisCampaign.getId()), "UTF-8"));
                    }
                    if ((value = template.getValue("addressNoChangeId")) != null) {
                        template.addParseElement("${addressNoChangeId=" + value + "}", URLEncoder.encode(PrivateString.encrypt(thisKey.getKey(), "addressNoChangeId=" + value + ",cid=" + thisContact.getId() + ",campaignId=" + thisCampaign.getId()), "UTF-8"));
                    }
                    if (thisCampaign.getHasAddressRequest()) {
                        String templateFilePath = (String)this.config.get("FILELIBRARY") + fs + dbName + fs + "templates_" + siteInfo.getLanguage() + ".xml";
                        if (!FileUtils.fileExists(templateFilePath)) {
                            templateFilePath = (String)this.config.get("FILELIBRARY") + fs + dbName + fs + "templates_en_US.xml";
                        }
                        String contactInformation = ContactInformationFormatter.getContactInformation(thisContact, templateFilePath);
                        value = template.getValue("contact_address");
                        if (value != null) {
                            template.addParseElement("${contact_address=" + value + "}", contactInformation != null ? contactInformation : "");
                        }
                    }
                    if ((value = template.getValue("campaignId")) != null) {
                        template.addParseElement("${campaignId=" + value + "}", URLEncoder.encode(PrivateString.encrypt(thisKey.getKey(), "campaignId=" + thisCampaign.getId() + ",cid=" + thisContact.getId()), "UTF-8"));
                    }
                    template.addParseElement("${name}", StringUtils.toHtml(thisContact.getNameFirstLast()));
                    template.addParseElement("${firstname}", StringUtils.toHtml(thisContact.getNameFirst()));
                    template.addParseElement("${lastname}", StringUtils.toHtml(thisContact.getNameLast()));
                    template.addParseElement("${company}", StringUtils.toHtml(thisContact.getCompany()));
                    template.addParseElement("${department}", StringUtils.toHtml(thisContact.getDepartmentName()));
                    String baseURL = template.getValue("baseURL");
                    template.addParseElement("${baseURL=" + baseURL + "}", "");
                    String messageToSend = template.getParsedText();
                    if (baseURL != null && !"".equals(baseURL)) {
                        messageToSend = StringUtils.replace(messageToSend, "src=\"ProcessFileItemImage.do?command=StreamImage", "src=\"http://" + baseURL + "/ProcessFileItemImage.do?command=StreamImage");
                    }
                    thisNotification.setMessageToSend(messageToSend);
                    thisNotification.setType(thisCampaign.getSendMethodId());
                    thisNotification.notifyContact(db);
                    if (thisNotification.getType() == 1 || thisNotification.getType() == 9) {
                        Usage emailUsage = new Usage();
                        emailUsage.setEnteredBy(thisCampaign.getModifiedBy());
                        emailUsage.setAction(3);
                        emailUsage.setRecordId(thisCampaign.getId());
                        emailUsage.setRecordSize(thisNotification.getSize());
                        emailUsage.insert(db);
                    }
                    if (thisNotification.getFaxLogEntry() != null) {
                        faxLog.add(thisNotification.getFaxLogEntry() + "|" + thisCampaign.getEnteredBy() + "|" + thisCampaign.getId());
                    } else if (thisNotification.getContact() != null) {
                        letterLog.add(thisNotification.getContact());
                    }
                    ++notifyCount;
                    ++sentCount;
                    thisRecipient.setRunId(runId);
                    thisRecipient.setSentDate(new Timestamp(System.currentTimeMillis()));
                    thisRecipient.setStatusDate(new Timestamp(System.currentTimeMillis()));
                    thisRecipient.setStatusId(1);
                    thisRecipient.setStatus(thisNotification.getStatus());
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Notifier-> Notification status: " + thisNotification.getStatus());
                    }
                    thisRecipient.update(db);
                }
                if (!thisNotification.hasErrors()) continue;
                System.out.println("Notifier Error 611-> " + thisNotification.getErrorMessage());
            }
            if (campaignCount <= 0) continue;
            this.outputLetterLog(thisCampaign, letterLog, dbName, db);
            this.outputFaxLog(faxLog, db, siteInfo);
            thisCampaign.setStatusId(4);
            thisCampaign.setRecipientCount(campaignCount);
            thisCampaign.setSentCount(sentCount);
            thisCampaign.setBuildGroupMaps(true);
            thisCampaign.buildUserGroupMaps(db);
            thisCampaign.update(db);
        }
        thisReport.setHeader("Communications Report for " + this.start.toString() + lf + "Total Records: " + notifyCount);
        return thisReport.getDelimited();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean outputFaxLog(ArrayList faxLog, Connection db, Site siteInfo) throws Exception {
        if (faxLog == null || faxLog.size() == 0) {
            return false;
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Notifier-> Outputting fax log");
        }
        PrintWriter out = null;
        String baseDirectory = (String)this.config.get("FILELIBRARY") + fs + "faxFiles";
        if (baseDirectory != null && !baseDirectory.equals("")) {
            if (!baseDirectory.endsWith(fs)) {
                baseDirectory = baseDirectory + fs;
            }
            File dir = new File(baseDirectory);
            dir.mkdirs();
        }
        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyyMMddHHmmss");
        String uniqueScript = formatter1.format(new Date());
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(baseDirectory + "cfsfax" + uniqueScript + ".sh")));
            Iterator faxEntries = faxLog.iterator();
            while (faxEntries.hasNext()) {
                String uniqueId = formatter1.format(new Date());
                String thisEntry = (String)faxEntries.next();
                StringTokenizer st = new StringTokenizer(thisEntry, "|");
                String databaseName = st.nextToken();
                String messageId = st.nextToken();
                String faxNumber = st.nextToken();
                String contactId = null;
                if (st.hasMoreTokens()) {
                    contactId = st.nextToken();
                }
                String enteredBy = null;
                if (st.hasMoreTokens()) {
                    enteredBy = st.nextToken();
                }
                String recordId = null;
                if (st.hasMoreTokens()) {
                    recordId = st.nextToken();
                }
                if ("false".equals((String)this.config.get("FAXENABLED"))) continue;
                String baseFilename = baseDirectory + "cfsfax" + uniqueId + messageId + "-" + faxNumber;
                String url = "http://" + siteInfo.getVirtualHost() + "/ProcessMessage.do?code=" + siteInfo.getSiteCode() + "\\&messageId=" + messageId + (contactId != null ? "\\&contactId=" + contactId : "");
                if (HTTPUtils.convertUrlToPostscriptFile(url, baseFilename) == 1 || ImageUtils.convertPostscriptToTiffG3File(baseFilename) == 1) continue;
                File psFile = new File(baseFilename + ".ps");
                psFile.delete();
                out.println("echo \"### SendFax Script, transcript in .log file\"");
                out.println("echo \"# database:" + databaseName + "\"");
                out.println("echo \"# campaignId:" + recordId + "\"");
                out.println("echo \"# enteredBy:" + enteredBy + "\"");
                out.println("echo \"# contactId:" + contactId + "\"");
                out.println("sendfax -n -h " + (String)this.config.get("FAXSERVER") + " " + "-d " + faxNumber + " " + baseFilename + ".tiff > " + baseDirectory + "cfsfax" + uniqueScript + ".log " + "&& rm " + baseFilename + ".tiff ");
                File faxFile = new File(baseFilename + ".tiff");
                if (!faxFile.exists()) continue;
                Usage faxUsage = new Usage();
                faxUsage.setEnteredBy(Integer.parseInt(enteredBy));
                faxUsage.setAction(4);
                faxUsage.setRecordId(Integer.parseInt(recordId));
                faxUsage.setRecordSize(faxFile.length());
                faxUsage.insert(db);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        try {
            Process process = Runtime.getRuntime().exec("/bin/sh " + baseDirectory + "cfsfax" + uniqueScript + ".sh");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return true;
    }

    private boolean outputLetterLog(Campaign thisCampaign, ContactReport contactReport, String dbName, Connection db) throws Exception {
        if (contactReport == null || contactReport.size() == 0) {
            return false;
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Notifier-> Outputting letter log");
        }
        String filePath = (String)this.config.get("FILELIBRARY") + fs + dbName + fs + "campaign" + fs + CFSModule.getDatePath(new Date()) + fs;
        String baseFilename = contactReport.generateFilename();
        File f = new File(filePath);
        f.mkdirs();
        String[] fields = new String[]{"nameLast", "nameMiddle", "nameFirst", "company", "title", "department", "businessPhone", "businessAddress", "city", "state", "zip", "country"};
        contactReport.setCriteria(fields);
        contactReport.setFilePath(filePath);
        contactReport.setEnteredBy(0);
        contactReport.setModifiedBy(0);
        contactReport.setHeader(null);
        contactReport.buildReportBaseInfo();
        contactReport.buildReportHeaders();
        contactReport.buildReportData(null);
        CFSModule.saveTextFile(contactReport.getRep().getHtml(), filePath + baseFilename + ".html");
        ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(filePath + baseFilename));
        ZipUtils.addTextEntry(zip, "contacts-" + baseFilename + ".csv", contactReport.getRep().getDelimited());
        String keyFilePath = (String)this.config.get("FILELIBRARY") + fs + dbName + fs + "keys" + fs;
        File keys = new File(keyFilePath);
        keys.mkdirs();
        PrivateString thisKey = new PrivateString(keyFilePath + "survey2.key");
        Template template = new Template();
        template.setText(thisCampaign.getMessage());
        String value = template.getValue("surveyId");
        if (value != null) {
            template.addParseElement("${surveyId=" + value + "}", URLEncoder.encode(PrivateString.encrypt(thisKey.getKey(), "id=" + value), "UTF-8"));
        }
        ZipUtils.addTextEntry(zip, "letter-" + baseFilename + ".html", template.getParsedText());
        zip.close();
        int fileSize = (int)new File(filePath + baseFilename).length();
        FileItem thisItem = new FileItem();
        thisItem.setLinkModuleId(17);
        thisItem.setLinkItemId(thisCampaign.getId());
        thisItem.setEnteredBy(thisCampaign.getEnteredBy());
        thisItem.setModifiedBy(thisCampaign.getModifiedBy());
        thisItem.setSubject("Campaign Mail Merge");
        thisItem.setVersion(1.0);
        thisItem.setClientFilename("cfs-" + baseFilename + ".zip");
        thisItem.setFilename(baseFilename);
        thisItem.setSize(fileSize);
        thisItem.insert(db);
        return true;
    }

    public String generateCFSUrl(Site siteInfo, String url) {
        String schema = "http";
        if ("true".equals((String)this.config.get("FORCESSL"))) {
            schema = "https";
        }
        return "<a href=\"" + schema + "://" + siteInfo.getVirtualHost() + "/" + url + "\">" + "View in Centric CRM" + "</a>";
    }

    public String generateLink(Site siteInfo, String url) {
        String schema = "http";
        if ("true".equals((String)this.config.get("FORCESSL"))) {
            schema = "https";
        }
        return schema + "://" + siteInfo.getVirtualHost() + "/" + url;
    }

    public ArrayList getTaskList() {
        return this.taskList;
    }

    public Map getConfig() {
        return this.config;
    }
}

