/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.reportRunner;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.utils.AppUtils;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.Dictionary;
import org.aspcfs.utils.SiteUtils;

public class ReportRunner {
    private HashMap config = new HashMap();
    private ArrayList taskList = new ArrayList();
    public static final String fs = System.getProperty("file.separator");
    public static final String lf = System.getProperty("line.separator");

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: ReportRunner [config file]");
            System.out.println("ExitValue: 2");
            System.exit(0);
        }
        System.setProperty("DEBUG", "2");
        ReportRunner thisRunner = new ReportRunner();
        thisRunner.execute(args);
        System.exit(0);
    }

    public static void doTask(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: ReportRunner [config file]");
            System.out.println("ExitValue: 2");
        } else {
            ReportRunner thisRunner = new ReportRunner();
            thisRunner.execute(args);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ExitValue: 0");
            }
        }
    }

    public static void doTask(String[] args, Dictionary dictionary) {
        if (args.length == 0) {
            System.out.println("Usage: ReportRunner [config file]");
            System.out.println("ExitValue: 2");
        } else {
            ReportRunner thisRunner = new ReportRunner();
            thisRunner.execute(args, dictionary);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ExitValue: 0");
            }
        }
    }

    private void execute(String[] args) {
        this.execute(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] args, Dictionary dictionary) {
        String filename = args[0];
        this.taskList.add("org.aspcfs.apps.reportRunner.task.ProcessJasperReports");
        AppUtils.loadConfig(filename, this.config);
        if (this.config.containsKey("FILELIBRARY")) {
            Connection db = null;
            try {
                SiteList siteList = SiteUtils.getSiteList(this.config);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("ReportRunner-> Processing each site (" + siteList.size() + ")");
                }
                for (Site thisSite : siteList) {
                    Class.forName(thisSite.getDatabaseDriver());
                    db = DatabaseUtils.getConnection(thisSite.getDatabaseUrl(), thisSite.getDatabaseUsername(), thisSite.getDatabasePassword());
                    Iterator classes = this.taskList.iterator();
                    while (classes.hasNext()) {
                        try {
                            Class<?> thisClass = Class.forName((String)classes.next());
                            Class[] paramClass = new Class[]{Class.forName("java.sql.Connection"), Site.class, HashMap.class, LinkedHashMap.class};
                            Constructor<?> constructor = thisClass.getConstructor(paramClass);
                            Object[] paramObject = new Object[]{db, thisSite, this.config, dictionary.getLocalizationPrefs()};
                            Object theTask = constructor.newInstance(paramObject);
                            theTask = null;
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                        }
                    }
                    db.close();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace(System.out);
                System.err.println("ReportRunner-> BuildReport Error: " + exc.toString());
            }
            finally {
                if (db != null) {
                    try {
                        db.close();
                        db = null;
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

