/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.reportRunner.task;

import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperRunManager;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.reports.base.QueueCriteriaList;
import org.aspcfs.modules.reports.base.Report;
import org.aspcfs.modules.reports.base.ReportQueue;
import org.aspcfs.modules.reports.base.ReportQueueList;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.JasperReportUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class ProcessJasperReports {
    public static final String fs = System.getProperty("file.separator");
    public static final String CENTRIC_DICTIONARY = "CENTRIC_DICTIONARY";
    public static final String SCRIPT_DB_CONNECTION = "SCRIPT_DB_CONNECTION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessJasperReports(Connection db, Connection scriptdb, Site thisSite, Map config, Map dictionary) throws Exception {
        ReportQueueList queue = new ReportQueueList();
        queue.setSortAscending(true);
        queue.setUnprocessedOnly(true);
        queue.buildList(db);
        for (ReportQueue thisQueue : queue) {
            if (!ReportQueueList.lockReport(thisQueue, db)) continue;
            try {
                String reportDir = "";
                String fontPath = "";
                if (((String)config.get("FILELIBRARY")).indexOf("WEB-INF") > 0) {
                    reportDir = (String)config.get("FILELIBRARY") + ".." + fs + "reports" + fs;
                    fontPath = (String)config.get("FILELIBRARY") + ".." + fs + "fonts" + fs;
                }
                if (config.containsKey("WEB-INF")) {
                    reportDir = (String)config.get("WEB-INF") + "reports" + fs;
                    fontPath = (String)config.get("WEB-INF") + "fonts" + fs;
                }
                if (dictionary == null) {
                    dictionary = new LinkedHashMap();
                }
                String destDir = (String)config.get("FILELIBRARY") + thisSite.getDatabaseName() + fs + "reports-queue" + fs + DateUtils.getDatePath(thisQueue.getEntered());
                File destPath = new File(destDir);
                destPath.mkdirs();
                String filename = DateUtils.getFilename() + "-" + thisQueue.getId();
                long size = ProcessJasperReports.processReport(thisQueue, db, scriptdb, reportDir, destDir + filename, fontPath, dictionary);
                thisQueue.setFilename(filename);
                thisQueue.setSize(size);
                thisQueue.setStatus(2);
                if (!thisQueue.getEmail()) continue;
                User user = new User();
                user.setBuildContact(true);
                user.setBuildContactDetails(true);
                user.buildRecord(db, thisQueue.getEnteredBy());
                SMTPMessage message = new SMTPMessage();
                message.setHost((String)config.get("MAILSERVER"));
                message.setFrom((String)config.get("EMAILADDRESS"));
                message.addReplyTo((String)config.get("EMAILADDRESS"));
                message.addTo(user.getContact().getPrimaryEmailAddress());
                thisQueue.buildReport(db);
                message.setType("text/html");
                String dbName = thisSite.getDatabaseName();
                String templateFilePath = (String)config.get("FILELIBRARY") + fs + dbName + fs + "templates_" + thisSite.getLanguage() + ".xml";
                if (!FileUtils.fileExists(templateFilePath)) {
                    templateFilePath = (String)config.get("FILELIBRARY") + fs + dbName + fs + "templates_en_US.xml";
                }
                File configFile = new File(templateFilePath);
                XMLUtils xml = new XMLUtils(configFile);
                Element mappings = xml.getFirstChild("mappings");
                Template messageSubject = new Template();
                messageSubject.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "report.email.subject")));
                String subject = messageSubject.getParsedText();
                message.setSubject(subject);
                Template messageBody = new Template();
                messageBody.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "report.alert.email.body")));
                String body = messageBody.getParsedText();
                switch (thisQueue.getOutputTypeConstant()) {
                    case 3: {
                        message.setBody(body + StringUtils.loadText(destDir + filename));
                        break;
                    }
                    case 2: {
                        message.setBody(body);
                        message.addFileAttachment(destDir + filename, filename + ".csv");
                        break;
                    }
                    case 1: {
                        message.setBody(body);
                        message.addFileAttachment(destDir + filename, filename + ".pdf");
                        break;
                    }
                    case 4: {
                        message.setBody(body);
                        message.addFileAttachment(destDir + filename, filename + ".xls");
                    }
                }
                message.send();
            }
            catch (Exception e) {
                thisQueue.setStatus(3);
                e.printStackTrace(System.out);
            }
            finally {
                thisQueue.updateStatus(db);
            }
        }
    }

    private static long processReport(ReportQueue thisQueue, Connection db, Connection scriptdb, String path, String destFilename, String fontPath, Map localizationPrefs) throws Exception {
        Report thisReport = new Report(db, thisQueue.getReportId());
        JasperReport jasperReport = JasperReportUtils.getReport(path + thisReport.getFilename());
        QueueCriteriaList criteria = new QueueCriteriaList();
        criteria.setQueueId(thisQueue.getId());
        criteria.buildList(db);
        Map parameters = criteria.getParameters(jasperReport, path);
        parameters.put(CENTRIC_DICTIONARY, localizationPrefs);
        parameters.put(SCRIPT_DB_CONNECTION, scriptdb);
        if (parameters.containsKey("configure_hierarchy_list")) {
            ProcessJasperReports.configureHierarchyList(db, parameters);
        }
        String language = (String)parameters.get("language") + "_" + (String)parameters.get("country");
        JasperReportUtils.modifyFontProperties(jasperReport, path, fontPath, language);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (Connection)db);
        File reportFile = new File(destFilename);
        switch (thisQueue.getOutputTypeConstant()) {
            case 3: {
                JRHtmlExporter exporterHTML = new JRHtmlExporter();
                exporterHTML.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                exporterHTML.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)reportFile);
                exporterHTML.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
                exporterHTML.setParameter((JRExporterParameter)JRHtmlExporterParameter.BETWEEN_PAGES_HTML, (Object)"");
                exporterHTML.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
                exporterHTML.exportReport();
                break;
            }
            case 2: {
                JRCsvExporter exporterCSV = new JRCsvExporter();
                exporterCSV.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                exporterCSV.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)reportFile);
                exporterCSV.exportReport();
                break;
            }
            case 4: {
                JRXlsExporter exporterXls = new JRXlsExporter();
                exporterXls.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                exporterXls.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)reportFile);
                exporterXls.exportReport();
                break;
            }
            default: {
                byte[] bytes = JasperRunManager.runReportToPdf((JasperReport)jasperReport, (Map)parameters, (Connection)db);
                if (reportFile.exists()) {
                    return reportFile.length();
                }
                FileOutputStream destination = new FileOutputStream(reportFile);
                destination.write(bytes, 0, bytes.length);
            }
        }
        if (parameters.containsKey("configure_hierarchy_list")) {
            ProcessJasperReports.removeHierarchyList(db, parameters);
        }
        if (reportFile.exists()) {
            return reportFile.length();
        }
        return -1L;
    }

    private static void configureHierarchyList(Connection db, Map parameters) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ProcessJasperReports-> configureHierarchyList: temp table");
        }
        StringBuffer sql = new StringBuffer();
        int typeId = DatabaseUtils.getType(db);
        if (typeId == 1) {
            sql.append("CREATE TEMPORARY TABLE search_order ( id INT,  user_id INT )");
        } else if (typeId == 6) {
            sql.append("DECLARE GLOBAL TEMPORARY TABLE search_order ( id INT,  user_id INT )ON COMMIT PRESERVE ROWS NOT LOGGED");
        } else if (typeId == 2) {
            sql.append("CREATE TABLE #search_order ( id INT,  user_id INT )");
        } else {
            throw new SQLException("Database Support Missing for Report");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.execute();
        sql = new StringBuffer();
        sql.append("INSERT INTO ").append(DatabaseUtils.getTempTableName(db, "search_order")).append(" (id, user_id) VALUES (?, ?)");
        pst = db.prepareStatement(sql.toString());
        int counter = 0;
        String userIdRange = (String)parameters.get("userid_range");
        if (userIdRange != null) {
            StringTokenizer st = new StringTokenizer(userIdRange, ",");
            while (st.hasMoreTokens()) {
                String userId = st.nextToken().trim();
                pst.setInt(1, ++counter);
                pst.setInt(2, Integer.parseInt(userId));
                pst.execute();
            }
        }
        pst.close();
    }

    private static void removeHierarchyList(Connection db, Map parameters) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DROP TABLE " + DatabaseUtils.getTempTableName(db, "search_order"));
        pst.execute();
        pst.close();
    }
}

