/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.test;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class Database {
    private int runningConnections = 0;
    private int connectionsToExecute = 0;

    public synchronized void runTests() {
        Date startDate = new Date();
        long startMs = System.currentTimeMillis();
        ConnectionPool sqlDriver = null;
        System.out.println("Starting...");
        try {
            sqlDriver = new ConnectionPool();
        }
        catch (SQLException e) {
            // empty catch block
        }
        Connection db = null;
        try {
            sqlDriver.setForceClose(false);
            sqlDriver.setMaxConnections(5);
            ConnectionElement thisElement = new ConnectionElement("jdbc:postgresql://127.0.0.1:5432/cdb_ds21", "postgres", "");
            thisElement.setDriver("org.postgresql.Driver");
            db = sqlDriver.getConnection(thisElement);
            PreparedStatement pst = db.prepareStatement("SELECT COUNT(*) AS contactcount FROM contact WHERE type_id not in (?) and namelast < ?");
            pst.setInt(1, 0);
            pst.setString(2, "b");
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                System.out.println("Records: " + rs.getInt("contactcount"));
            }
            rs.close();
            pst.close();
            sqlDriver.free(db);
            return;
        }
        catch (SQLException e) {
            System.out.println("Error: " + e.toString());
        }
        catch (InterruptedException ie) {
            System.out.println("IE: " + ie.toString());
        }
        sqlDriver.destroy();
        sqlDriver = null;
        Date endDate = new Date();
        long endMs = System.currentTimeMillis();
        System.out.println("Start : " + startDate.toString());
        System.out.println("End   : " + endDate.toString());
        System.out.println("Millis: " + (endMs - startMs) + "ms");
    }

    public synchronized void endThreads() {
        this.notifyAll();
    }

    public static void main(String[] args) {
        Database thisApp = new Database();
        thisApp.runTests();
    }

    class ConnectionThread
    extends Thread {
        private ConnectionPool sqlDriver;
        private String database;
        private int count = 0;
        private String item = null;

        ConnectionThread(String tmp, ConnectionPool sqlDriver, int runCount, String item) {
            this.database = tmp;
            this.sqlDriver = sqlDriver;
            this.count = runCount;
            this.item = item;
        }

        public void run() {
            try {
                ++Database.this.runningConnections;
                ConnectionElement thisElement = new ConnectionElement("jdbc:postgresql://127.0.0.1:5432/" + this.database, "postgres", "");
                Connection db = this.sqlDriver.getConnection(thisElement);
                Statement st = db.createStatement();
                ResultSet rs = st.executeQuery("SELECT * FROM EMPLOYEE");
                while (rs.next()) {
                }
                rs.close();
                st.close();
                this.sqlDriver.free(db);
                --Database.this.runningConnections;
                if (this.count == Database.this.connectionsToExecute - 1 && this.item.equals("D")) {
                    Database.this.endThreads();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

