/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Logger;
import org.aspcfs.apps.transfer.DataImportHandler;
import org.aspcfs.apps.transfer.DataReader;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.XMLUtils;

public class Transfer {
    public static Logger logger = Logger.getLogger(Transfer.class.getName());

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: Transfer [config file]");
            System.exit(2);
        }
        Transfer transfer = new Transfer();
        transfer.execute(args[0]);
        System.exit(0);
    }

    public static void doTask(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: Transfer [config file]");
            System.out.println("ExitValue: 2");
        }
        Transfer transfer = new Transfer();
        transfer.execute(args[0]);
        System.out.println("ExitValue: 0");
    }

    public void execute(String configParam) {
        logger.info("Reading configuration file: " + configParam + "...");
        try {
            File configFile = new File(configParam);
            XMLUtils xml = new XMLUtils(configFile);
            logger.info("Description: " + XMLUtils.getNodeText(XMLUtils.getFirstElement(xml.getDocumentElement(), "description")).trim());
            try {
                String debug = XMLUtils.getNodeText(XMLUtils.getFirstElement(xml.getDocumentElement(), "debug"));
                if (debug != null) {
                    System.setProperty("DEBUG", debug);
                }
            }
            catch (NullPointerException nl) {
                // empty catch block
            }
            String readerClass = XMLUtils.getFirstElement(xml.getDocumentElement(), "reader").getAttribute("class");
            String writerClass = XMLUtils.getFirstElement(xml.getDocumentElement(), "writer").getAttribute("class");
            logger.info("Reader: " + readerClass);
            logger.info("Writer: " + writerClass);
            if (StringUtils.hasText(readerClass) && StringUtils.hasText(writerClass)) {
                Object reader = Class.forName(readerClass).newInstance();
                HashMap invalidReaderProperties = XMLUtils.populateObject(reader, XMLUtils.getFirstElement(xml.getDocumentElement(), "reader"));
                this.displayItems(invalidReaderProperties, "Invalid Reader Property");
                if (!this.validateHandler(reader)) {
                    logger.info("Reader has not been configured");
                } else {
                    Object writer = Class.forName(writerClass).newInstance();
                    HashMap invalidWriterProperties = XMLUtils.populateObject(writer, XMLUtils.getFirstElement(xml.getDocumentElement(), "writer"));
                    this.displayItems(invalidWriterProperties, "Invalid Writer Property");
                    if (!this.validateHandler(writer)) {
                        logger.info("Writer has not been configured");
                    } else {
                        ((DataReader)reader).execute((DataWriter)writer);
                        ((DataWriter)writer).close();
                    }
                }
            } else {
                logger.info("A Reader and Writer need to be specified in the configuration file");
            }
        }
        catch (Exception e) {
            logger.info("Error: " + e.toString());
        }
    }

    private void displayItems(HashMap itemList, String displayText) {
        if (itemList.size() > 0) {
            for (String param : itemList.keySet()) {
                if (param == null || param.indexOf("^Guid") != -1) continue;
                logger.info(displayText + ": " + param);
            }
        }
    }

    private boolean validateHandler(Object handler) {
        return ((DataImportHandler)handler).isConfigured();
    }
}

