/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader;

import java.io.File;
import java.util.ArrayList;
import org.aspcfs.apps.transfer.DataField;
import org.aspcfs.apps.transfer.DataReader;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class CFSXMLReader
implements DataReader {
    protected String xmlDataFile = null;

    public String getXmlDataFile() {
        return this.xmlDataFile;
    }

    public void setXmlDataFile(String tmp) {
        this.xmlDataFile = tmp;
    }

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "Backup Reader";
    }

    public String getDescription() {
        return "Coded test data";
    }

    public boolean isConfigured() {
        boolean configOK = true;
        File importFile = new File(this.xmlDataFile);
        if (!importFile.exists()) {
            logger.info("CFSXMLReader-> Config: file not found: " + this.xmlDataFile);
            configOK = false;
        }
        return configOK;
    }

    public boolean execute(DataWriter writer) {
        boolean processOK = true;
        try {
            File configFile = new File(this.xmlDataFile);
            XMLUtils xml = new XMLUtils(configFile);
            ArrayList recordList = new ArrayList();
            XMLUtils.getAllChildren(xml.getFirstChild("cfsdata"), "dataRecord", recordList);
            logger.info("Records: " + recordList.size());
            for (Element record : recordList) {
                DataRecord thisRecord = new DataRecord();
                thisRecord.setName(record.getAttribute("name"));
                thisRecord.setAction(record.getAttribute("action"));
                thisRecord.setShareKey(StringUtils.isTrue(record.getAttribute("shareKey")));
                ArrayList fieldList = new ArrayList();
                XMLUtils.getAllChildren(record, "dataField", fieldList);
                for (Element field : fieldList) {
                    DataField thisField = new DataField();
                    thisField.setName(field.getAttribute("name"));
                    thisField.setAlias(field.getAttribute("alias"));
                    thisField.setValueLookup(field.getAttribute("valueLookup"));
                    thisField.setValue(XMLUtils.getNodeText(field));
                    thisRecord.add(thisField);
                }
                processOK = writer.save(thisRecord);
                if (processOK) continue;
                break;
            }
        }
        catch (Exception e) {
            logger.info(e.toString());
            e.printStackTrace(System.out);
            return false;
        }
        return processOK;
    }
}

