/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.csvreader.CSVReader;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationAddress;
import org.aspcfs.modules.accounts.base.OrganizationAddressList;
import org.aspcfs.modules.accounts.base.OrganizationPhoneNumber;
import org.aspcfs.modules.accounts.base.OrganizationPhoneNumberList;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.formatter.AddressFormatter;
import org.aspcfs.utils.formatter.EmailAddressFormatter;
import org.aspcfs.utils.formatter.PhoneNumberFormatter;

public class ImportAccounts
extends CSVReader {
    private int KEY_COMPANY = 0;
    private int OWNER = 0;
    private int COMPANY_NAME = 0;
    private int BUSINESS_ADDRESS_1 = 0;
    private int BUSINESS_ADDRESS_2 = 0;
    private int BUSINESS_ADDRESS_3 = 0;
    private int BUSINESS_CITY = 0;
    private int BUSINESS_STATE = 0;
    private int BUSINESS_ZIP = 0;
    private int BUSINESS_COUNTRY = 0;
    private int HOME_ADDRESS_1 = 0;
    private int HOME_ADDRESS_2 = 0;
    private int HOME_ADDRESS_3 = 0;
    private int HOME_CITY = 0;
    private int HOME_STATE = 0;
    private int HOME_ZIP = 0;
    private int HOME_COUNTRY = 0;
    private int BUSINESS_PHONE = 0;
    private int BUSINESS_2_PHONE = 0;
    private int BUSINESS_FAX = 0;
    private int HOME_PHONE = 0;
    private int HOME_2_PHONE = 0;
    private int HOME_FAX = 0;
    private int MOBILE_PHONE = 0;
    private int OTHER_PHONE = 0;
    private int PAGER = 0;
    private int BUSINESS_EMAIL = 0;
    private int PERSONAL_EMAIL = 0;
    private int OTHER_EMAIL = 0;
    private int NOTES = 0;
    private int URL = 0;
    private int MODIFIED = 0;
    private int ENTERED = 0;
    private int SEGMENT_ID = 0;
    private int COMPANY_SIZE_ID = 0;
    private int DIRECT_BILL = 0;

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "Centric CRM Accounts Importer";
    }

    public String getDescription() {
        return "Reads accounts from a text file based on specifications";
    }

    public boolean execute(DataWriter writer) {
        boolean processOK = true;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("import.out", false)));
            int userId = 1;
            int contactId = 1;
            int orgId = 1;
            DataRecord newUserRecord = new DataRecord();
            newUserRecord.setName("user");
            newUserRecord.setAction("insert");
            newUserRecord.addField("guid", userId);
            newUserRecord.addField("username", "Electronic Import");
            newUserRecord.addField("encryptedPassword", "none");
            newUserRecord.addField("enteredBy", userId);
            newUserRecord.addField("modifiedBy", userId);
            writer.save(newUserRecord);
            DataRecord newContactRecord = new DataRecord();
            newContactRecord.setName("contact");
            newContactRecord.setAction("insert");
            newContactRecord.addField("guid", contactId);
            newContactRecord.addField("accessType", "2");
            newContactRecord.addField("userId", userId, "user", null);
            newContactRecord.addField("nameFirst", "");
            newContactRecord.addField("nameLast", "Electronic Import");
            newContactRecord.addField("orgId", "0");
            newContactRecord.addField("enteredBy", userId);
            newContactRecord.addField("modifiedBy", userId);
            newContactRecord.addField("enabled", "false");
            writer.save(newContactRecord);
            AddressFormatter addressFormatter = new AddressFormatter();
            EmailAddressFormatter emailFormatter = new EmailAddressFormatter();
            PhoneNumberFormatter phoneFormatter = new PhoneNumberFormatter();
            ArrayList thisRecord = null;
            BufferedReader in = new BufferedReader(new FileReader(this.csvFile));
            String line = null;
            int lineNumber = 0;
            while ((line = in.readLine()) != null) {
                Locale thisLocale;
                thisRecord = new ArrayList(StringUtils.parseExcelCSVLine(line));
                if (++lineNumber == 1) {
                    this.KEY_COMPANY = this.findColumn(thisRecord, new String[]{"KEY_COMPANY"});
                    this.OWNER = this.findColumn(thisRecord, new String[]{"OWNER", "Owner"});
                    this.COMPANY_NAME = this.findColumn(thisRecord, new String[]{"COMPANY_NAME", "Company", "Company Name", "Account Name"});
                    this.BUSINESS_ADDRESS_1 = this.findColumn(thisRecord, new String[]{"BUSINESS_ADDRESS_1", "Business Address Line 1", "Mailing Street"});
                    this.BUSINESS_ADDRESS_2 = this.findColumn(thisRecord, new String[]{"BUSINESS_ADDRESS_2", "Business Address Line 2", "Mailing Address Line2"});
                    this.BUSINESS_ADDRESS_3 = this.findColumn(thisRecord, new String[]{"BUSINESS_ADDRESS_3", "Business Address Line 3", "Mailing Address Line3"});
                    this.BUSINESS_CITY = this.findColumn(thisRecord, new String[]{"BUSINESS_CITY", "BusinessCity", "Business City", "Mailing City"});
                    this.BUSINESS_STATE = this.findColumn(thisRecord, new String[]{"BUSINESS_STATE", "Business State", "Business State/Province", "Mailing State"});
                    this.BUSINESS_ZIP = this.findColumn(thisRecord, new String[]{"BUSINESS_ZIP", "Business Zip", "Business Postal Code", "Mailing Zip/Postal Code"});
                    this.BUSINESS_COUNTRY = this.findColumn(thisRecord, new String[]{"BUSINES_COUNTRY", "Business Country", "Mailing Country"});
                    this.HOME_ADDRESS_1 = this.findColumn(thisRecord, new String[]{"HOME_ADDRESS_1", "Home Address Line 1"});
                    this.HOME_ADDRESS_2 = this.findColumn(thisRecord, new String[]{"HOME_ADDRESS_2", "Home Address Line 2"});
                    this.HOME_ADDRESS_3 = this.findColumn(thisRecord, new String[]{"HOME_ADDRESS_3", "Home Address Line 3"});
                    this.HOME_CITY = this.findColumn(thisRecord, new String[]{"HOME_CITY", "HomeCity", "Home City"});
                    this.HOME_STATE = this.findColumn(thisRecord, new String[]{"HOME_STATE", "Home State/Province"});
                    this.HOME_ZIP = this.findColumn(thisRecord, new String[]{"HOME_ZIP", "Home Postal Code"});
                    this.HOME_COUNTRY = this.findColumn(thisRecord, new String[]{"HOME_COUNTRY", "Home Country"});
                    this.BUSINESS_PHONE = this.findColumn(thisRecord, new String[]{"BUSINESS_PHONE", "BusinessPhone", "Business Phone", "Phone"});
                    this.BUSINESS_2_PHONE = this.findColumn(thisRecord, new String[]{"BUSINESS_2_PHONE", "Business2 Phone"});
                    this.BUSINESS_FAX = this.findColumn(thisRecord, new String[]{"BUSINESS_FAX", "BusinessFax", "Business Fax", "Fax"});
                    this.HOME_PHONE = this.findColumn(thisRecord, new String[]{"HOME_HOME", "Home Phone"});
                    this.HOME_2_PHONE = this.findColumn(thisRecord, new String[]{"HOME_2_PHONE", "Home2 Phone"});
                    this.HOME_FAX = this.findColumn(thisRecord, new String[]{"HOME_FAX", "Home Fax"});
                    this.MOBILE_PHONE = this.findColumn(thisRecord, new String[]{"MOBILE_PHONE", "Mobile Phone", "Mobile"});
                    this.OTHER_PHONE = this.findColumn(thisRecord, new String[]{"OTHER_PHONE", "Other Phone"});
                    this.PAGER = this.findColumn(thisRecord, new String[]{"PAGER", "Pager"});
                    this.BUSINESS_EMAIL = this.findColumn(thisRecord, new String[]{"BUSINESS_EMAIL", "Business Email", "Email"});
                    this.PERSONAL_EMAIL = this.findColumn(thisRecord, new String[]{"PERSONAL_EMAIL", "Home Email", "Personal Email"});
                    this.OTHER_EMAIL = this.findColumn(thisRecord, new String[]{"OTHER_EMAIL", "Other Email"});
                    this.NOTES = this.findColumn(thisRecord, new String[]{"NOTES", "Notes"});
                    this.URL = this.findColumn(thisRecord, new String[]{"URL", "WEB_ADDRESS"});
                    this.MODIFIED = this.findColumn(thisRecord, new String[]{"DATE_MODIFIED", "Modified"});
                    this.ENTERED = this.findColumn(thisRecord, new String[]{"DATE_ENTERED", "Entered"});
                    this.SEGMENT_ID = this.findColumn(thisRecord, new String[]{"SEGMENT_ID"});
                    this.COMPANY_SIZE_ID = this.findColumn(thisRecord, new String[]{"COMPANY_SIZE_ID"});
                    this.DIRECT_BILL = this.findColumn(thisRecord, new String[]{"DIRECT_BILL"});
                    continue;
                }
                ++orgId;
                Organization thisOrganization = new Organization();
                OrganizationPhoneNumberList organizationNumberList = thisOrganization.getPhoneNumberList();
                OrganizationAddressList organizationAddressList = thisOrganization.getAddressList();
                thisOrganization.setEnteredBy(userId);
                if (this.OWNER > 0) {
                    thisOrganization.setOwner(this.getValue(thisRecord, this.OWNER));
                } else {
                    thisOrganization.setOwner(userId);
                }
                thisOrganization.setModifiedBy(userId);
                thisOrganization.setModified(this.getValue(thisRecord, this.MODIFIED));
                thisOrganization.setEntered(this.getValue(thisRecord, this.ENTERED));
                thisOrganization.setName(this.getValue(thisRecord, this.COMPANY_NAME));
                thisOrganization.setNotes(this.getValue(thisRecord, this.NOTES));
                thisOrganization.setUrl(this.getValue(thisRecord, this.URL));
                if (this.getValue(thisRecord, this.SEGMENT_ID) != null) {
                    thisOrganization.setSegmentId(this.getValue(thisRecord, this.SEGMENT_ID));
                }
                if (this.getValue(thisRecord, this.COMPANY_SIZE_ID) != null) {
                    thisOrganization.setAccountSize(this.getValue(thisRecord, this.COMPANY_SIZE_ID));
                }
                if (this.getValue(thisRecord, this.DIRECT_BILL) != null) {
                    thisOrganization.setDirectBill(this.getValue(thisRecord, this.DIRECT_BILL));
                }
                if (this.getValue(thisRecord, this.KEY_COMPANY) != null) {
                    thisOrganization.setOrgId(this.getValue(thisRecord, this.KEY_COMPANY));
                } else {
                    thisOrganization.setOrgId(orgId);
                }
                OrganizationAddress organizationAddress = new OrganizationAddress();
                organizationAddress.setOrgId(thisOrganization.getOrgId());
                organizationAddress.setType(1);
                organizationAddress.setEnteredBy(userId);
                organizationAddress.setModifiedBy(userId);
                organizationAddress.setStreetAddressLine1(this.getValue(thisRecord, this.BUSINESS_ADDRESS_1));
                organizationAddress.setStreetAddressLine2(this.getValue(thisRecord, this.BUSINESS_ADDRESS_2));
                organizationAddress.setStreetAddressLine3(this.getValue(thisRecord, this.BUSINESS_ADDRESS_3));
                organizationAddress.setCity(this.getValue(thisRecord, this.BUSINESS_CITY));
                organizationAddress.setState(this.getValue(thisRecord, this.BUSINESS_STATE));
                organizationAddress.setZip(this.getValue(thisRecord, this.BUSINESS_ZIP));
                organizationAddress.setCountry(this.getValue(thisRecord, this.BUSINESS_COUNTRY));
                if (organizationAddress.isValid()) {
                    addressFormatter.format(organizationAddress);
                    organizationAddressList.add(organizationAddress);
                }
                if ((thisLocale = organizationAddress.getLocale()) == null) {
                    thisLocale = organizationAddress.getLocale();
                }
                OrganizationPhoneNumber organizationPhone = new OrganizationPhoneNumber();
                organizationPhone.setOrgId(thisOrganization.getOrgId());
                organizationPhone.setType(1);
                organizationPhone.setEnteredBy(userId);
                organizationPhone.setModifiedBy(userId);
                organizationPhone.setNumber(this.getValue(thisRecord, this.BUSINESS_PHONE));
                if (organizationPhone.isValid()) {
                    PhoneNumberFormatter.format(organizationPhone, thisLocale);
                    organizationNumberList.add(organizationPhone);
                }
                OrganizationPhoneNumber organizationFax = new OrganizationPhoneNumber();
                organizationFax.setOrgId(thisOrganization.getOrgId());
                organizationFax.setType(2);
                organizationFax.setEnteredBy(userId);
                organizationFax.setModifiedBy(userId);
                organizationFax.setNumber(this.getValue(thisRecord, this.BUSINESS_FAX));
                if (organizationFax.isValid()) {
                    PhoneNumberFormatter.format(organizationFax, thisLocale);
                    organizationNumberList.add(organizationFax);
                }
                processOK = writer.save(this.mappings.createDataRecord((Object)thisOrganization, "insert"));
                boolean processOK2 = true;
                boolean processOK3 = true;
                if (processOK) {
                    processOK2 = this.mappings.saveList(writer, organizationAddressList, "insert");
                    processOK3 = this.mappings.saveList(writer, organizationNumberList, "insert");
                }
                if (processOK && processOK2 && processOK3) continue;
                this.writeln(out, thisRecord);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.info("ImportAccounts-> Error: " + e.toString());
            e.printStackTrace(System.out);
            processOK = false;
        }
        return processOK;
    }
}

