/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.csvreader.CSVReader;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactAddress;
import org.aspcfs.modules.contacts.base.ContactAddressList;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.contacts.base.ContactPhoneNumberList;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.formatter.AddressFormatter;
import org.aspcfs.utils.formatter.EmailAddressFormatter;
import org.aspcfs.utils.formatter.PhoneNumberFormatter;

public class ImportGeneralContacts
extends CSVReader {
    private int OWNER = 0;
    private int NAME_SALUTATION = 0;
    private int FIRST_NAME = 0;
    private int MIDDLE_NAME = 0;
    private int LAST_NAME = 0;
    private int SUFFIX = 0;
    private int COMPANY_NAME = 0;
    private int TITLE = 0;
    private int BUSINESS_ADDRESS_1 = 0;
    private int BUSINESS_ADDRESS_2 = 0;
    private int BUSINESS_ADDRESS_3 = 0;
    private int BUSINESS_CITY = 0;
    private int BUSINESS_STATE = 0;
    private int BUSINESS_ZIP = 0;
    private int BUSINESS_COUNTRY = 0;
    private int HOME_ADDRESS_1 = 0;
    private int HOME_ADDRESS_2 = 0;
    private int HOME_ADDRESS_3 = 0;
    private int HOME_CITY = 0;
    private int HOME_STATE = 0;
    private int HOME_ZIP = 0;
    private int HOME_COUNTRY = 0;
    private int BUSINESS_PHONE = 0;
    private int BUSINESS_2_PHONE = 0;
    private int BUSINESS_FAX = 0;
    private int HOME_PHONE = 0;
    private int HOME_2_PHONE = 0;
    private int HOME_FAX = 0;
    private int MOBILE_PHONE = 0;
    private int OTHER_PHONE = 0;
    private int PAGER = 0;
    private int BUSINESS_EMAIL = 0;
    private int PERSONAL_EMAIL = 0;
    private int OTHER_EMAIL = 0;
    private int NOTES = 0;

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "Centric CRM General Contacts Importer";
    }

    public String getDescription() {
        return "Reads general contacts from a text file based on specifications";
    }

    public boolean execute(DataWriter writer) {
        boolean processOK = true;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("import.out", false)));
            int userId = 1;
            int contactId = 1;
            DataRecord newUserRecord = new DataRecord();
            newUserRecord.setName("user");
            newUserRecord.setAction("insert");
            newUserRecord.addField("guid", userId);
            newUserRecord.addField("username", "Electronic Import");
            newUserRecord.addField("encryptedPassword", "none");
            newUserRecord.addField("enteredBy", userId);
            newUserRecord.addField("modifiedBy", userId);
            writer.save(newUserRecord);
            DataRecord newContactRecord = new DataRecord();
            newContactRecord.setName("contact");
            newContactRecord.setAction("insert");
            newContactRecord.addField("guid", contactId);
            newContactRecord.addField("accessType", "2");
            newContactRecord.addField("userId", userId, "user", null);
            newContactRecord.addField("nameFirst", "");
            newContactRecord.addField("nameLast", "Electronic Import");
            newContactRecord.addField("orgId", "0");
            newContactRecord.addField("enteredBy", userId);
            newContactRecord.addField("modifiedBy", userId);
            newContactRecord.addField("enabled", "false");
            writer.save(newContactRecord);
            AddressFormatter addressFormatter = new AddressFormatter();
            EmailAddressFormatter emailFormatter = new EmailAddressFormatter();
            PhoneNumberFormatter phoneFormatter = new PhoneNumberFormatter();
            BufferedReader in = new BufferedReader(new FileReader(this.csvFile));
            String line = null;
            int lineNumber = 0;
            while ((line = in.readLine()) != null) {
                Locale thisLocale;
                ArrayList thisRecord = new ArrayList(StringUtils.parseExcelCSVLine(line));
                if (++lineNumber == 1) {
                    this.OWNER = this.findColumn(thisRecord, new String[]{"OWNER", "Owner"});
                    this.NAME_SALUTATION = this.findColumn(thisRecord, new String[]{"NAME_SALUTATION", "Salutation"});
                    this.FIRST_NAME = this.findColumn(thisRecord, new String[]{"FIRST_NAME", "FirstName", "First Name"});
                    this.MIDDLE_NAME = this.findColumn(thisRecord, new String[]{"MIDDLE_NAME", "Middle Name"});
                    this.LAST_NAME = this.findColumn(thisRecord, new String[]{"LAST_NAME", "LastName", "Last Name"});
                    this.SUFFIX = this.findColumn(thisRecord, new String[]{"SUFFIX", "Suffix"});
                    this.COMPANY_NAME = this.findColumn(thisRecord, new String[]{"COMPANY_NAME", "Company", "Company Name", "Account Name"});
                    this.TITLE = this.findColumn(thisRecord, new String[]{"TITLE", "Title"});
                    this.BUSINESS_ADDRESS_1 = this.findColumn(thisRecord, new String[]{"BUSINESS_ADDRESS_1", "Business Address Line 1", "Mailing Street"});
                    this.BUSINESS_ADDRESS_2 = this.findColumn(thisRecord, new String[]{"BUSINESS_ADDRESS_2", "Business Address Line 2", "Mailing Address Line2"});
                    this.BUSINESS_ADDRESS_3 = this.findColumn(thisRecord, new String[]{"BUSINESS_ADDRESS_3", "Business Address Line 3", "Mailing Address Line3"});
                    this.BUSINESS_CITY = this.findColumn(thisRecord, new String[]{"BUSINESS_CITY", "BusinessCity", "Business City", "Mailing City"});
                    this.BUSINESS_STATE = this.findColumn(thisRecord, new String[]{"BUSINESS_STATE", "Business State", "Business State/Province", "Mailing State"});
                    this.BUSINESS_ZIP = this.findColumn(thisRecord, new String[]{"BUSINESS_ZIP", "Business Zip", "Business Postal Code", "Mailing Zip/Postal Code"});
                    this.BUSINESS_COUNTRY = this.findColumn(thisRecord, new String[]{"BUSINES_COUNTRY", "Business Country", "Mailing Country"});
                    this.HOME_ADDRESS_1 = this.findColumn(thisRecord, new String[]{"HOME_ADDRESS_1", "Home Address Line 1"});
                    this.HOME_ADDRESS_2 = this.findColumn(thisRecord, new String[]{"HOME_ADDRESS_2", "Home Address Line 2"});
                    this.HOME_ADDRESS_3 = this.findColumn(thisRecord, new String[]{"HOME_ADDRESS_3", "Home Address Line 3"});
                    this.HOME_CITY = this.findColumn(thisRecord, new String[]{"HOME_CITY", "HomeCity", "Home City"});
                    this.HOME_STATE = this.findColumn(thisRecord, new String[]{"HOME_STATE", "Home State/Province"});
                    this.HOME_ZIP = this.findColumn(thisRecord, new String[]{"HOME_ZIP", "Home Postal Code"});
                    this.HOME_COUNTRY = this.findColumn(thisRecord, new String[]{"HOME_COUNTRY", "Home Country"});
                    this.BUSINESS_PHONE = this.findColumn(thisRecord, new String[]{"BUSINESS_PHONE", "BusinessPhone", "Business Phone", "Phone"});
                    this.BUSINESS_2_PHONE = this.findColumn(thisRecord, new String[]{"BUSINESS_2_PHONE", "Business2 Phone"});
                    this.BUSINESS_FAX = this.findColumn(thisRecord, new String[]{"BUSINESS_FAX", "BusinessFax", "Business Fax", "Fax"});
                    this.HOME_PHONE = this.findColumn(thisRecord, new String[]{"HOME_HOME", "Home Phone"});
                    this.HOME_2_PHONE = this.findColumn(thisRecord, new String[]{"HOME_2_PHONE", "Home2 Phone"});
                    this.HOME_FAX = this.findColumn(thisRecord, new String[]{"HOME_FAX", "Home Fax"});
                    this.MOBILE_PHONE = this.findColumn(thisRecord, new String[]{"MOBILE_PHONE", "Mobile Phone", "Mobile"});
                    this.OTHER_PHONE = this.findColumn(thisRecord, new String[]{"OTHER_PHONE", "Other Phone"});
                    this.PAGER = this.findColumn(thisRecord, new String[]{"PAGER", "Pager"});
                    this.BUSINESS_EMAIL = this.findColumn(thisRecord, new String[]{"BUSINESS_EMAIL", "Business Email", "Email"});
                    this.PERSONAL_EMAIL = this.findColumn(thisRecord, new String[]{"PERSONAL_EMAIL", "Home Email", "Personal Email"});
                    this.OTHER_EMAIL = this.findColumn(thisRecord, new String[]{"OTHER_EMAIL", "Other Email"});
                    this.NOTES = this.findColumn(thisRecord, new String[]{"NOTES", "Notes"});
                    continue;
                }
                ++contactId;
                Contact thisContact = new Contact();
                ContactEmailAddressList emailAddressList = thisContact.getEmailAddressList();
                ContactPhoneNumberList phoneNumberList = thisContact.getPhoneNumberList();
                ContactAddressList addressList = thisContact.getAddressList();
                thisContact.setAccessType(1);
                thisContact.setId(contactId);
                thisContact.setEnteredBy(userId);
                if (this.OWNER > 0) {
                    thisContact.setOwner(this.getValue(thisRecord, this.OWNER));
                } else {
                    thisContact.setOwner(userId);
                }
                thisContact.setModifiedBy(userId);
                thisContact.setNameSalutation(this.getValue(thisRecord, this.NAME_SALUTATION));
                thisContact.setNameFirst(this.getValue(thisRecord, this.FIRST_NAME));
                thisContact.setNameMiddle(this.getValue(thisRecord, this.MIDDLE_NAME));
                thisContact.setNameLast(this.getValue(thisRecord, this.LAST_NAME));
                thisContact.setNameSuffix(this.getValue(thisRecord, this.SUFFIX));
                thisContact.setCompany(this.getValue(thisRecord, this.COMPANY_NAME));
                thisContact.setTitle(this.getValue(thisRecord, this.TITLE));
                ContactAddress businessAddress = new ContactAddress();
                businessAddress.setContactId(contactId);
                businessAddress.setType(1);
                businessAddress.setEnteredBy(userId);
                businessAddress.setModifiedBy(userId);
                businessAddress.setStreetAddressLine1(this.getValue(thisRecord, this.BUSINESS_ADDRESS_1));
                businessAddress.setStreetAddressLine2(this.getValue(thisRecord, this.BUSINESS_ADDRESS_2));
                businessAddress.setStreetAddressLine3(this.getValue(thisRecord, this.BUSINESS_ADDRESS_3));
                businessAddress.setCity(this.getValue(thisRecord, this.BUSINESS_CITY));
                businessAddress.setState(this.getValue(thisRecord, this.BUSINESS_STATE));
                businessAddress.setZip(this.getValue(thisRecord, this.BUSINESS_ZIP));
                businessAddress.setCountry(this.getValue(thisRecord, this.BUSINESS_COUNTRY));
                if (businessAddress.isValid()) {
                    addressFormatter.format(businessAddress);
                    addressList.add(businessAddress);
                }
                ContactAddress homeAddress = new ContactAddress();
                homeAddress.setContactId(contactId);
                homeAddress.setType(2);
                homeAddress.setEnteredBy(userId);
                homeAddress.setModifiedBy(userId);
                homeAddress.setStreetAddressLine1(this.getValue(thisRecord, this.HOME_ADDRESS_1));
                homeAddress.setStreetAddressLine2(this.getValue(thisRecord, this.HOME_ADDRESS_2));
                homeAddress.setStreetAddressLine3(this.getValue(thisRecord, this.HOME_ADDRESS_3));
                homeAddress.setCity(this.getValue(thisRecord, this.HOME_CITY));
                homeAddress.setState(this.getValue(thisRecord, this.HOME_STATE));
                homeAddress.setZip(this.getValue(thisRecord, this.HOME_ZIP));
                homeAddress.setCountry(this.getValue(thisRecord, this.HOME_COUNTRY));
                if (homeAddress.isValid()) {
                    addressFormatter.format(homeAddress);
                    addressList.add(homeAddress);
                }
                if ((thisLocale = businessAddress.getLocale()) == null) {
                    thisLocale = homeAddress.getLocale();
                }
                ContactPhoneNumber businessPhone = new ContactPhoneNumber();
                businessPhone.setContactId(contactId);
                businessPhone.setType(1);
                businessPhone.setEnteredBy(userId);
                businessPhone.setModifiedBy(userId);
                businessPhone.setNumber(this.getValue(thisRecord, this.BUSINESS_PHONE));
                if (businessPhone.isValid()) {
                    PhoneNumberFormatter.format(businessPhone, thisLocale);
                    phoneNumberList.add(businessPhone);
                }
                ContactPhoneNumber business2Phone = new ContactPhoneNumber();
                business2Phone.setContactId(contactId);
                business2Phone.setType(2);
                business2Phone.setEnteredBy(userId);
                business2Phone.setModifiedBy(userId);
                business2Phone.setNumber(this.getValue(thisRecord, this.BUSINESS_2_PHONE));
                if (business2Phone.isValid()) {
                    PhoneNumberFormatter.format(business2Phone, thisLocale);
                    phoneNumberList.add(business2Phone);
                }
                ContactPhoneNumber businessFax = new ContactPhoneNumber();
                businessFax.setContactId(contactId);
                businessFax.setType(3);
                businessFax.setEnteredBy(userId);
                businessFax.setModifiedBy(userId);
                businessFax.setNumber(this.getValue(thisRecord, this.BUSINESS_FAX));
                if (businessFax.isValid()) {
                    PhoneNumberFormatter.format(businessFax, thisLocale);
                    phoneNumberList.add(businessFax);
                }
                ContactPhoneNumber homePhone = new ContactPhoneNumber();
                homePhone.setContactId(contactId);
                homePhone.setType(4);
                homePhone.setEnteredBy(userId);
                homePhone.setModifiedBy(userId);
                homePhone.setNumber(this.getValue(thisRecord, this.HOME_PHONE));
                if (homePhone.isValid()) {
                    PhoneNumberFormatter.format(homePhone, thisLocale);
                    phoneNumberList.add(homePhone);
                }
                ContactPhoneNumber home2Phone = new ContactPhoneNumber();
                home2Phone.setContactId(contactId);
                home2Phone.setType(5);
                home2Phone.setEnteredBy(userId);
                home2Phone.setModifiedBy(userId);
                home2Phone.setNumber(this.getValue(thisRecord, this.HOME_2_PHONE));
                if (home2Phone.isValid()) {
                    PhoneNumberFormatter.format(home2Phone, thisLocale);
                    phoneNumberList.add(home2Phone);
                }
                ContactPhoneNumber homeFax = new ContactPhoneNumber();
                homeFax.setContactId(contactId);
                homeFax.setType(6);
                homeFax.setEnteredBy(userId);
                homeFax.setModifiedBy(userId);
                homeFax.setNumber(this.getValue(thisRecord, this.HOME_FAX));
                if (homeFax.isValid()) {
                    PhoneNumberFormatter.format(homeFax, thisLocale);
                    phoneNumberList.add(homeFax);
                }
                ContactPhoneNumber mobilePhone = new ContactPhoneNumber();
                mobilePhone.setContactId(contactId);
                mobilePhone.setType(7);
                mobilePhone.setEnteredBy(userId);
                mobilePhone.setModifiedBy(userId);
                mobilePhone.setNumber(this.getValue(thisRecord, this.MOBILE_PHONE));
                if (mobilePhone.isValid()) {
                    PhoneNumberFormatter.format(mobilePhone, thisLocale);
                    phoneNumberList.add(mobilePhone);
                }
                ContactPhoneNumber otherPhone = new ContactPhoneNumber();
                otherPhone.setContactId(contactId);
                otherPhone.setType(9);
                otherPhone.setEnteredBy(userId);
                otherPhone.setModifiedBy(userId);
                otherPhone.setNumber(this.getValue(thisRecord, this.OTHER_PHONE));
                if (otherPhone.isValid()) {
                    PhoneNumberFormatter.format(otherPhone, thisLocale);
                    phoneNumberList.add(otherPhone);
                }
                ContactPhoneNumber pager = new ContactPhoneNumber();
                pager.setContactId(contactId);
                pager.setType(8);
                pager.setEnteredBy(userId);
                pager.setModifiedBy(userId);
                pager.setNumber(this.getValue(thisRecord, this.PAGER));
                if (pager.isValid()) {
                    PhoneNumberFormatter.format(pager, thisLocale);
                    phoneNumberList.add(pager);
                }
                ContactEmailAddress businessEmail = new ContactEmailAddress();
                businessEmail.setContactId(contactId);
                businessEmail.setType(1);
                businessEmail.setEnteredBy(userId);
                businessEmail.setModifiedBy(userId);
                businessEmail.setEmail(this.getValue(thisRecord, this.BUSINESS_EMAIL));
                if (businessEmail.isValid()) {
                    emailFormatter.format(businessEmail);
                    emailAddressList.add(businessEmail);
                }
                ContactEmailAddress personalEmail = new ContactEmailAddress();
                personalEmail.setContactId(contactId);
                personalEmail.setType(2);
                personalEmail.setEnteredBy(userId);
                personalEmail.setModifiedBy(userId);
                personalEmail.setEmail(this.getValue(thisRecord, this.PERSONAL_EMAIL));
                if (personalEmail.isValid()) {
                    emailFormatter.format(personalEmail);
                    emailAddressList.add(personalEmail);
                }
                ContactEmailAddress otherEmail = new ContactEmailAddress();
                otherEmail.setContactId(contactId);
                otherEmail.setType(3);
                otherEmail.setEnteredBy(userId);
                otherEmail.setModifiedBy(userId);
                otherEmail.setEmail(this.getValue(thisRecord, this.OTHER_EMAIL));
                if (otherEmail.isValid()) {
                    emailFormatter.format(otherEmail);
                    emailAddressList.add(otherEmail);
                }
                thisContact.setNotes(this.getValue(thisRecord, this.NOTES));
                processOK = writer.save(this.mappings.createDataRecord((Object)thisContact, "insert"));
                if (processOK) {
                    processOK = this.mappings.saveList(writer, addressList, "insert");
                    processOK = this.mappings.saveList(writer, phoneNumberList, "insert");
                    processOK = this.mappings.saveList(writer, emailAddressList, "insert");
                }
                this.writeln(out, thisRecord);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.info("ImportGeneralContacts-> Error: " + e.toString());
            e.printStackTrace(System.out);
            processOK = false;
        }
        return processOK;
    }
}

