/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.apps.transfer.DataReader;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class InitPermissionsAndRoles
implements DataReader {
    public static final String fs = System.getProperty("file.separator");
    private String processConfigFile = "InitPermissions.xml";

    public void setProcessConfigFile(String tmp) {
        this.processConfigFile = tmp;
    }

    public String getProcessConfigFile() {
        return this.processConfigFile;
    }

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "Centric CRM Permissions and Roles XML Reader";
    }

    public String getDescription() {
        return "Reads permissions and categories; reads in associated roles";
    }

    public boolean isConfigured() {
        File configFile;
        boolean configOK = true;
        String tmpFile = System.getProperty("processConfigFile");
        if (tmpFile != null && !"".equals(tmpFile)) {
            this.processConfigFile = tmpFile;
        }
        if (!(configFile = new File(this.processConfigFile)).exists()) {
            logger.info("InitPermissionsAndRoles-> Config: process config file not found: " + this.processConfigFile);
            configOK = false;
        }
        return configOK;
    }

    public boolean execute(DataWriter writer) {
        boolean processOK = true;
        try {
            DataRecord thisRecord;
            File configFile = new File(this.processConfigFile);
            XMLUtils xml = new XMLUtils(configFile);
            ArrayList categoryList = new ArrayList();
            XMLUtils.getAllChildren(xml.getFirstChild("permissions"), "category", categoryList);
            logger.info("Categories: " + categoryList.size());
            CategoryElementComparator comparator = new CategoryElementComparator();
            Object[] sortArray = categoryList.toArray();
            Arrays.sort(sortArray, comparator);
            ArrayList<Element> sortedCategoryList = new ArrayList<Element>();
            for (int i = 0; i < sortArray.length; ++i) {
                sortedCategoryList.add((Element)sortArray[i]);
            }
            HashMap<String, Integer> permissionIds = new HashMap<String, Integer>();
            for (Element category : sortedCategoryList) {
                String uniqueCategoryId = category.getAttribute("id");
                int categoryLevel = (categoryList.indexOf(category) + 1) * 100;
                thisRecord = new DataRecord();
                thisRecord.setName("permissionCategory");
                thisRecord.setAction("insert");
                thisRecord.addField("constant", category.getAttribute("id"));
                thisRecord.addField("category", category.getAttribute("name"));
                thisRecord.addField("level", String.valueOf(categoryLevel));
                if ("false".equals(category.getAttribute("enabled"))) {
                    thisRecord.addField("enabled", "false");
                    thisRecord.addField("active", "false");
                } else {
                    thisRecord.addField("enabled", "true");
                    thisRecord.addField("active", "true");
                }
                thisRecord.addField("folders", category.getAttribute("folders"));
                thisRecord.addField("lookups", category.getAttribute("lookups"));
                thisRecord.addField("viewpoints", category.getAttribute("viewpoints"));
                thisRecord.addField("reports", category.getAttribute("reports"));
                thisRecord.addField("scheduledEvents", category.getAttribute("scheduledEvents"));
                thisRecord.addField("objectEvents", category.getAttribute("objectEvents"));
                thisRecord.addField("categories", category.getAttribute("categories"));
                thisRecord.addField("products", category.getAttribute("products"));
                thisRecord.addField("importer", category.getAttribute("importer"));
                thisRecord.addField("webdav", category.getAttribute("webdav"));
                thisRecord.addField("logos", category.getAttribute("logos"));
                thisRecord.addField("actionPlans", category.getAttribute("actionPlans"));
                processOK = writer.save(thisRecord);
                int categoryId = Integer.parseInt(writer.getLastResponse());
                ArrayList permissionList = new ArrayList();
                XMLUtils.getAllChildren(category, "permission", permissionList);
                Iterator permissionItems = permissionList.iterator();
                int permissionLevel = 0;
                while (permissionItems.hasNext()) {
                    permissionLevel += 10;
                    Element permission = (Element)permissionItems.next();
                    DataRecord permissionRecord = new DataRecord();
                    permissionRecord.setName("permission");
                    permissionRecord.setAction("insert");
                    permissionRecord.addField("categoryId", String.valueOf(categoryId));
                    permissionRecord.addField("permissionLevel", String.valueOf(permissionLevel));
                    permissionRecord.addField("name", permission.getAttribute("name"));
                    permissionRecord.addField("description", permission.getAttribute("description"));
                    String attributes = permission.getAttribute("attributes");
                    permissionRecord.addField("view", String.valueOf(attributes.indexOf("v") > -1));
                    permissionRecord.addField("add", String.valueOf(attributes.indexOf("a") > -1));
                    permissionRecord.addField("edit", String.valueOf(attributes.indexOf("e") > -1));
                    permissionRecord.addField("delete", String.valueOf(attributes.indexOf("d") > -1));
                    if ("false".equals(permission.getAttribute("enabled"))) {
                        permissionRecord.addField("enabled", "false");
                        permissionRecord.addField("active", "false");
                    } else {
                        permissionRecord.addField("enabled", "true");
                        permissionRecord.addField("active", "true");
                    }
                    if ("true".equals(permission.getAttribute("viewpoints"))) {
                        permissionRecord.addField("viewpoints", "true");
                    } else {
                        permissionRecord.addField("viewpoints", "false");
                    }
                    writer.save(permissionRecord);
                    int permissionId = Integer.parseInt(writer.getLastResponse());
                    permissionIds.put(permission.getAttribute("name"), new Integer(permissionId));
                }
                ArrayList folderList = new ArrayList();
                XMLUtils.getAllChildren(category, "folder", folderList);
                Iterator folderItems = folderList.iterator();
                int folderLevel = 0;
                while (folderItems.hasNext()) {
                    folderLevel += 10;
                    Element folder = (Element)folderItems.next();
                    DataRecord folderRecord = new DataRecord();
                    folderRecord.setName("folder");
                    folderRecord.setAction("insert");
                    folderRecord.addField("moduleId", String.valueOf(categoryId));
                    folderRecord.addField("categoryId", folder.getAttribute("constantId"));
                    folderRecord.addField("level", String.valueOf(folderLevel));
                    folderRecord.addField("description", folder.getAttribute("description"));
                    writer.save(folderRecord);
                }
                ArrayList actionPlanEditorList = new ArrayList();
                XMLUtils.getAllChildren(category, "actionPlanEditor", actionPlanEditorList);
                Iterator planEditorItems = actionPlanEditorList.iterator();
                int editorLevel = 0;
                while (planEditorItems.hasNext()) {
                    editorLevel += 10;
                    Element planEditor = (Element)planEditorItems.next();
                    DataRecord planEditorRecord = new DataRecord();
                    planEditorRecord.setName("planEditor");
                    planEditorRecord.setAction("insert");
                    planEditorRecord.addField("moduleId", String.valueOf(categoryId));
                    planEditorRecord.addField("categoryId", uniqueCategoryId);
                    planEditorRecord.addField("constantId", planEditor.getAttribute("constantId"));
                    planEditorRecord.addField("level", String.valueOf(editorLevel));
                    planEditorRecord.addField("description", planEditor.getAttribute("description"));
                    writer.save(planEditorRecord);
                }
                ArrayList lookupList = new ArrayList();
                XMLUtils.getAllChildren(category, "lookup", lookupList);
                Iterator lookupItems = lookupList.iterator();
                int lookupLevel = 0;
                while (lookupItems.hasNext()) {
                    lookupLevel += 10;
                    Element lookup = (Element)lookupItems.next();
                    DataRecord lookupRecord = new DataRecord();
                    lookupRecord.setName("lookup");
                    lookupRecord.setAction("insert");
                    lookupRecord.addField("moduleId", String.valueOf(categoryId));
                    lookupRecord.addField("lookupId", lookup.getAttribute("constantId"));
                    lookupRecord.addField("class", lookup.getAttribute("class"));
                    lookupRecord.addField("table", lookup.getAttribute("table"));
                    lookupRecord.addField("level", String.valueOf(lookupLevel));
                    lookupRecord.addField("description", lookup.getAttribute("description"));
                    lookupRecord.addField("categoryId", uniqueCategoryId);
                    writer.save(lookupRecord);
                }
                ArrayList reportList = new ArrayList();
                XMLUtils.getAllChildren(category, "report", reportList);
                for (Element report : reportList) {
                    DataRecord reportRecord = new DataRecord();
                    reportRecord.setName("report");
                    reportRecord.setAction("insert");
                    reportRecord.addField("categoryId", String.valueOf(categoryId));
                    reportRecord.addField("permissionId", (Integer)permissionIds.get(report.getAttribute("permission")));
                    reportRecord.addField("file", report.getAttribute("file"));
                    String type = report.getAttribute("type");
                    if ("admin".equals(type)) {
                        reportRecord.addField("type", "2");
                    } else {
                        reportRecord.addField("type", "1");
                    }
                    reportRecord.addField("title", report.getAttribute("title"));
                    reportRecord.addField("description", report.getAttribute("description"));
                    reportRecord.addField("enteredBy", "0");
                    reportRecord.addField("modifiedBy", "0");
                    writer.save(reportRecord);
                }
                ArrayList multipleCategory = new ArrayList();
                XMLUtils.getAllChildren(category, "multipleCategory", multipleCategory);
                Iterator multipleItems = multipleCategory.iterator();
                int multipleLevel = 0;
                while (multipleItems.hasNext()) {
                    multipleLevel += 10;
                    Element multiple = (Element)multipleItems.next();
                    DataRecord multipleRecord = new DataRecord();
                    multipleRecord.setName("multipleCategory");
                    multipleRecord.setAction("insert");
                    multipleRecord.addField("moduleId", String.valueOf(categoryId));
                    multipleRecord.addField("categoryId", uniqueCategoryId);
                    multipleRecord.addField("constantId", multiple.getAttribute("constantId"));
                    multipleRecord.addField("table", multiple.getAttribute("table"));
                    multipleRecord.addField("level", String.valueOf(multipleLevel));
                    multipleRecord.addField("description", multiple.getAttribute("description"));
                    multipleRecord.addField("maxLevels", multiple.getAttribute("maxLevels"));
                    writer.save(multipleRecord);
                }
                ArrayList webdavList = new ArrayList();
                XMLUtils.getAllChildren(category, "webdav", webdavList);
                for (Element webdav : webdavList) {
                    DataRecord webdavRecord = new DataRecord();
                    webdavRecord.setName("webdav");
                    webdavRecord.setAction("insert");
                    webdavRecord.addField("categoryId", String.valueOf(categoryId));
                    webdavRecord.addField("class", webdav.getAttribute("class"));
                    writer.save(webdavRecord);
                }
            }
            ArrayList roleList = new ArrayList();
            XMLUtils.getAllChildren(xml.getFirstChild("roles"), "role", roleList);
            logger.info("Roles: " + roleList.size());
            for (Element role : roleList) {
                thisRecord = new DataRecord();
                thisRecord.setName("role");
                thisRecord.setAction("insert");
                thisRecord.addField("role", role.getAttribute("name"));
                thisRecord.addField("description", role.getAttribute("description"));
                thisRecord.addField("type", role.getAttribute("type") == null || "".equals(role.getAttribute("type")) ? "0" : role.getAttribute("type"));
                if ("false".equals(role.getAttribute("enabled"))) {
                    thisRecord.addField("enabled", "false");
                } else {
                    thisRecord.addField("enabled", "true");
                }
                writer.save(thisRecord);
                int roleId = Integer.parseInt(writer.getLastResponse());
                ArrayList rolePermissionList = new ArrayList();
                XMLUtils.getAllChildren(role, "permission", rolePermissionList);
                for (Element rolePermission : rolePermissionList) {
                    DataRecord rolePermissionRecord = new DataRecord();
                    rolePermissionRecord.setName("rolePermission");
                    rolePermissionRecord.setAction("insert");
                    rolePermissionRecord.addField("roleId", String.valueOf(roleId));
                    rolePermissionRecord.addField("permissionId", (Integer)permissionIds.get(rolePermission.getAttribute("name")));
                    String attributes = rolePermission.getAttribute("attributes");
                    rolePermissionRecord.addField("view", String.valueOf(attributes.indexOf("v") > -1));
                    rolePermissionRecord.addField("add", String.valueOf(attributes.indexOf("a") > -1));
                    rolePermissionRecord.addField("edit", String.valueOf(attributes.indexOf("e") > -1));
                    rolePermissionRecord.addField("delete", String.valueOf(attributes.indexOf("d") > -1));
                    writer.save(rolePermissionRecord);
                }
            }
        }
        catch (Exception e) {
            logger.info("Error reading parsing configuration-> " + e.toString());
            processOK = false;
        }
        return processOK;
    }

    class CategoryElementComparator
    implements Comparator {
        CategoryElementComparator() {
        }

        public int compare(Object left, Object right) {
            int a = Integer.parseInt(((Element)left).getAttribute("id"));
            int b = Integer.parseInt(((Element)right).getAttribute("id"));
            return new Integer(a).compareTo(new Integer(b));
        }
    }
}

