/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.apps.transfer.DataReader;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;

public class CFSDatabaseReader
implements DataReader {
    private String driver = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private String processConfigFile = "CFSDatabaseReader.xml";
    private ArrayList modules = null;
    private PropertyMapList mappings = null;
    private int count = 0;

    public void setDriver(String tmp) {
        this.driver = tmp;
    }

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setUser(String tmp) {
        this.user = tmp;
    }

    public void setPassword(String tmp) {
        this.password = tmp;
    }

    public void setProcessConfigFile(String tmp) {
        this.processConfigFile = tmp;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProcessConfigFile() {
        return this.processConfigFile;
    }

    public double getVersion() {
        return 4.0;
    }

    public String getName() {
        return "Centric CRM 4.0 Database Reader";
    }

    public String getDescription() {
        return "Reads data from a Centric CRM version 4.0 database";
    }

    public boolean isConfigured() {
        if (this.driver == null || this.url == null || this.user == null) {
            return false;
        }
        this.modules = new ArrayList();
        try {
            this.mappings = new PropertyMapList(this.processConfigFile, this.modules);
        }
        catch (Exception e) {
            logger.info(e.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(DataWriter writer) {
        ConnectionPool sqlDriver = null;
        Connection db = null;
        ConnectionElement connectionElement = null;
        try {
            sqlDriver = new ConnectionPool();
            sqlDriver.setMaxConnections(1);
            sqlDriver.setDebug(true);
            connectionElement = new ConnectionElement(this.url, this.user, this.password);
            connectionElement.setAllowCloseOnIdle(false);
            connectionElement.setDriver(this.driver);
            db = sqlDriver.getConnection(connectionElement);
        }
        catch (SQLException e) {
            logger.info("Could not get database connection" + e.toString());
            return false;
        }
        try {
            this.executeJob(db, writer);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        finally {
            sqlDriver.free(db);
            sqlDriver.destroy();
            sqlDriver = null;
        }
        return true;
    }

    public boolean executeJob(Connection db, DataWriter writer) throws Exception {
        boolean processOK = true;
        Iterator moduleList = this.modules.iterator();
        while (moduleList.hasNext() && processOK) {
            String moduleClass = (String)moduleList.next();
            logger.info("Processing: " + moduleClass);
            Object module = Class.forName(moduleClass).newInstance();
            processOK = ((CFSDatabaseReaderImportModule)module).process(writer, db, this.mappings);
            if (processOK) continue;
            logger.info("Module failed: " + moduleClass);
        }
        return processOK;
    }
}

