/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.ImportLookupTables;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.actionplans.base.ActionItemWorkList;
import org.aspcfs.modules.actionplans.base.ActionItemWorkNoteList;
import org.aspcfs.modules.actionplans.base.ActionItemWorkSelectionList;
import org.aspcfs.modules.actionplans.base.ActionPhase;
import org.aspcfs.modules.actionplans.base.ActionPhaseList;
import org.aspcfs.modules.actionplans.base.ActionPhaseWorkList;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanCategoryList;
import org.aspcfs.modules.actionplans.base.ActionPlanList;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkList;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkNoteList;
import org.aspcfs.modules.actionplans.base.ActionStep;
import org.aspcfs.modules.actionplans.base.ActionStepList;
import org.aspcfs.modules.actionplans.base.ActionStepLookupList;
import org.aspcfs.modules.actionplans.base.PlanEditorList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftPlanMapList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryPlanMapList;

public class ImportActionPlans
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        logger.info("ImportTickets-> Inserting Lookup Step Actions");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupStepActions");
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting ActionPlanCategory records");
        ActionPlanCategoryList actionPlanCategoryList = new ActionPlanCategoryList();
        actionPlanCategoryList.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, actionPlanCategoryList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Action Plan Constants");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "actionPlanConstants");
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting Action Plan Editor Lookup");
        PlanEditorList planEditorList = new PlanEditorList();
        planEditorList.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, planEditorList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting ActionPlan");
        ActionPlanList actionPlanList = new ActionPlanList();
        actionPlanList.buildList(db);
        writer.setAutoCommit(false);
        this.saveActionPlanList(db, actionPlanList);
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting ActionPhase");
        ActionPhaseList actionPhaseList = new ActionPhaseList();
        actionPhaseList.buildList(db);
        writer.setAutoCommit(false);
        this.saveActionPhaseList(db, actionPhaseList);
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting ActionStep");
        ActionStepList actionStepList = new ActionStepList();
        actionStepList.buildList(db);
        writer.setAutoCommit(false);
        this.saveActionStepList(db, actionStepList);
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting StepActionMap records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "stepActionMap");
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting ActionPlan Work");
        ActionPlanWorkList actionPlanWorkList = new ActionPlanWorkList();
        actionPlanWorkList.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, actionPlanWorkList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting ActionPlan WorkNote");
        ActionPlanWorkNoteList actionPlanWorkNoteList = new ActionPlanWorkNoteList();
        actionPlanWorkNoteList.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, actionPlanWorkNoteList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting ActionPhase Work");
        ActionPhaseWorkList actionPhaseWorkList = new ActionPhaseWorkList();
        actionPhaseWorkList.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, actionPhaseWorkList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting ActionItem Work");
        ActionItemWorkList actionItemWorkList = new ActionItemWorkList();
        actionItemWorkList.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, actionItemWorkList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting ActionItemWorkNote records");
        ActionItemWorkNoteList actionItemWorkNoteList = new ActionItemWorkNoteList();
        actionItemWorkNoteList.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, actionItemWorkNoteList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting ActionStepLookup records");
        ActionStepLookupList actionStepLookupList = new ActionStepLookupList();
        actionStepLookupList.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, actionStepLookupList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting ActionStepAccountType records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "actionStepAccountTypes");
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting ActionItemWorkSelection records");
        ActionItemWorkSelectionList actionItemWorkSelectionList = new ActionItemWorkSelectionList();
        actionItemWorkSelectionList.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, actionItemWorkSelectionList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting TicketCategoryPlanMap records ");
        TicketCategoryPlanMapList ticketCategoryPlanMapList = new TicketCategoryPlanMapList();
        ticketCategoryPlanMapList.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, ticketCategoryPlanMapList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportActionPlans-> Inserting TicketCategoryDraftPlanMap records ");
        TicketCategoryDraftPlanMapList ticketCategoryDraftPlanMapList = new TicketCategoryDraftPlanMapList();
        ticketCategoryDraftPlanMapList.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, ticketCategoryDraftPlanMapList, "insert");
        processOK = writer.commit();
        return processOK;
    }

    private void saveActionPlanList(Connection db, ActionPlanList planList) throws SQLException {
        for (ActionPlan plan : planList) {
            DataRecord thisRecord = this.mappings.createDataRecord((Object)plan, "insert");
            if (plan.getCatCode() == 0) {
                thisRecord.removeField("catCode");
                thisRecord.addField("catCode", -1);
            }
            if (plan.getSubCat1() == 0) {
                thisRecord.removeField("subCat1");
                thisRecord.addField("subCat1", -1);
            }
            if (plan.getSubCat2() == 0) {
                thisRecord.removeField("subCat2");
                thisRecord.addField("subCat2", -1);
            }
            if (plan.getSubCat3() == 0) {
                thisRecord.removeField("subCat3");
                thisRecord.addField("subCat3", -1);
            }
            this.writer.save(thisRecord);
        }
    }

    private void saveActionPhaseList(Connection db, ActionPhaseList phaseList) throws SQLException {
        for (ActionPhase phase : phaseList) {
            DataRecord thisRecord = this.mappings.createDataRecord((Object)phase, "insert");
            if (phase.getParentId() == 0) {
                thisRecord.removeField("parentId");
                thisRecord.addField("parentId", -1);
            }
            this.writer.save(thisRecord);
        }
    }

    private void saveActionStepList(Connection db, ActionStepList stepList) throws SQLException {
        for (ActionStep step : stepList) {
            DataRecord thisRecord = this.mappings.createDataRecord((Object)step, "insert");
            if (step.getParentId() == 0) {
                thisRecord.removeField("parentId");
                thisRecord.addField("parentId", -1);
            }
            this.writer.save(thisRecord);
        }
    }
}

