/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import com.zeroio.webdav.base.WebdavModuleList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.ImportLookupTables;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.accounts.base.AccountTypeLevel;
import org.aspcfs.modules.accounts.base.NewsArticleList;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationAddress;
import org.aspcfs.modules.accounts.base.OrganizationAddressList;
import org.aspcfs.modules.accounts.base.OrganizationEmailAddress;
import org.aspcfs.modules.accounts.base.OrganizationEmailAddressList;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.accounts.base.OrganizationPhoneNumber;
import org.aspcfs.modules.accounts.base.OrganizationPhoneNumberList;
import org.aspcfs.modules.admin.base.AccessLogList;
import org.aspcfs.modules.admin.base.PermissionCategoryList;
import org.aspcfs.modules.admin.base.PermissionList;
import org.aspcfs.modules.admin.base.RoleList;
import org.aspcfs.modules.admin.base.RolePermissionList;
import org.aspcfs.modules.admin.base.UsageList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserGroupList;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.admin.base.ViewpointList;
import org.aspcfs.modules.admin.base.ViewpointPermissionList;
import org.aspcfs.modules.base.ImportList;
import org.aspcfs.modules.base.NotificationMessageList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactAddress;
import org.aspcfs.modules.contacts.base.ContactAddressList;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.modules.contacts.base.ContactHistoryList;
import org.aspcfs.modules.contacts.base.ContactInstantMessageAddress;
import org.aspcfs.modules.contacts.base.ContactInstantMessageAddressList;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.contacts.base.ContactPhoneNumberList;
import org.aspcfs.modules.contacts.base.ContactTextMessageAddress;
import org.aspcfs.modules.contacts.base.ContactTextMessageAddressList;
import org.aspcfs.modules.mycfs.base.CFSNoteList;
import org.aspcfs.modules.system.base.DatabaseVersion;

public class ImportBaseData
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        boolean contactOK = true;
        if (!this.processCustomLookups(writer, db, mappings)) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Users");
        writer.setAutoCommit(false);
        User baseUser = new User(db, "0");
        UserList userList = new UserList();
        userList.buildList(db);
        userList.add(0, baseUser);
        this.saveUserList(db, userList);
        processOK = writer.commit();
        userList = null;
        baseUser = null;
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Access Log records");
        writer.setAutoCommit(false);
        writer.initialize();
        AccessLogList accessLog = new AccessLogList();
        accessLog.buildList(db);
        mappings.saveList(writer, accessLog, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Usage records");
        writer.setAutoCommit(false);
        writer.initialize();
        UsageList usageList = new UsageList();
        usageList.buildList(db);
        mappings.saveList(writer, usageList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Contact Types");
        writer.setAutoCommit(true);
        writer.initialize();
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupContactTypes");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Sub-Segment Lookup");
        writer.setAutoCommit(true);
        writer.initialize();
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupSubSegment");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting State records");
        writer.setAutoCommit(true);
        writer.initialize();
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "state");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Accounts");
        writer.setAutoCommit(false);
        writer.initialize();
        Organization myCompany = new Organization(db, 0);
        OrganizationList accounts = new OrganizationList();
        accounts.setShowMyCompany(false);
        accounts.setIncludeEnabled(-1);
        accounts.setExcludeUnapprovedAccounts(false);
        accounts.buildList(db);
        OrganizationList trashedAccounts = new OrganizationList();
        trashedAccounts.setShowMyCompany(false);
        trashedAccounts.setIncludeEnabled(-1);
        trashedAccounts.setExcludeUnapprovedAccounts(false);
        trashedAccounts.setIncludeOnlyTrashed(true);
        trashedAccounts.buildList(db);
        accounts.add(0, myCompany);
        accounts.addAll(trashedAccounts);
        processOK = this.saveOrgList(db, accounts);
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Contacts");
        writer.setAutoCommit(false);
        writer.initialize();
        ContactList contacts = new ContactList();
        contacts.setIncludeAllSites(true);
        contacts.setIncludeEnabled(-1);
        contacts.setExcludeUnapprovedContacts(false);
        contacts.setShowTrashedAndNormal(true);
        contacts.setPersonalId(-2);
        contacts.buildList(db);
        processOK = this.saveContactList(db, contacts);
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Skipped Leads Information");
        writer.setAutoCommit(true);
        writer.initialize();
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "contactLeadSkippedMap");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Leads Read Information");
        writer.setAutoCommit(true);
        writer.initialize();
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "contactLeadReadMap");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Roles");
        RoleList roles = new RoleList();
        roles.setEnabledState(-1);
        roles.buildList(db);
        processOK = mappings.saveList(writer, roles, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Permission Categories");
        PermissionCategoryList categories = new PermissionCategoryList();
        categories.buildList(db);
        processOK = mappings.saveList(writer, categories, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Permissions");
        PermissionList permissions = new PermissionList();
        permissions.setEnabled(-1);
        permissions.buildList(db);
        processOK = mappings.saveList(writer, permissions, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Role Permissions");
        processOK = mappings.saveList(writer, RolePermissionList.recordList(db), "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting News");
        writer.setAutoCommit(false);
        writer.initialize();
        NewsArticleList newsArticleList = new NewsArticleList();
        newsArticleList.buildList(db);
        mappings.saveList(writer, newsArticleList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Notifications");
        writer.setAutoCommit(false);
        writer.initialize();
        NotificationMessageList notifications = new NotificationMessageList();
        notifications.buildList(db);
        mappings.saveList(writer, notifications, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting CFS Notes");
        writer.setAutoCommit(false);
        writer.initialize();
        CFSNoteList noteList = new CFSNoteList();
        noteList.setBuildAll(true);
        noteList.buildList(db);
        mappings.saveList(writer, noteList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting CFSNote Link records");
        writer.setAutoCommit(true);
        writer.initialize();
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "cfsNoteLink");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Account Type Levels");
        writer.setAutoCommit(true);
        writer.initialize();
        mappings.saveList(writer, AccountTypeLevel.recordList(db), "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting contact Type Levels");
        writer.setAutoCommit(true);
        writer.initialize();
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "contactTypeLevels");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Lookup Lists lookup");
        writer.setAutoCommit(true);
        writer.initialize();
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupListsLookup");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Webdav");
        writer.setAutoCommit(false);
        writer.initialize();
        WebdavModuleList webdavModuleList = new WebdavModuleList();
        webdavModuleList.buildList(db);
        mappings.saveList(writer, new ArrayList(webdavModuleList.values()), "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting CategoryEditor records");
        writer.setAutoCommit(true);
        writer.initialize();
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "categoryEditorLookup");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Viewpoint");
        writer.setAutoCommit(false);
        writer.initialize();
        ViewpointList viewpointList = new ViewpointList();
        viewpointList.buildList(db);
        mappings.saveList(writer, viewpointList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Viewpoint Permissions");
        writer.setAutoCommit(false);
        writer.initialize();
        mappings.saveList(writer, ViewpointPermissionList.recordList(db), "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Import");
        writer.setAutoCommit(false);
        writer.initialize();
        ImportList importList = new ImportList();
        importList.setIgnoreStatusId(-1);
        importList.setBuildFileDetails(false);
        importList.buildList(db);
        mappings.saveList(writer, importList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Database Versions");
        writer.setAutoCommit(false);
        writer.initialize();
        mappings.saveList(writer, DatabaseVersion.recordList(db), "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting history");
        writer.setAutoCommit(false);
        writer.initialize();
        ContactHistoryList contactHistoryList = new ContactHistoryList();
        contactHistoryList.setDefaultFilters(true);
        contactHistoryList.setShowDisabledWithEnabled(true);
        contactHistoryList.buildList(db);
        mappings.saveList(writer, contactHistoryList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting User Groups");
        writer.setAutoCommit(false);
        writer.initialize();
        UserGroupList userGroupList = new UserGroupList();
        userGroupList.buildList(db);
        mappings.saveList(writer, userGroupList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting User Group Map");
        writer.setAutoCommit(true);
        writer.initialize();
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "userGroupMap");
        if (!processOK) {
            return false;
        }
        this.updateUserList(db);
        return true;
    }

    private boolean processCustomLookups(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        writer.setAutoCommit(true);
        writer.initialize();
        boolean processOK = true;
        logger.info("ImportBaseData-> Inserting Access Type");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupAccessTypes");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Industry Types");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupIndustry");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Site IDs");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupSiteId");
        if (!processOK) {
            return false;
        }
        logger.info("ImportBaseData-> Inserting Stage Types");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupStage");
        if (!processOK) {
            return false;
        }
        return processOK;
    }

    private void saveUserList(Connection db, UserList userList) throws SQLException {
        for (User thisUser : userList) {
            DataRecord thisRecord = this.mappings.createDataRecord((Object)thisUser, "insert");
            thisRecord.removeField("enteredBy");
            thisRecord.removeField("modifiedBy");
            thisRecord.removeField("contactId");
            thisRecord.removeField("roleId");
            thisRecord.removeField("managerId");
            thisRecord.removeField("assistant");
            thisRecord.removeField("alias");
            thisRecord.addField("addContact", "false");
            this.writer.save(thisRecord);
        }
    }

    private void updateUserList(Connection db) throws SQLException {
        HashMap<String, String> userIdHash = new HashMap<String, String>();
        PreparedStatement pst = db.prepareStatement("SELECT contact_id, user_id FROM contact c WHERE c.user_id > 0 ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            userIdHash.put(String.valueOf(rs.getInt("user_id")), String.valueOf(rs.getInt("contact_id")));
        }
        rs.close();
        pst.close();
        User firstUser = new User(db, "0");
        UserList finalUserList = new UserList();
        finalUserList.buildList(db);
        finalUserList.add(firstUser);
        for (User thisUser : finalUserList) {
            DataRecord thisRecord = this.mappings.createDataRecord((Object)thisUser, "update");
            if (userIdHash.containsKey(String.valueOf(thisUser.getId()))) {
                thisRecord.removeField("contactId");
                thisRecord.addField("contactId", (String)userIdHash.get(String.valueOf(thisUser.getId())));
            }
            thisRecord.removeField("isXMLObject");
            thisRecord.addField("isXMLObject", "true");
            this.writer.save(thisRecord);
        }
    }

    private boolean saveContactList(Connection db, ContactList contactList) throws SQLException {
        for (Contact thisContact : contactList) {
            DataRecord thisRecord = this.mappings.createDataRecord((Object)thisContact, "insert");
            this.writer.save(thisRecord);
            this.writer.commit();
            ContactEmailAddressList emailList = new ContactEmailAddressList();
            emailList.setContactId(thisContact.getId());
            emailList.buildList(db);
            logger.info("ImportBaseData-> Inserting " + emailList.size() + " Contact emails");
            for (ContactEmailAddress thisAddress : emailList) {
                DataRecord anotherRecord = this.mappings.createDataRecord((Object)thisAddress, "insert");
                this.writer.save(anotherRecord);
                this.writer.commit();
            }
            ContactAddressList addressList = new ContactAddressList();
            addressList.setContactId(thisContact.getId());
            addressList.buildList(db);
            logger.info("ImportBaseData-> Inserting " + addressList.size() + " Contact addresses");
            for (ContactAddress streetAddress : addressList) {
                DataRecord addressRecord = this.mappings.createDataRecord(streetAddress, "insert");
                this.writer.save(addressRecord);
                this.writer.commit();
            }
            ContactPhoneNumberList phoneList = new ContactPhoneNumberList();
            phoneList.setContactId(thisContact.getId());
            phoneList.buildList(db);
            logger.info("ImportBaseData-> Inserting " + phoneList.size() + " Contact phone numbers");
            for (ContactPhoneNumber phone : phoneList) {
                DataRecord phoneRecord = this.mappings.createDataRecord(phone, "insert");
                this.writer.save(phoneRecord);
                this.writer.commit();
            }
            ContactInstantMessageAddressList contactInstantMessageAddressList = new ContactInstantMessageAddressList();
            contactInstantMessageAddressList.setContactId(thisContact.getId());
            contactInstantMessageAddressList.buildList(db);
            logger.info("ImportBaseData-> Inserting " + contactInstantMessageAddressList.size() + " Contact IM Addresses");
            for (ContactInstantMessageAddress imAddress : contactInstantMessageAddressList) {
                DataRecord imAddrRecord = this.mappings.createDataRecord(imAddress, "insert");
                this.writer.save(imAddrRecord);
                this.writer.commit();
            }
            ContactTextMessageAddressList contactTextMessageAddressList = new ContactTextMessageAddressList();
            contactTextMessageAddressList.setContactId(thisContact.getId());
            contactTextMessageAddressList.buildList(db);
            logger.info("ImportBaseData-> Inserting " + contactTextMessageAddressList.size() + " Contact Text Msg Addresses");
            for (ContactTextMessageAddress textMsgAddr : contactTextMessageAddressList) {
                DataRecord textMsgAddrRec = this.mappings.createDataRecord(textMsgAddr, "insert");
                this.writer.save(textMsgAddrRec);
                this.writer.commit();
            }
        }
        return true;
    }

    private boolean saveOrgList(Connection db, OrganizationList orgList) throws SQLException {
        for (Organization thisOrg : orgList) {
            DataRecord thisRecord = this.mappings.createDataRecord((Object)thisOrg, "insert");
            thisRecord.addField("insertPrimaryContact", "false");
            this.writer.save(thisRecord);
            this.writer.commit();
            OrganizationEmailAddressList emailList = new OrganizationEmailAddressList();
            emailList.setOrgId(thisOrg.getId());
            emailList.buildList(db);
            logger.info("ImportBaseData-> Inserting " + emailList.size() + " Organization emails");
            for (OrganizationEmailAddress thisAddress : emailList) {
                DataRecord anotherRecord = this.mappings.createDataRecord((Object)thisAddress, "insert");
                this.writer.save(anotherRecord);
                this.writer.commit();
            }
            OrganizationAddressList addressList = new OrganizationAddressList();
            addressList.setOrgId(thisOrg.getId());
            addressList.buildList(db);
            logger.info("ImportBaseData-> Inserting " + addressList.size() + " Organization addresses");
            for (OrganizationAddress streetAddress : addressList) {
                DataRecord addressRecord = this.mappings.createDataRecord(streetAddress, "insert");
                this.writer.save(addressRecord);
                this.writer.commit();
            }
            OrganizationPhoneNumberList phoneList = new OrganizationPhoneNumberList();
            phoneList.setOrgId(thisOrg.getId());
            phoneList.buildList(db);
            logger.info("ImportBaseData-> Inserting " + phoneList.size() + " Organization phone numbers");
            for (OrganizationPhoneNumber thisPhone : phoneList) {
                DataRecord anotherRecord = this.mappings.createDataRecord(thisPhone, "insert");
                this.writer.save(anotherRecord);
                this.writer.commit();
            }
        }
        return true;
    }
}

