/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.ImportLookupTables;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.communications.base.ActiveSurveyAnswerItemList;
import org.aspcfs.modules.communications.base.ActiveSurveyList;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestion;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionItem;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionItemList;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionList;
import org.aspcfs.modules.communications.base.CampaignList;
import org.aspcfs.modules.communications.base.CampaignUserGroupMapList;
import org.aspcfs.modules.communications.base.ContactMessageList;
import org.aspcfs.modules.communications.base.ItemList;
import org.aspcfs.modules.communications.base.MessageList;
import org.aspcfs.modules.communications.base.SearchCriteriaListList;
import org.aspcfs.modules.communications.base.SurveyAnswerList;
import org.aspcfs.modules.communications.base.SurveyList;
import org.aspcfs.modules.communications.base.SurveyQuestion;
import org.aspcfs.modules.communications.base.SurveyQuestionList;
import org.aspcfs.modules.communications.base.SurveyResponseList;

public class ImportCommunications
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        logger.info("ImportCommunications-> Inserting Search Criteria List");
        writer.setAutoCommit(false);
        SearchCriteriaListList searchCriteriaList = new SearchCriteriaListList();
        searchCriteriaList.setEnabled(-1);
        searchCriteriaList.buildList(db);
        mappings.saveList(writer, searchCriteriaList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Campaign List");
        writer.setAutoCommit(false);
        CampaignList campaigns = new CampaignList();
        campaigns.buildList(db);
        mappings.saveList(writer, campaigns, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Campaign Run");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "campaignRun");
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Excluded Recipients");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "excludedRecipient");
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Campaign List Groups");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "campaignListGroups");
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Active Campaign Groups");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "activeCampaignGroups");
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Scheduled Recipient Records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "scheduledRecipient");
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Survey List");
        writer.setAutoCommit(false);
        SurveyList surveys = new SurveyList();
        surveys.buildList(db);
        mappings.saveList(writer, surveys, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Campaign Survey Link Records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "campaignSurveyLink");
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Survey Question List");
        writer.setAutoCommit(false);
        SurveyQuestionList surveyQuestions = new SurveyQuestionList();
        surveyQuestions.buildList(db);
        this.saveSurveyQuestions(db, surveyQuestions);
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Survey Item List");
        writer.setAutoCommit(false);
        ItemList surveyItems = new ItemList();
        surveyItems.buildList(db);
        mappings.saveList(writer, surveyItems, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Active Survey Records");
        writer.setAutoCommit(false);
        ActiveSurveyList activeSurveys = new ActiveSurveyList();
        activeSurveys.buildList(db);
        mappings.saveList(writer, activeSurveys, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Survey Question List");
        writer.setAutoCommit(false);
        ActiveSurveyQuestionList activeSurveyQuestions = new ActiveSurveyQuestionList();
        activeSurveyQuestions.buildList(db);
        this.saveActiveSurveyQuestions(db, activeSurveyQuestions);
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Survey Question Item List");
        writer.setAutoCommit(false);
        ActiveSurveyQuestionItemList activeSurveyQuestionItems = new ActiveSurveyQuestionItemList();
        activeSurveyQuestionItems.buildList(db);
        this.saveActiveSurveyQuestionsItems(db, activeSurveyQuestionItems);
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Active Survey Response List");
        writer.setAutoCommit(false);
        SurveyResponseList activeSurveyResponses = new SurveyResponseList();
        activeSurveyResponses.buildList(db);
        mappings.saveList(writer, activeSurveyResponses, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Active Survey Answer List");
        writer.setAutoCommit(false);
        SurveyAnswerList activeSurveyAnswers = new SurveyAnswerList();
        activeSurveyAnswers.buildList(db);
        mappings.saveList(writer, activeSurveyAnswers, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Active Survey Answer Item List");
        writer.setAutoCommit(false);
        ActiveSurveyAnswerItemList activeSurveyAnswerItems = new ActiveSurveyAnswerItemList();
        activeSurveyAnswerItems.buildList(db);
        mappings.saveList(writer, activeSurveyAnswerItems, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Active Survey Answer Averages");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "activeSurveyAnswerAvg");
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Field Types");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "fieldTypes");
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Search Field Elements");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "searchFieldElement");
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Messages");
        writer.setAutoCommit(false);
        MessageList messageList = new MessageList();
        messageList.buildList(db);
        mappings.saveList(writer, messageList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Message Template Records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "messageTemplate");
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Saved Criteria Elements");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "savedCriteriaElement");
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Contact Messages");
        writer.setAutoCommit(false);
        ContactMessageList contactMessages = new ContactMessageList();
        contactMessages.buildList(db);
        mappings.saveList(writer, contactMessages, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportCommunications-> Inserting Campaign User Group Maps");
        writer.setAutoCommit(false);
        CampaignUserGroupMapList campaignUserGroupMaps = new CampaignUserGroupMapList();
        campaignUserGroupMaps.buildList(db);
        mappings.saveList(writer, campaignUserGroupMaps, "insert");
        processOK = writer.commit();
        return processOK;
    }

    private void saveSurveyQuestions(Connection db, SurveyQuestionList questions) throws SQLException {
        for (SurveyQuestion thisQuestion : questions) {
            DataRecord thisRecord = this.mappings.createDataRecord(thisQuestion, "insert");
            thisRecord.addField("recordSurveyItems", "false");
            this.writer.save(thisRecord);
        }
    }

    private void saveActiveSurveyQuestions(Connection db, ActiveSurveyQuestionList questions) throws SQLException {
        for (ActiveSurveyQuestion thisQuestion : questions) {
            DataRecord thisRecord = this.mappings.createDataRecord(thisQuestion, "insert");
            thisRecord.addField("recordItems", "false");
            this.writer.save(thisRecord);
        }
    }

    private void saveActiveSurveyQuestionsItems(Connection db, ActiveSurveyQuestionItemList items) throws SQLException {
        for (ActiveSurveyQuestionItem thisItem : items) {
            DataRecord thisRecord = this.mappings.createDataRecord(thisItem, "insert");
            thisRecord.addField("populateAvg", "false");
            this.writer.save(thisRecord);
        }
    }
}

