/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.ImportLookupTables;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.documents.base.DocumentStoreList;
import org.aspcfs.modules.documents.base.DocumentStoreTeamMember;
import org.aspcfs.modules.documents.base.DocumentStoreTeamMemberList;

public class ImportDocumentStores
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        logger.info("ImportDocumentStores-> Inserting Document Store Permission Category records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "documentStorePermissionCategory");
        if (!processOK) {
            return false;
        }
        logger.info("ImportDocumentStores-> Inserting Document Store Role records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "documentStoreRole");
        if (!processOK) {
            return false;
        }
        logger.info("ImportDocumentStores-> Inserting Document Store Role Permission records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "documentStorePermission");
        if (!processOK) {
            return false;
        }
        logger.info("ImportDocumentStores-> Inserting Document Store records");
        writer.setAutoCommit(false);
        DocumentStoreList documentStores = new DocumentStoreList();
        documentStores.buildList(db);
        mappings.saveList(writer, documentStores, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportDocumentStores-> Inserting Document Store Permission records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "documentStorePermissions");
        if (!processOK) {
            return false;
        }
        logger.info("ImportDocumentStores-> Inserting Document Store Team Member records");
        writer.setAutoCommit(false);
        DocumentStoreTeamMemberList teamMembers = new DocumentStoreTeamMemberList();
        teamMembers.setMemberType("user");
        teamMembers.buildList(db);
        mappings.saveList(writer, teamMembers, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportDocumentStores-> Inserting Document Store Role Member records");
        writer.setAutoCommit(false);
        DocumentStoreTeamMemberList roleMembers = new DocumentStoreTeamMemberList();
        roleMembers.setMemberType("role");
        roleMembers.buildList(db);
        this.saveMembers(db, roleMembers, "documentStoreRoleMember");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportDocumentStores-> Inserting Document Store Department Member records");
        writer.setAutoCommit(false);
        DocumentStoreTeamMemberList deptMembers = new DocumentStoreTeamMemberList();
        deptMembers.setMemberType("department");
        deptMembers.buildList(db);
        this.saveMembers(db, deptMembers, "documentStoreDepartmentMember");
        processOK = writer.commit();
        return processOK;
    }

    private void saveMembers(Connection db, DocumentStoreTeamMemberList members, String mapId) throws SQLException {
        for (DocumentStoreTeamMember member : members) {
            DataRecord thisRecord = this.mappings.createDataRecord(member, "insert");
            thisRecord.removeField("itemId");
            if ("documentStoreRoleMember".equals(mapId)) {
                thisRecord.addField("itemId", member.getItemId(), "role", null);
            } else if ("documentStoreDepartmentMember".equals(mapId)) {
                thisRecord.addField("itemId", member.getItemId(), "lookupDepartment", null);
            }
            thisRecord.addField("teamMemberType", member.getTeamMemberType());
            this.writer.save(thisRecord);
        }
    }
}

