/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import com.zeroio.iteam.base.FileDownloadLogList;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersionList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractList;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;

public class ImportDocuments
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        writer.setAutoCommit(true);
        logger.info("ImportDocuments-> Inserting FileItemList");
        FileItemList fileItemList = new FileItemList();
        fileItemList.buildList(db);
        for (FileItem thisItem : fileItemList) {
            DataRecord thisRecord = mappings.createDataRecord(thisItem, "insert");
            thisRecord.addField("doVersionInsert", "false");
            switch (thisItem.getLinkModuleId()) {
                case 1: {
                    thisRecord.addField("linkItemId", String.valueOf(thisItem.getLinkItemId()), "account", null);
                    break;
                }
                case 3: {
                    thisRecord.addField("linkItemId", String.valueOf(thisItem.getLinkItemId()), "opportunity", null);
                    break;
                }
                case 5: {
                    thisRecord.addField("linkItemId", String.valueOf(thisItem.getLinkItemId()), "campaign", null);
                    break;
                }
                default: {
                    thisRecord.addField("linkItemId", String.valueOf(thisItem.getLinkItemId()), null, null);
                }
            }
            processOK = writer.save(thisRecord);
        }
        logger.info("ImportDocuments-> Inserting FileItemVersionList");
        FileItemVersionList fileItemVersionList = new FileItemVersionList();
        fileItemVersionList.buildList(db);
        mappings.saveList(writer, (AbstractList)fileItemVersionList, "insert");
        logger.info("ImportDocuments-> Inserting FileDownloadLogList");
        FileDownloadLogList downloadLog = new FileDownloadLogList();
        downloadLog.buildList(db);
        mappings.saveList(writer, (AbstractList)downloadLog, "insert");
        return true;
    }
}

