/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.ImportLookupTables;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldCategoryList;
import org.aspcfs.modules.base.CustomFieldData;
import org.aspcfs.modules.base.CustomFieldDataList;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;

public class ImportFolders
implements CFSDatabaseReaderImportModule {
    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        logger.info("ImportFolders-> Inserting folders");
        boolean processOK = true;
        writer.setAutoCommit(true);
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "moduleFieldCategoryLink");
        if (!processOK) {
            return false;
        }
        ArrayList moduleList = CustomFieldCategory.getModules(db);
        for (String thisModule : moduleList) {
            int moduleId = Integer.parseInt(thisModule);
            CustomFieldCategoryList categoryList = new CustomFieldCategoryList();
            categoryList.setLinkModuleId(moduleId);
            categoryList.setBuildResources(true);
            categoryList.buildList(db);
            processOK = mappings.saveList(writer, categoryList, "insertCategory");
            if (!processOK) {
                return false;
            }
            for (CustomFieldCategory thisCategory : categoryList) {
                processOK = mappings.saveList(writer, thisCategory, "insertGroup");
                if (!processOK) {
                    return false;
                }
                ArrayList<Integer> fieldLookup = new ArrayList<Integer>();
                for (CustomFieldGroup thisGroup : thisCategory) {
                    processOK = mappings.saveList(writer, thisGroup, "insertField");
                    if (!processOK) {
                        return false;
                    }
                    for (CustomField thisField : thisGroup) {
                        if (thisField.getType() != 2) continue;
                        fieldLookup.add(new Integer(thisField.getId()));
                        thisField.buildElementData(db);
                        for (LookupElement thisElement : (LookupList)thisField.getElementData()) {
                            DataRecord thisRecord = new DataRecord();
                            thisRecord.setName("customFieldLookup");
                            thisRecord.setAction("insert");
                            thisRecord.addField("tableName", "custom_field_lookup");
                            thisRecord.addField("uniqueField", "code");
                            thisRecord.addField("guid", String.valueOf(thisElement.getCode()));
                            thisRecord.addField("field", "field_id");
                            thisRecord.addField("data", "field_id=" + String.valueOf(thisField.getId()), "customField", null);
                            thisRecord.addField("type", 4);
                            thisRecord.addField("field", "description");
                            thisRecord.addField("data", thisElement.getDescription());
                            thisRecord.addField("type", 12);
                            thisRecord.addField("field", "default_item");
                            thisRecord.addField("data", String.valueOf(thisElement.getDefaultItem()));
                            thisRecord.addField("type", 16);
                            thisRecord.addField("field", "level");
                            thisRecord.addField("level", String.valueOf(thisElement.getLevel()));
                            thisRecord.addField("type", 4);
                            processOK = writer.save(thisRecord);
                            if (processOK) continue;
                            return false;
                        }
                    }
                }
                CustomFieldRecordList recordList = new CustomFieldRecordList();
                recordList.setLinkModuleId(moduleId);
                recordList.setCategoryId(thisCategory.getId());
                recordList.buildList(db);
                for (CustomFieldRecord thisCFRecord : recordList) {
                    DataRecord thisRecord = new DataRecord();
                    thisRecord.setName("customFieldRecord");
                    thisRecord.setAction("insert");
                    thisRecord.addField("linkModuleId", String.valueOf(thisCFRecord.getLinkModuleId()), "moduleFieldCategoryLink", null);
                    switch (thisCFRecord.getLinkModuleId()) {
                        case 1: {
                            thisRecord.addField("linkItemId", String.valueOf(thisCFRecord.getLinkItemId()), "account", null);
                            break;
                        }
                        case 2: {
                            thisRecord.addField("linkItemId", String.valueOf(thisCFRecord.getLinkItemId()), "contact", null);
                            break;
                        }
                    }
                    thisRecord.addField("categoryId", String.valueOf(thisCFRecord.getCategoryId()), "customFieldCategory", null);
                    thisRecord.addField("guid", String.valueOf(thisCFRecord.getId()));
                    thisRecord.addField("entered", ObjectUtils.getParam(thisCFRecord, "entered"));
                    thisRecord.addField("enteredBy", String.valueOf(thisCFRecord.getEnteredBy()), "user", null);
                    thisRecord.addField("modified", ObjectUtils.getParam(thisCFRecord, "modified"));
                    thisRecord.addField("modifiedBy", String.valueOf(thisCFRecord.getModifiedBy()), "user", null);
                    thisRecord.addField("enabled", ObjectUtils.getParam(thisCFRecord, "enabled"));
                    processOK = writer.save(thisRecord);
                    if (!processOK) {
                        return false;
                    }
                    CustomFieldDataList fieldList = new CustomFieldDataList();
                    fieldList.setRecordId(thisCFRecord.getId());
                    fieldList.buildList(db);
                    for (CustomFieldData thisData : fieldList) {
                        DataRecord thisFieldRecord = new DataRecord();
                        thisFieldRecord.setName("customFieldData");
                        thisFieldRecord.setAction("insert");
                        thisFieldRecord.addField("recordId", String.valueOf(thisData.getRecordId()), "customFieldRecord", null);
                        thisFieldRecord.addField("fieldId", String.valueOf(thisData.getFieldId()), "customField", null);
                        if (fieldLookup.contains(new Integer(thisData.getFieldId()))) {
                            thisFieldRecord.addField("selectedItemId", String.valueOf(thisData.getSelectedItemId()), "customFieldLookup", null);
                        } else {
                            thisFieldRecord.addField("selectedItemId", String.valueOf(thisData.getSelectedItemId()));
                        }
                        thisFieldRecord.addField("enteredValue", String.valueOf(thisData.getEnteredValue()));
                        thisFieldRecord.addField("enteredNumber", String.valueOf(thisData.getEnteredNumber()));
                        thisFieldRecord.addField("enteredDouble", String.valueOf(thisData.getEnteredDouble()));
                        processOK = writer.save(thisFieldRecord);
                    }
                }
            }
            if (processOK) continue;
            return false;
        }
        return true;
    }
}

