/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.Property;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMap;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.utils.web.CustomLookupElement;
import org.aspcfs.utils.web.CustomLookupList;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;

public class ImportLookupTables
implements CFSDatabaseReaderImportModule {
    Connection db = null;
    DataWriter writer = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.db = db;
        boolean processOK = true;
        Iterator mapList = mappings.keySet().iterator();
        while (mapList.hasNext() && processOK) {
            writer.setAutoCommit(false);
            String mapClass = (String)mapList.next();
            if (mapClass.indexOf(".LookupList") > 0) {
                PropertyMap thisMap = (PropertyMap)mappings.get(mapClass);
                logger.info("ImportLookupTables-> Processing: " + thisMap.getTable());
                processOK = this.saveLookupList(thisMap.getId(), thisMap.getTable());
            }
            processOK = writer.commit();
            writer.setAutoCommit(true);
        }
        return processOK;
    }

    public boolean saveLookupList(String uniqueId, String tableName) throws SQLException {
        LookupList thisList = new LookupList(this.db, tableName);
        for (LookupElement thisElement : thisList) {
            DataRecord thisRecord = new DataRecord();
            thisRecord.setName(uniqueId);
            thisRecord.setAction("insert");
            thisRecord.addField("tableName", tableName);
            thisRecord.addField("guid", String.valueOf(thisElement.getCode()));
            thisRecord.addField("description", thisElement.getDescription());
            thisRecord.addField("defaultItem", String.valueOf(thisElement.getDefaultItem()));
            thisRecord.addField("level", String.valueOf(thisElement.getLevel()));
            if (this.writer.save(thisRecord)) continue;
            return false;
        }
        return true;
    }

    public static boolean saveCustomLookupList(DataWriter writer, Connection db, PropertyMapList mappings, String mapId) throws SQLException {
        boolean processOK = true;
        PropertyMap thisMap = mappings.getMap(mapId);
        if (thisMap == null) {
            return false;
        }
        CustomLookupList lookupList = new CustomLookupList();
        lookupList.setTableName(thisMap.getTable());
        for (Property thisProperty : thisMap) {
            lookupList.addField(thisProperty.getField());
        }
        lookupList.buildList(db);
        if (lookupList.size() > 0) {
            Iterator queryRecords = lookupList.iterator();
            while (queryRecords.hasNext() && processOK) {
                CustomLookupElement thisElement = (CustomLookupElement)queryRecords.next();
                DataRecord thisRecord = new DataRecord();
                thisRecord.setName(thisMap.getId());
                thisRecord.setAction("insert");
                thisRecord.addField("tableName", thisMap.getTable());
                if (thisMap.getUniqueField() != null) {
                    thisRecord.addField("uniqueField", thisMap.getUniqueField());
                }
                for (Property thisProperty : thisMap) {
                    String fieldName = thisProperty.getField();
                    String value = thisElement.getValue(fieldName);
                    int type = thisElement.getType(fieldName);
                    if (thisProperty.hasAlias() && "guid".equals(thisProperty.getAlias())) {
                        thisRecord.addField("guid", value);
                        continue;
                    }
                    if (thisProperty.hasName()) {
                        thisRecord.addField(thisProperty.getName(), value, thisProperty.getLookupValue(), thisProperty.getAlias());
                        continue;
                    }
                    thisRecord.addField("field", fieldName);
                    if (thisProperty.hasLookupValue()) {
                        thisRecord.addField("data", fieldName + "=" + (value != null ? value : "-1"), thisProperty.getLookupValue(), thisProperty.getAlias());
                    } else {
                        thisRecord.addField("data", value, thisProperty.getLookupValue(), thisProperty.getAlias());
                    }
                    thisRecord.addField("type", String.valueOf(type));
                }
                processOK = writer.save(thisRecord);
            }
        }
        return processOK;
    }
}

