/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.ImportLookupTables;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponentList;
import org.aspcfs.modules.pipeline.base.OpportunityComponentLogList;
import org.aspcfs.modules.pipeline.base.OpportunityHeaderList;

public class ImportOpportunities
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        writer.setAutoCommit(true);
        logger.info("ImportBaseData-> Inserting lookup_opportunity_types");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupOpportunityTypes");
        if (!processOK) {
            return false;
        }
        logger.info("ImportOpportunities-> Inserting Opps");
        OpportunityHeaderList oppHeaderList = new OpportunityHeaderList();
        oppHeaderList.buildList(db);
        OpportunityHeaderList trashedOppHeaderList = new OpportunityHeaderList();
        trashedOppHeaderList.setIncludeOnlyTrashed(true);
        trashedOppHeaderList.buildList(db);
        oppHeaderList.addAll(trashedOppHeaderList);
        writer.setAutoCommit(false);
        mappings.saveList(writer, oppHeaderList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportOpportunities-> Inserting Opps components");
        writer.setAutoCommit(false);
        OpportunityComponentList oppCompList = new OpportunityComponentList();
        oppCompList.buildList(db);
        OpportunityComponentList trashedCompList = new OpportunityComponentList();
        trashedCompList.setIncludeOnlyTrashed(true);
        trashedCompList.buildList(db);
        oppCompList.addAll(trashedCompList);
        this.saveOppComponentList(db, oppCompList);
        processOK = writer.commit();
        oppCompList = null;
        if (!processOK) {
            return false;
        }
        writer.setAutoCommit(true);
        logger.info("ImportBaseData-> Inserting Opportunity Component Levels");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "opportunityComponentLevels");
        if (!processOK) {
            return false;
        }
        logger.info("ImportOpportunities-> Inserting Opps Component Log");
        OpportunityComponentLogList logs = new OpportunityComponentLogList();
        logs.buildList(db);
        writer.setAutoCommit(false);
        mappings.saveList(writer, logs, "insert");
        processOK = writer.commit();
        return processOK;
    }

    private void saveOppComponentList(Connection db, OpportunityComponentList oppCompList) throws SQLException {
        for (OpportunityComponent thisComponent : oppCompList) {
            DataRecord thisRecord = this.mappings.createDataRecord((Object)thisComponent, "insert");
            thisRecord.addField("updateOnInsert", "false");
            this.writer.save(thisRecord);
        }
    }
}

