/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.orders.base.OrderAddressList;
import org.aspcfs.modules.orders.base.OrderList;
import org.aspcfs.modules.orders.base.OrderPaymentList;
import org.aspcfs.modules.orders.base.OrderProductList;
import org.aspcfs.modules.orders.base.OrderProductOptionList;
import org.aspcfs.modules.orders.base.OrderProductStatusList;
import org.aspcfs.modules.products.base.CustomerProductHistoryList;
import org.aspcfs.modules.products.base.CustomerProductList;

public class ImportOrders
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        logger.info("ImportOrders-> Inserting OrderList records");
        writer.setAutoCommit(false);
        OrderList orderList = new OrderList();
        orderList.buildList(db);
        mappings.saveList(writer, orderList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportOrders-> Inserting OrderProductList records");
        writer.setAutoCommit(false);
        OrderProductList orderProductList = new OrderProductList();
        orderProductList.buildList(db);
        mappings.saveList(writer, orderProductList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportOrders-> Inserting OrderProductStatusList records");
        writer.setAutoCommit(false);
        OrderProductStatusList orderProductStatusList = new OrderProductStatusList();
        orderProductStatusList.buildList(db);
        mappings.saveList(writer, orderProductStatusList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportOrders-> Inserting OrderProductOptionList records");
        writer.setAutoCommit(false);
        OrderProductOptionList orderProductOptionList = new OrderProductOptionList();
        orderProductOptionList.buildList(db);
        mappings.saveList(writer, orderProductOptionList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportOrders-> Inserting OrderProductOptionList records");
        writer.setAutoCommit(false);
        OrderAddressList orderAddressList = new OrderAddressList();
        orderAddressList.buildList(db);
        mappings.saveList(writer, orderAddressList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportOrders-> Inserting CustomerProductList records");
        writer.setAutoCommit(false);
        CustomerProductList customerProductList = new CustomerProductList();
        customerProductList.buildList(db);
        mappings.saveList(writer, customerProductList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportOrders-> Inserting CustomerProductHistoryList records");
        writer.setAutoCommit(false);
        CustomerProductHistoryList customerProductHistoryList = new CustomerProductHistoryList();
        customerProductHistoryList.buildList(db);
        mappings.saveList(writer, customerProductHistoryList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportOrders-> Inserting OrderPaymentList records");
        writer.setAutoCommit(false);
        OrderPaymentList orderPaymentList = new OrderPaymentList();
        orderPaymentList.buildList(db);
        mappings.saveList(writer, orderPaymentList, "insert");
        processOK = writer.commit();
        return processOK;
    }
}

