/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.ImportLookupTables;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.products.base.PackageList;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.products.base.ProductCatalogPricingList;
import org.aspcfs.modules.products.base.ProductCategoryList;
import org.aspcfs.modules.products.base.ProductOptionConfiguratorList;
import org.aspcfs.modules.products.base.ProductOptionList;
import org.aspcfs.modules.products.base.ProductOptionValuesList;

public class ImportProducts
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        logger.info("ImportProducts-> Inserting Product Category records");
        writer.setAutoCommit(false);
        ProductCategoryList categories = new ProductCategoryList();
        categories.buildList(db);
        mappings.saveList(writer, categories, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Product Category Map records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "productCategoryMap");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Product Catalog records");
        writer.setAutoCommit(false);
        ProductCatalogList productCatalogList = new ProductCatalogList();
        productCatalogList.buildList(db);
        mappings.saveList(writer, productCatalogList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Product Catalog pricing records");
        writer.setAutoCommit(false);
        ProductCatalogPricingList prodCatalogPricingList = new ProductCatalogPricingList();
        prodCatalogPricingList.buildList(db);
        mappings.saveList(writer, prodCatalogPricingList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting package records");
        writer.setAutoCommit(false);
        PackageList packageList = new PackageList();
        packageList.buildList(db);
        mappings.saveList(writer, packageList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Package Products Map records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "packageProductsMap");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Product Catalog Category Map records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "productCatalogCategoryMap");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting ProductOptionConfiguratorList records");
        writer.setAutoCommit(false);
        ProductOptionConfiguratorList productOptionConfiguratorList = new ProductOptionConfiguratorList();
        productOptionConfiguratorList.buildList(db);
        mappings.saveList(writer, productOptionConfiguratorList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting ProductOptionList records");
        writer.setAutoCommit(false);
        ProductOptionList productOptionList = new ProductOptionList();
        productOptionList.buildList(db);
        mappings.saveList(writer, productOptionList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting ProductOptionValuesList records");
        writer.setAutoCommit(false);
        ProductOptionValuesList productOptionValuesList = new ProductOptionValuesList();
        productOptionValuesList.buildList(db);
        mappings.saveList(writer, productOptionValuesList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Product Option Map records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "productOptionMap");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Product Option Boolean records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "productOptionBoolean");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Product Option Float records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "productOptionFloat");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Product Option Timestamp records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "productOptionTimestamp");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Product Option Integer records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "productOptionInteger");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Product Option Text records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "productOptionText");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProducts-> Inserting Product Keyword Map records");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "productKeywordMap");
        return processOK;
    }
}

