/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import com.zeroio.iteam.base.Assignment;
import com.zeroio.iteam.base.AssignmentFolder;
import com.zeroio.iteam.base.AssignmentFolderList;
import com.zeroio.iteam.base.AssignmentList;
import com.zeroio.iteam.base.AssignmentNoteList;
import com.zeroio.iteam.base.FileDownloadLogList;
import com.zeroio.iteam.base.FileFolderList;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersionList;
import com.zeroio.iteam.base.IssueCategoryList;
import com.zeroio.iteam.base.IssueList;
import com.zeroio.iteam.base.IssueReplyList;
import com.zeroio.iteam.base.NewsArticleCategoryList;
import com.zeroio.iteam.base.NewsArticleList;
import com.zeroio.iteam.base.PermissionCategoryLookupList;
import com.zeroio.iteam.base.PermissionLookupList;
import com.zeroio.iteam.base.ProjectList;
import com.zeroio.iteam.base.RequirementList;
import com.zeroio.iteam.base.RequirementMapList;
import com.zeroio.iteam.base.TeamMemberList;
import com.zeroio.iteam.base.Thumbnail;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractList;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.ImportLookupTables;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;

public class ImportProjects
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        writer.setAutoCommit(true);
        logger.info("ImportProjects-> Inserting Project Lookups");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupProjectActivity");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupProjectPriority");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupProjectStatus");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupProjectLoe");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupProjectRole");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupProjectCategory");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "lookupNewsTemplate");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProjects-> Inserting Project Permission Categories");
        PermissionCategoryLookupList categories = new PermissionCategoryLookupList();
        categories.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)categories, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProjects-> Inserting Project Permissions");
        PermissionLookupList permissions = new PermissionLookupList();
        permissions.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)permissions, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProjects-> Inserting Projects");
        ProjectList projectList = new ProjectList();
        projectList.setGroupId(-1);
        projectList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)projectList, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProjects-> Inserting Requirements");
        RequirementList requirementList = new RequirementList();
        requirementList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)requirementList, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProjects-> Inserting Assignments folders");
        AssignmentFolderList assignmentFolderList = new AssignmentFolderList();
        assignmentFolderList.buildList(db);
        processOK = this.saveAssignmentFolderList(db, assignmentFolderList);
        if (!processOK) {
            return false;
        }
        logger.info("ImportProjects-> Inserting Assignments");
        AssignmentList assignmentList = new AssignmentList();
        assignmentList.buildList(db);
        processOK = this.saveAssignmentList(db, assignmentList);
        if (!processOK) {
            return false;
        }
        logger.info("ImportProjects-> Inserting Assignments status");
        AssignmentNoteList assignmentNoteList = new AssignmentNoteList();
        assignmentNoteList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)assignmentNoteList, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProjects-> Inserting Issue Categories");
        IssueCategoryList issueCategoryList = new IssueCategoryList();
        issueCategoryList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)issueCategoryList, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProjects-> Inserting Issues");
        IssueList issueList = new IssueList();
        issueList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)issueList, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportProjects-> Inserting Issue Replies");
        IssueReplyList issueReplyList = new IssueReplyList();
        issueReplyList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)issueReplyList, "insert");
        logger.info("ImportProjects-> Inserting project folders");
        FileFolderList fileFolderList = new FileFolderList();
        fileFolderList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)fileFolderList, "insert");
        logger.info("ImportProjects-> Inserting project files");
        FileItemList fileItemList = new FileItemList();
        fileItemList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)fileItemList, "insert");
        logger.info("ImportProjects-> Inserting project file versions");
        FileItemVersionList fileItemVersionList = new FileItemVersionList();
        fileItemVersionList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)fileItemVersionList, "insert");
        logger.info("ImportProjects-> Inserting project file download log");
        FileDownloadLogList fileDownloadLogs = new FileDownloadLogList();
        fileDownloadLogs.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)fileDownloadLogs, "insert");
        logger.info("ImportProjects-> Inserting project file thumbnails");
        processOK = mappings.saveList(writer, Thumbnail.recordList((Connection)db), "insert");
        logger.info("ImportProjects-> Inserting Team Members");
        processOK = mappings.saveList(writer, TeamMemberList.recordList((Connection)db), "insert");
        logger.info("ImportProjects-> Inserting news category");
        NewsArticleCategoryList newsArticleCategoryList = new NewsArticleCategoryList();
        newsArticleCategoryList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)newsArticleCategoryList, "insert");
        logger.info("ImportProjects-> Inserting news");
        NewsArticleList newsArticleList = new NewsArticleList();
        newsArticleList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)newsArticleList, "insert");
        logger.info("ImportProjects-> Inserting requirments map");
        RequirementMapList requirementMapList = new RequirementMapList();
        requirementMapList.buildList(db);
        processOK = mappings.saveList(writer, (AbstractList)requirementMapList, "insert");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "projectPermissions");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "projectAccounts");
        return processOK;
    }

    private boolean saveAssignmentFolderList(Connection db, AssignmentFolderList assignments) throws SQLException {
        for (AssignmentFolder thisFolder : assignments) {
            DataRecord thisRecord = this.mappings.createDataRecord(thisFolder, "insert");
            thisRecord.addField("recordMapItem", "false");
            this.writer.save(thisRecord);
        }
        return true;
    }

    private boolean saveAssignmentList(Connection db, AssignmentList assignments) throws SQLException {
        for (Assignment thisAssignment : assignments) {
            DataRecord thisRecord = this.mappings.createDataRecord(thisAssignment, "insert");
            thisRecord.addField("recordMapItem", "false");
            thisRecord.addField("recordNote", "false");
            this.writer.save(thisRecord);
        }
        return true;
    }
}

