/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.ImportLookupTables;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.quotes.base.QuoteConditionList;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.quotes.base.QuoteLogList;
import org.aspcfs.modules.quotes.base.QuoteNoteList;
import org.aspcfs.modules.quotes.base.QuoteProductList;
import org.aspcfs.modules.quotes.base.QuoteProductOptionList;
import org.aspcfs.modules.quotes.base.QuoteRemarkList;

public class ImportQuotes
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        logger.info("ImportQuotes-> Inserting Quote Groups");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "quoteGroup");
        if (!processOK) {
            return false;
        }
        logger.info("ImportQuotes-> Inserting Quote entry records");
        writer.setAutoCommit(false);
        QuoteList quoteList = new QuoteList();
        quoteList.buildList(db);
        mappings.saveList(writer, quoteList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportQuotes-> Inserting Quote Product records");
        writer.setAutoCommit(false);
        QuoteProductList quoteProductList = new QuoteProductList();
        quoteProductList.buildList(db);
        mappings.saveList(writer, quoteProductList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportQuotes-> Inserting QuoteProductOptionList records");
        writer.setAutoCommit(false);
        QuoteProductOptionList quoteProductOptionList = new QuoteProductOptionList();
        quoteProductOptionList.buildList(db);
        mappings.saveList(writer, quoteProductOptionList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportQuotes-> Inserting Quote Product Option Value Types");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "quoteProductOptionBoolean");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "quoteProductOptionFloat");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "quoteProductOptionTimestamp");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "quoteProductOptionInteger");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "quoteProductOptionText");
        if (!processOK) {
            return false;
        }
        logger.info("ImportQuotes-> Inserting QuoteConditionList records");
        writer.setAutoCommit(false);
        QuoteConditionList quoteConditionList = new QuoteConditionList();
        quoteConditionList.buildList(db);
        mappings.saveList(writer, quoteConditionList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportQuotes-> Inserting QuoteLogList records");
        writer.setAutoCommit(false);
        QuoteLogList quoteLogList = new QuoteLogList();
        quoteLogList.buildList(db);
        mappings.saveList(writer, quoteLogList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportQuotes-> Inserting QuoteRemarkList records");
        writer.setAutoCommit(false);
        QuoteRemarkList quoteRemarkList = new QuoteRemarkList();
        quoteRemarkList.buildList(db);
        mappings.saveList(writer, quoteRemarkList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportQuotes-> Inserting QuoteNoteList records");
        writer.setAutoCommit(false);
        QuoteNoteList quoteNoteList = new QuoteNoteList();
        quoteNoteList.buildList(db);
        mappings.saveList(writer, quoteNoteList, "insert");
        processOK = writer.commit();
        return processOK;
    }
}

