/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.reports.base.CriteriaList;
import org.aspcfs.modules.reports.base.ParameterList;
import org.aspcfs.modules.reports.base.QueueCriteriaList;
import org.aspcfs.modules.reports.base.ReportList;
import org.aspcfs.modules.reports.base.ReportQueueList;

public class ImportReports
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        logger.info("ImportReports-> Inserting ReportList records");
        writer.setAutoCommit(false);
        ReportList reportList = new ReportList();
        reportList.buildList(db);
        mappings.saveList(writer, reportList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportReports-> Inserting CriteriaList records");
        writer.setAutoCommit(false);
        CriteriaList criteriaList = new CriteriaList();
        criteriaList.buildList(db);
        mappings.saveList(writer, criteriaList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportReports-> Inserting ParameterList records");
        writer.setAutoCommit(false);
        ParameterList parameterList = new ParameterList();
        parameterList.buildList(db);
        mappings.saveList(writer, parameterList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportReports-> Inserting ReportQueueList records");
        writer.setAutoCommit(false);
        ReportQueueList reportQueueList = new ReportQueueList();
        reportQueueList.buildList(db);
        mappings.saveList(writer, reportQueueList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportReports-> Inserting QueueCriteriaList records");
        writer.setAutoCommit(false);
        QueueCriteriaList queueCriteriaList = new QueueCriteriaList();
        queueCriteriaList.buildList(db);
        mappings.saveList(writer, queueCriteriaList, "insert");
        processOK = writer.commit();
        return processOK;
    }
}

