/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.admin.base.PermissionCategoryList;
import org.aspcfs.modules.admin.base.PermissionList;
import org.aspcfs.modules.admin.base.RoleList;
import org.aspcfs.modules.admin.base.RolePermissionList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;

public class ImportRoles
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        writer.setAutoCommit(true);
        logger.info("ImportRoles-> Inserting Roles");
        RoleList roles = new RoleList();
        roles.setEnabledState(-1);
        roles.buildList(db);
        processOK = mappings.saveList(writer, roles, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportRoles-> Inserting Permission Categories");
        PermissionCategoryList categories = new PermissionCategoryList();
        categories.buildList(db);
        processOK = mappings.saveList(writer, categories, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportRoles-> Inserting Permissions");
        PermissionList permissions = new PermissionList();
        permissions.buildList(db);
        processOK = mappings.saveList(writer, permissions, "insert");
        if (!processOK) {
            return false;
        }
        logger.info("ImportRoles-> Inserting Role Permissions");
        RolePermissionList rolePermissions = new RolePermissionList();
        rolePermissions.buildCombinedList(db);
        processOK = mappings.saveList(writer, new ArrayList(rolePermissions.values()), "insert");
        if (!processOK) {
            return false;
        }
        User firstUser = new User(db, "0");
        DataRecord firstRecord = mappings.createDataRecord((Object)firstUser, "update");
        writer.save(firstRecord);
        UserList finalUserList = new UserList();
        finalUserList.buildList(db);
        processOK = mappings.saveList(writer, finalUserList, "update");
        return processOK;
    }
}

