/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.ImportLookupTables;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.tasks.base.TaskCategoryList;
import org.aspcfs.modules.tasks.base.TaskList;

public class ImportTasks
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        logger.info("ImportTasks-> Inserting TaskCategory records");
        writer.setAutoCommit(false);
        TaskCategoryList taskCategoryList = new TaskCategoryList();
        taskCategoryList.buildList(db);
        mappings.saveList(writer, taskCategoryList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTasks-> Inserting Task records");
        writer.setAutoCommit(false);
        TaskList taskList = new TaskList();
        taskList.buildList(db);
        mappings.saveList(writer, taskList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Task <--> Contact Links");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "taskLinkContact");
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Task <--> Ticket Links");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "taskLinkTicket");
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Task <--> Project Links");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "taskLinkProject");
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Task Category <--> Project Links");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "taskCategoryProject");
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Task Category <--> News Links");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "taskCategoryLinkNews");
        return processOK;
    }
}

