/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReaderImportModule;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.ImportLookupTables;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketActivityLogList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryAssignmentList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftAssignmentList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryList;
import org.aspcfs.modules.troubletickets.base.TicketDefectList;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.modules.troubletickets.base.TicketLogList;
import org.aspcfs.modules.troubletickets.base.TicketMaintenanceNoteList;
import org.aspcfs.modules.troubletickets.base.TicketPerDayDescriptionList;
import org.aspcfs.modules.troubletickets.base.TicketReplacementPartList;

public class ImportTickets
implements CFSDatabaseReaderImportModule {
    DataWriter writer = null;
    PropertyMapList mappings = null;

    public boolean process(DataWriter writer, Connection db, PropertyMapList mappings) throws SQLException {
        this.writer = writer;
        this.mappings = mappings;
        boolean processOK = true;
        logger.info("ImportTickets-> Inserting Ticket Lookups");
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "ticketSeverity");
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "ticketPriority");
        if (!processOK) {
            return false;
        }
        TicketCategoryList categoryList = new TicketCategoryList();
        categoryList.setEnabledState(-1);
        categoryList.buildList(db);
        Iterator categories = categoryList.iterator();
        while (categories.hasNext()) {
            DataRecord thisRecord = mappings.createDataRecord(categories.next(), "insert");
            if ("0".equals(thisRecord.getValue("parentCode"))) {
                thisRecord.removeField("parentCode");
                thisRecord.addField("parentCode", "0", null, null);
            }
            writer.save(thisRecord);
        }
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Tickets category drafts");
        writer.setAutoCommit(false);
        TicketCategoryDraftList ticketCategoryDraftList = new TicketCategoryDraftList();
        ticketCategoryDraftList.buildList(db, "ticket_category");
        mappings.saveList(writer, ticketCategoryDraftList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Tickets category draft assignments");
        writer.setAutoCommit(false);
        TicketCategoryDraftAssignmentList ticketCategoryDraftAssgList = new TicketCategoryDraftAssignmentList();
        ticketCategoryDraftAssgList.buildList(db);
        mappings.saveList(writer, ticketCategoryDraftAssgList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Tickets category draft assignments");
        writer.setAutoCommit(false);
        TicketCategoryAssignmentList ticketCategoryAssignmentList = new TicketCategoryAssignmentList();
        ticketCategoryAssignmentList.buildList(db);
        mappings.saveList(writer, ticketCategoryAssignmentList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Tickets");
        writer.setAutoCommit(false);
        TicketList ticList = new TicketList();
        ticList.buildList(db);
        this.saveTicketList(db, ticList);
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Ticket Log");
        TicketLogList ticketLogList = new TicketLogList();
        ticketLogList.setDoSystemMessages(false);
        ticketLogList.buildList(db);
        mappings.saveList(writer, ticketLogList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Ticket activity log");
        TicketActivityLogList ticketActivityLogList = new TicketActivityLogList();
        ticketActivityLogList.buildList(db);
        mappings.saveList(writer, ticketActivityLogList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Ticket activity item");
        TicketPerDayDescriptionList ticketPerDayDescriptionList = new TicketPerDayDescriptionList();
        ticketPerDayDescriptionList.buildList(db);
        mappings.saveList(writer, ticketPerDayDescriptionList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Ticket maintenance list");
        TicketMaintenanceNoteList ticketMaintenanceNoteList = new TicketMaintenanceNoteList();
        ticketMaintenanceNoteList.buildList(db);
        mappings.saveList(writer, ticketMaintenanceNoteList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Ticket replacement part list");
        TicketReplacementPartList ticketReplacementPartList = new TicketReplacementPartList();
        ticketReplacementPartList.queryList(db, -1);
        mappings.saveList(writer, ticketReplacementPartList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        processOK = ImportLookupTables.saveCustomLookupList(writer, db, mappings, "ticketLinkProject");
        if (!processOK) {
            return false;
        }
        logger.info("ImportTickets-> Inserting Ticket defect list");
        TicketDefectList ticketDefectList = new TicketDefectList();
        ticketDefectList.buildList(db);
        mappings.saveList(writer, ticketDefectList, "insert");
        processOK = writer.commit();
        if (!processOK) {
            return false;
        }
        writer.setAutoCommit(true);
        return true;
    }

    private void saveTicketList(Connection db, TicketList ticList) throws SQLException {
        for (Ticket ticket : ticList) {
            DataRecord thisRecord = this.mappings.createDataRecord((Object)ticket, "insert");
            if (ticket.getCatCode() == 0) {
                thisRecord.removeField("catCode");
                thisRecord.addField("catCode", -1);
            }
            if (ticket.getSubCat1() == 0) {
                thisRecord.removeField("subCat1");
                thisRecord.addField("subCat1", -1);
            }
            if (ticket.getSubCat2() == 0) {
                thisRecord.removeField("subCat2");
                thisRecord.addField("subCat2", -1);
            }
            if (ticket.getSubCat3() == 0) {
                thisRecord.removeField("subCat3");
                thisRecord.addField("subCat3", -1);
            }
            this.writer.save(thisRecord);
        }
    }
}

