/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.cfsdatabasereader;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.Transfer;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.Property;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMap;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyMapList
extends HashMap {
    private int count = 0;
    public static Logger logger = Logger.getLogger(Transfer.class.getName());

    public PropertyMapList() {
    }

    public PropertyMapList(String configFile, ArrayList modules) throws Exception {
        this.loadMap(configFile, modules);
    }

    public void loadMap(String mapFile, ArrayList modules) throws Exception {
        File configFile = new File(mapFile);
        XMLUtils xml = new XMLUtils(configFile);
        XMLUtils.getAllChildrenText(xml.getFirstChild("processes"), "module", modules);
        logger.info("PropertyMapList module count: " + modules.size());
        ArrayList mapElements = new ArrayList();
        XMLUtils.getAllChildren(xml.getFirstChild("mappings"), "map", mapElements);
        for (Element map : mapElements) {
            PropertyMap mapProperties = new PropertyMap();
            mapProperties.setId(map.getAttribute("id"));
            mapProperties.setTable(map.getAttribute("table"));
            mapProperties.setUniqueField(map.getAttribute("uniqueField"));
            NodeList nl = map.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                String value;
                String field;
                String alias;
                Node n = nl.item(i);
                if (n.getNodeType() != 1 || !((Element)n).getTagName().equals("property")) continue;
                String nodeText = XMLUtils.getNodeText((Element)n);
                Property thisProperty = null;
                thisProperty = nodeText != null ? new Property(nodeText) : new Property();
                String lookupValue = ((Element)n).getAttribute("lookup");
                if (lookupValue != null && !"".equals(lookupValue)) {
                    thisProperty.setLookupValue(lookupValue);
                }
                if ((alias = ((Element)n).getAttribute("alias")) != null && !"".equals(alias)) {
                    thisProperty.setAlias(alias);
                }
                if ((field = ((Element)n).getAttribute("field")) != null && !"".equals(field)) {
                    thisProperty.setField(field);
                }
                if ((value = ((Element)n).getAttribute("value")) != null && !"".equals(value)) {
                    thisProperty.setValue(value);
                }
                mapProperties.add(thisProperty);
            }
            if (this.containsKey(map.getAttribute("class"))) {
                this.put(map.getAttribute("class") + ++this.count, mapProperties);
                continue;
            }
            this.put(map.getAttribute("class"), mapProperties);
        }
    }

    public DataRecord createDataRecord(Object object, String action) {
        if (this.containsKey(object.getClass().getName())) {
            PropertyMap thisMap = (PropertyMap)this.get(object.getClass().getName());
            DataRecord record = new DataRecord();
            record.setName(thisMap.getId());
            record.setAction(action);
            for (Property thisProperty : thisMap) {
                if (thisProperty.getLookupValue() != null && "-1".equals(ObjectUtils.getParam(object, thisProperty.getName()))) continue;
                if (thisProperty.hasValue()) {
                    record.addField(thisProperty.getName(), thisProperty.getValue(), thisProperty.getLookupValue(), thisProperty.getAlias());
                    continue;
                }
                record.addField(thisProperty.getName(), ObjectUtils.getParam(object, thisProperty.getName()), thisProperty.getLookupValue(), thisProperty.getAlias());
            }
            return record;
        }
        logger.info("PropertyMapList-> Object mapping not found");
        return null;
    }

    public boolean saveList(DataWriter writer, AbstractList list, String action) {
        logger.info("Class: " + list.getClass().getName() + " Record count: " + list.size());
        boolean processOK = true;
        Iterator i = list.iterator();
        while (i.hasNext() && processOK) {
            Object object = i.next();
            logger.info("Object: " + object.getClass().getName());
            DataRecord thisRecord = this.createDataRecord(object, action);
            processOK = writer.save(thisRecord);
        }
        return processOK;
    }

    public PropertyMap getMap(String mapId) {
        for (String thisMapName : this.keySet()) {
            PropertyMap thisMap = (PropertyMap)this.get(thisMapName);
            if (!mapId.equals(thisMap.getId())) continue;
            return thisMap;
        }
        return null;
    }
}

