/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.csvreader;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.aspcfs.apps.transfer.DataReader;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;

public class CSVReader
implements DataReader {
    public static final String lf = System.getProperty("line.separator");
    public static final String fs = System.getProperty("file.separator");
    protected String csvFile = null;
    protected String propertyFile = null;
    protected PropertyMapList mappings = null;
    protected boolean ignoreRow1 = true;
    protected int importUserId = -1;

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "CSVReader";
    }

    public String getDescription() {
        return "Base class for processing CSV files for import, should not be used directly by Reader application";
    }

    public int getImportUserId() {
        return this.importUserId;
    }

    public void setImportUserId(int tmp) {
        this.importUserId = tmp;
    }

    public void setImportUserId(String tmp) {
        this.importUserId = Integer.parseInt(tmp);
    }

    public void setCsvFile(String tmp) {
        this.csvFile = tmp;
    }

    public void setPropertyFile(String tmp) {
        this.propertyFile = tmp;
    }

    public void setMappings(PropertyMapList tmp) {
        this.mappings = tmp;
    }

    public void setIgnoreRow1(boolean tmp) {
        this.ignoreRow1 = tmp;
    }

    public void setIgnoreRow1(String tmp) {
        this.ignoreRow1 = DatabaseUtils.parseBoolean(tmp);
    }

    public String getCsvFile() {
        return this.csvFile;
    }

    public PropertyMapList getMappings() {
        return this.mappings;
    }

    public boolean getIgnoreRow1() {
        return this.ignoreRow1;
    }

    public boolean isConfigured() {
        File importFile;
        boolean configOK = true;
        String tmpFile = System.getProperty("processConfigFile");
        if (tmpFile != null && !"".equals(tmpFile)) {
            this.csvFile = tmpFile;
        }
        if (!(importFile = new File(this.csvFile)).exists()) {
            logger.info("ImportAccounts-> Config: file not found: " + this.csvFile);
            configOK = false;
        }
        try {
            this.mappings = new PropertyMapList(this.propertyFile, new ArrayList());
        }
        catch (Exception e) {
            logger.info("ImportAccounts-> Config: mappings could not be loaded");
            configOK = false;
        }
        return configOK;
    }

    public boolean execute(DataWriter writer) {
        return false;
    }

    public String getValue(ArrayList record, int column) {
        if (column > record.size() || column < 1) {
            return null;
        }
        String value = (String)record.get(column - 1);
        value = StringUtils.replace(value, "\\r\\n", lf);
        value = StringUtils.replace(value, "\\n\\r", lf);
        value = StringUtils.replace(value, "\\n", lf);
        value = StringUtils.replace(value, "\\r", lf);
        return value.trim();
    }

    protected int findColumn(ArrayList record, String[] names) {
        int result = 0;
        for (int i = 0; i < names.length; ++i) {
            int test = this.findColumn(record, names[i]);
            if (test <= 0) continue;
            result = test;
        }
        return result;
    }

    protected int findColumn(ArrayList record, String name) {
        int column = 0;
        if (name != null) {
            column = record.indexOf(name) + 1;
        }
        if (column == 0) {
            System.out.println("ImportAccounts-> Column not found for parsing: " + name);
        } else {
            System.out.println("ImportAccounts-> Column found for parsing: " + name + " (" + column + ")");
        }
        return column;
    }

    protected void writeln(PrintWriter out, ArrayList thisRecord) {
        System.out.println("Fields in line: " + thisRecord.size());
        for (int i = 0; i < thisRecord.size(); ++i) {
            String field = (String)thisRecord.get(i);
            if (field.indexOf(",") > -1) {
                out.print("\"" + field + "\"");
            } else {
                out.print(field);
            }
            if (i >= thisRecord.size() - 1) continue;
            out.print(",");
        }
        out.println("");
    }
}

