/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.excelreader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.aspcfs.apps.transfer.DataReader;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;

public class ExcelTicketCategoryReader
implements DataReader {
    public boolean ignoreRow1 = true;
    private String excelFile = "workbook.xls";

    public void setExcelFile(String tmp) {
        this.excelFile = tmp;
    }

    public void setIgnoreRow1(boolean tmp) {
        this.ignoreRow1 = tmp;
    }

    public String getExcelFile() {
        return this.excelFile;
    }

    public boolean getIgnoreRow1() {
        return this.ignoreRow1;
    }

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "Excel Ticket Category Reader";
    }

    public String getDescription() {
        return "Reads data from an Excel file formatted with ticket category data";
    }

    public boolean isConfigured() {
        if (this.excelFile == null || "".equals(this.excelFile)) {
            return false;
        }
        File testFile = new File(this.excelFile);
        return testFile.exists();
    }

    public boolean execute(DataWriter writer) {
        logger.info("Processing excel file");
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(this.excelFile));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int rows = sheet.getLastRowNum();
            int beginningRow = 0;
            if (this.ignoreRow1) {
                ++beginningRow;
            }
            for (int r = beginningRow; r < rows + 1; ++r) {
                HSSFRow row = sheet.getRow(r);
                if (row == null) continue;
                int cells = 4;
                System.out.println("ROW " + row.getRowNum());
                for (int c = 0; c < cells; ++c) {
                    HSSFCell cell = row.getCell((short)c);
                    if (cell == null) continue;
                    DataRecord thisRecord = new DataRecord();
                    thisRecord.addField("catLevel", String.valueOf(cell.getCellNum()));
                    thisRecord.addField("description", cell.getStringCellValue());
                    writer.save(thisRecord);
                }
            }
        }
        catch (IOException io) {
            io.printStackTrace(System.out);
        }
        return true;
    }
}

