/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.mapreader;

import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.apps.transfer.reader.mapreader.Property;
import org.aspcfs.apps.transfer.reader.mapreader.PropertyMap;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DependencyMap
extends PropertyMap {
    private String dependencyId = null;
    private String displayName = null;
    private boolean hasGroups = false;
    private ArrayList requiredProperties = new ArrayList();
    private ArrayList groupList = new ArrayList();

    public DependencyMap(Node n) {
        String tmp = ((Element)n).getAttribute("id");
        if (tmp != null) {
            this.dependencyId = tmp;
        }
        NodeList nl = n.getChildNodes();
        for (int j = 0; j < nl.getLength(); ++j) {
            Node p = nl.item(j);
            if (p.getNodeType() != 1) continue;
            if (((Element)p).getTagName().equals("properties") && (tmp = XMLUtils.getNodeText((Element)p)) != null) {
                this.requiredProperties = StringUtils.toArrayList(tmp, ",");
            }
            if (((Element)p).getTagName().equals("enableGroups") && (tmp = XMLUtils.getNodeText((Element)p)) != null) {
                this.setHasGroups(tmp);
            }
            if (!((Element)p).getTagName().equals("displayName") || (tmp = XMLUtils.getNodeText((Element)p)) == null) continue;
            this.setDisplayName(tmp);
        }
    }

    public void setRequiredProperties(ArrayList tmp) {
        this.requiredProperties = tmp;
    }

    public void setGroupList(ArrayList tmp) {
        this.groupList = tmp;
    }

    public ArrayList getRequiredProperties() {
        return this.requiredProperties;
    }

    public ArrayList getGroupList() {
        return this.groupList;
    }

    public void setDependencyId(String tmp) {
        this.dependencyId = tmp;
    }

    public void setHasGroups(boolean tmp) {
        this.hasGroups = tmp;
    }

    public void setHasGroups(String tmp) {
        this.hasGroups = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getHasGroups() {
        return this.hasGroups;
    }

    public String getDependencyId() {
        return this.dependencyId;
    }

    public PropertyMap getGroup(int groupId) {
        return (PropertyMap)this.groupList.get(groupId);
    }

    public void add(PropertyMap map) {
        this.groupList.add(map);
    }

    public void loadMap(Element map) {
        PropertyMap dependencyMap = new PropertyMap();
        dependencyMap.setDisplayName(map.getAttribute("displayName"));
        String mapId = map.getAttribute("id");
        dependencyMap.setId(mapId + "_1");
        if (System.getProperty("DEBUG") != null) {
            System.out.println("DependencyMap -> Loading Dependency Map " + map.getAttribute("id"));
        }
        NodeList nl = map.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !((Element)n).getTagName().equals("properties")) continue;
            NodeList nl1 = n.getChildNodes();
            for (int j = 0; j < nl1.getLength(); ++j) {
                String nodeText;
                Node p = nl1.item(j);
                if (p.getNodeType() != 1 || !((Element)p).getTagName().equals("property") || (nodeText = XMLUtils.getNodeText((Element)p)) == null || !this.requiredProperties.contains(nodeText.trim())) continue;
                Property thisProperty = new Property(p);
                thisProperty.setUniqueName(mapId + "." + thisProperty.getName());
                if (thisProperty.isValid()) {
                    dependencyMap.addProperty(thisProperty);
                    if (System.getProperty("DEBUG") == null) continue;
                    System.out.println("DependencyMap -> Adding Property " + thisProperty.getName());
                    continue;
                }
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("Invalid Property : " + thisProperty.getName());
            }
        }
        this.groupList.add(dependencyMap);
    }

    public PropertyMap getMap(String instanceId) throws CloneNotSupportedException {
        PropertyMap map = null;
        for (PropertyMap thisMap : this.groupList) {
            if (!thisMap.getId().equals(instanceId)) continue;
            map = thisMap;
            break;
        }
        if (map == null) {
            PropertyMap thisMap;
            thisMap = (PropertyMap)this.groupList.get(0);
            map = thisMap.duplicate(instanceId);
            this.groupList.add(map);
        }
        return map;
    }

    public Property mapProperty(String field) throws CloneNotSupportedException {
        Property mappedProperty = null;
        boolean found = false;
        PropertyMap dMap = (PropertyMap)this.groupList.get(0);
        Iterator props = dMap.getProperties().keySet().iterator();
        while (props.hasNext() && !found) {
            String propertyName = (String)props.next();
            Property thisProperty = (Property)dMap.getProperties().get(propertyName);
            if (!thisProperty.hasAlias(field)) continue;
            int groupId = 1;
            if (thisProperty.getMappedColumn() < 0) {
                mappedProperty = thisProperty;
            } else {
                groupId = this.groupList.size() + 1;
                PropertyMap thisMap = this.getMap(this.dependencyId + "_" + groupId);
                mappedProperty = (Property)thisMap.getProperties().get(thisProperty.getName());
            }
            mappedProperty.setGroupId(groupId);
            found = true;
        }
        return mappedProperty;
    }
}

