/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.mapreader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Property
implements Cloneable {
    private String name = null;
    private String delimiter = null;
    private String lookupTable = null;
    private String displayName = null;
    private String uniqueName = null;
    private String defaultValue = null;
    private String substitute = null;
    private int mappedColumn = -1;
    private int groupId = -1;
    private boolean required = false;
    private boolean multiple = false;
    private boolean isForPrompting = true;
    private ArrayList aliases = null;
    private ArrayList dependencies = null;

    public ArrayList getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(ArrayList tmp) {
        this.dependencies = tmp;
    }

    public Property() {
    }

    public Property(String name) {
        this.name = name;
    }

    public Property(Node n) {
        String dependency;
        String tmpValue;
        String nodeText = XMLUtils.getNodeText((Element)n);
        if (nodeText != null) {
            this.name = nodeText;
        }
        if (!"".equals(StringUtils.toString(tmpValue = ((Element)n).getAttribute("aliases")))) {
            this.setAliases(StringUtils.toArrayList(tmpValue, ","));
        }
        if (!"".equals(StringUtils.toString(tmpValue = ((Element)n).getAttribute("required")))) {
            this.setRequired(tmpValue);
        }
        if (!"".equals(StringUtils.toString(tmpValue = ((Element)n).getAttribute("lookup_table")))) {
            this.setLookupTable(tmpValue);
        }
        if (!"".equals(StringUtils.toString(tmpValue = ((Element)n).getAttribute("multiple")))) {
            this.setMultiple(tmpValue);
            tmpValue = ((Element)n).getAttribute("delimiter");
            if (!"".equals(StringUtils.toString(tmpValue))) {
                this.setDelimiter(tmpValue);
            }
        }
        if (!"".equals(StringUtils.toString(tmpValue = ((Element)n).getAttribute("displayName")))) {
            this.setDisplayName(tmpValue);
        }
        if (!"".equals(StringUtils.toString(tmpValue = ((Element)n).getAttribute("isForPrompting")))) {
            this.setIsForPrompting(tmpValue);
        }
        if (!"".equals(StringUtils.toString(tmpValue = ((Element)n).getAttribute("substitute")))) {
            this.setSubstitute(tmpValue);
        }
        if (!"".equals(StringUtils.toString(dependency = ((Element)n).getAttribute("depends")))) {
            this.dependencies = StringUtils.toArrayList(dependency, ",");
        }
    }

    public boolean checkIsRequired(HashMap fieldMappings) {
        if (this.dependencies != null) {
            for (String dependency : this.dependencies) {
                for (String field : fieldMappings.keySet()) {
                    Property mappedProperty = (Property)fieldMappings.get(field);
                    if (mappedProperty == null || mappedProperty.getName() == null || !dependency.equals(mappedProperty.getName())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setAliases(ArrayList tmp) {
        this.aliases = tmp;
    }

    public void setDefaultValue(String tmp) {
        this.defaultValue = tmp;
    }

    public void setRequired(boolean tmp) {
        this.required = tmp;
    }

    public void setRequired(String tmp) {
        this.required = DatabaseUtils.parseBoolean(tmp);
    }

    public void setMultiple(boolean tmp) {
        this.multiple = tmp;
    }

    public void setMultiple(String tmp) {
        this.multiple = DatabaseUtils.parseBoolean(tmp);
    }

    public void setMappedColumn(int tmp) {
        this.mappedColumn = tmp;
    }

    public void setMappedColumn(String tmp) {
        this.mappedColumn = Integer.parseInt(tmp);
    }

    public void setLookupTable(String tmp) {
        this.lookupTable = tmp;
    }

    public void setDelimiter(String tmp) {
        this.delimiter = tmp;
    }

    public void setDisplayName(String tmp) {
        this.displayName = tmp;
    }

    public void setUniqueName(String tmp) {
        this.uniqueName = tmp;
    }

    public void setIsForPrompting(boolean tmp) {
        this.isForPrompting = tmp;
    }

    public void setIsForPrompting(String tmp) {
        this.isForPrompting = DatabaseUtils.parseBoolean(tmp);
    }

    public void setGroupId(int tmp) {
        this.groupId = tmp;
    }

    public void setGroupId(String tmp) {
        this.groupId = Integer.parseInt(tmp);
    }

    public void setSubstitute(String tmp) {
        this.substitute = tmp;
    }

    public String getSubstitute() {
        return this.substitute;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public boolean getIsForPrompting() {
        return this.isForPrompting;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getDependencyName() {
        if ("".equals(StringUtils.toString(this.uniqueName)) || this.uniqueName.indexOf(".") == -1) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(this.uniqueName, ".");
        String tmp = tokens.nextToken();
        if (tokens.hasMoreTokens()) {
            return tmp;
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getAliases() {
        return this.aliases;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean getRequired() {
        return this.required;
    }

    public boolean getMultiple() {
        return this.multiple;
    }

    public int getMappedColumn() {
        return this.mappedColumn;
    }

    public String getLookupTable() {
        return this.lookupTable;
    }

    public boolean isValid() {
        return !"".equals(StringUtils.toString(this.name));
    }

    public Property duplicate() throws CloneNotSupportedException {
        return (Property)this.clone();
    }

    public boolean hasAlias(String tmp) {
        if (this.aliases == null || tmp == null) {
            return false;
        }
        boolean found = false;
        String field = tmp;
        Iterator i = this.aliases.iterator();
        while (i.hasNext() && !found) {
            String alias = (String)i.next();
            if (!alias.equals(tmp.toLowerCase())) continue;
            found = true;
        }
        return found;
    }

    public String toString() {
        StringBuffer info = new StringBuffer();
        info.append("======================================\n");
        info.append("Name: " + this.getName() + "\n");
        info.append("Aliases: " + this.getAliases() + "\n");
        info.append("Required: " + this.getRequired() + "\n");
        info.append("MappedColumn: " + this.getMappedColumn() + "\n");
        info.append("======================================\n");
        return info.toString();
    }
}

