/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.mapreader;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.aspcfs.apps.transfer.reader.mapreader.DependencyMap;
import org.aspcfs.apps.transfer.reader.mapreader.Property;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.XMLUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyMap {
    private String id = null;
    private String displayName = null;
    private LinkedHashMap properties = new LinkedHashMap();
    private HashMap dependencies = null;

    public PropertyMap() {
    }

    public PropertyMap(String mapFile, String mapName) {
        this.loadMap(mapFile, mapName);
    }

    public void setDisplayName(String tmp) {
        this.displayName = tmp;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setId(String tmp) {
        this.id = tmp;
    }

    public void setProperties(LinkedHashMap tmp) {
        this.properties = tmp;
    }

    public void setDependencies(HashMap tmp) {
        this.dependencies = tmp;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public HashMap getDependencies() {
        return this.dependencies;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasProperties() {
        return this.properties.size() > 0;
    }

    public boolean addProperty(Property thisProperty) {
        if (this.properties.containsKey(thisProperty.getName())) {
            return false;
        }
        this.properties.put(thisProperty.getName(), thisProperty);
        return true;
    }

    public void loadMap(String mapFile, String mapName) {
        block11: {
            try {
                File configFile = new File(mapFile);
                XMLUtils xml = new XMLUtils(configFile);
                ArrayList mapElements = new ArrayList();
                XMLUtils.getAllChildren(xml.getFirstChild("mappings"), "map", mapElements);
                for (Element map : mapElements) {
                    if (!map.getAttribute("id").equals(mapName)) continue;
                    this.setId(map.getAttribute("id"));
                    this.setDisplayName(map.getAttribute("displayName"));
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("PropertyMap -> Adding Map " + map.getAttribute("id"));
                    }
                    NodeList nl = map.getChildNodes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        int j;
                        NodeList nl1;
                        Node n = nl.item(i);
                        if (n.getNodeType() == 1 && ((Element)n).getTagName().equals("properties")) {
                            nl1 = n.getChildNodes();
                            for (j = 0; j < nl1.getLength(); ++j) {
                                Node p = nl1.item(j);
                                if (p.getNodeType() != 1 || !((Element)p).getTagName().equals("property")) continue;
                                Property thisProperty = new Property(p);
                                thisProperty.setUniqueName(mapName + "." + thisProperty.getName());
                                if (!thisProperty.isValid()) continue;
                                this.addProperty(thisProperty);
                            }
                        }
                        if (n.getNodeType() != 1 || !((Element)n).getTagName().equals("dependencies")) continue;
                        this.dependencies = new HashMap();
                        nl1 = n.getChildNodes();
                        for (j = 0; j < nl1.getLength(); ++j) {
                            Node d = nl1.item(j);
                            if (d.getNodeType() != 1 || !((Element)d).getTagName().equals("dependency")) continue;
                            DependencyMap dMap = new DependencyMap(d);
                            if (System.getProperty("DEBUG") != null) {
                                System.out.println("PropertyMap -> Adding Dependency " + dMap.getDependencyId());
                            }
                            this.dependencies.put(dMap.getDependencyId(), dMap);
                        }
                    }
                }
                if (this.dependencies != null && this.dependencies.size() > 0) {
                    for (Element map : mapElements) {
                        String mapId = map.getAttribute("id");
                        if (!this.dependencies.containsKey(mapId)) continue;
                        DependencyMap dMap = (DependencyMap)this.dependencies.get(mapId);
                        dMap.loadMap(map);
                    }
                }
            }
            catch (Exception e) {
                if (System.getProperty("DEBUG") == null) break block11;
                System.out.println("PropertyMap -> EXCEPTION " + e);
            }
        }
    }

    public Property getProperty(String propertyName) {
        Property p = null;
        if (this.properties != null && this.properties.containsKey(propertyName)) {
            p = (Property)this.properties.get(propertyName);
        }
        return p;
    }

    public ArrayList getDependencyMapList(String mapId) {
        ArrayList mapList = null;
        if (this.dependencies != null && this.dependencies.containsKey(mapId)) {
            DependencyMap dMap = (DependencyMap)this.dependencies.get(mapId);
            mapList = dMap.getGroupList();
        }
        return mapList;
    }

    public boolean hasGroups(String dependencyId) {
        DependencyMap dMap;
        if ("".equals(StringUtils.toString(dependencyId))) {
            return false;
        }
        return this.dependencies != null && this.dependencies.containsKey(dependencyId) && (dMap = (DependencyMap)this.dependencies.get(dependencyId)).getHasGroups();
    }

    public Property mapProperty(String field, int position) throws CloneNotSupportedException {
        Property mappedProperty = null;
        boolean found = false;
        Iterator props = this.properties.keySet().iterator();
        while (props.hasNext() && !found) {
            String propertyName = (String)props.next();
            Property thisProperty = (Property)this.properties.get(propertyName);
            if (!thisProperty.hasAlias(field)) continue;
            thisProperty.setMappedColumn(position);
            mappedProperty = thisProperty;
            found = true;
        }
        if (this.dependencies != null && !found) {
            Iterator d = this.dependencies.keySet().iterator();
            while (d.hasNext() && !found) {
                String dKey = (String)d.next();
                DependencyMap thisMap = (DependencyMap)this.dependencies.get(dKey);
                mappedProperty = thisMap.mapProperty(field);
                if (mappedProperty == null) continue;
                mappedProperty.setMappedColumn(position);
                found = true;
                break;
            }
        }
        return mappedProperty;
    }

    public Property getProperty(String field, String uniquePropertyName, String groupId) throws CloneNotSupportedException {
        if ("".equals(StringUtils.toString(groupId))) {
            return this.getProperty(field, uniquePropertyName, -1);
        }
        return this.getProperty(field, uniquePropertyName, Integer.parseInt(groupId));
    }

    public Property getProperty(String field, String uniquePropertyName, int groupId) throws CloneNotSupportedException {
        Property mappedProperty = null;
        String mapId = null;
        String propertyName = null;
        StringTokenizer tokens = new StringTokenizer(uniquePropertyName, ".");
        if (tokens.hasMoreTokens()) {
            mapId = tokens.nextToken();
            propertyName = tokens.nextToken();
        }
        if (this.getId().equals(mapId)) {
            if (this.properties.containsKey(propertyName)) {
                mappedProperty = (Property)this.properties.get(propertyName);
            }
        } else {
            DependencyMap dMap = (DependencyMap)this.dependencies.get(mapId);
            if (groupId == -1) {
                groupId = dMap.getGroupList().size() + 1;
            }
            PropertyMap thisMap = dMap.getMap(mapId + "_" + groupId);
            mappedProperty = thisMap.getProperty(propertyName);
            mappedProperty.setGroupId(groupId);
        }
        return mappedProperty;
    }

    public ArrayList getRequiredProperties() {
        ArrayList<Property> requiredList = new ArrayList<Property>();
        for (String propertyName : this.properties.keySet()) {
            Property thisProperty = (Property)this.properties.get(propertyName);
            if (!thisProperty.getRequired()) continue;
            requiredList.add(thisProperty);
        }
        return requiredList;
    }

    public DependencyMap getDependencyMap(String mapId) {
        DependencyMap thisMap = null;
        if (this.dependencies != null && this.dependencies.containsKey(mapId)) {
            thisMap = (DependencyMap)this.dependencies.get(mapId);
        }
        return thisMap;
    }

    public PropertyMap duplicate(String instanceId) throws CloneNotSupportedException {
        PropertyMap duplicateMap = new PropertyMap();
        duplicateMap.setId(instanceId);
        for (String propertyName : this.properties.keySet()) {
            Property thisProperty = (Property)this.properties.get(propertyName);
            Property clonedProperty = thisProperty.duplicate();
            clonedProperty.setMappedColumn(-1);
            duplicateMap.getProperties().put(clonedProperty.getName(), clonedProperty);
        }
        return duplicateMap;
    }

    public String getHtmlSelect(String field, Property mapping) {
        String defaultKey = "-1";
        if (mapping != null) {
            defaultKey = mapping.getUniqueName();
        }
        HtmlSelect htmlSelect = new HtmlSelect();
        htmlSelect.setSelectName(field);
        htmlSelect.addAttribute("onChange", "javascript:checkPrompt('" + field + "');");
        htmlSelect.addAttribute("id", field);
        htmlSelect.addItem("-1", " ");
        htmlSelect.addGroup(this.getDisplayName());
        for (String propertyName : this.properties.keySet()) {
            Property thisProperty = (Property)this.properties.get(propertyName);
            if (!thisProperty.getIsForPrompting() || "".equals(StringUtils.toString(thisProperty.getDisplayName()))) continue;
            htmlSelect.addItem(thisProperty.getUniqueName(), thisProperty.getDisplayName());
        }
        if (this.dependencies != null) {
            for (String dKey : this.dependencies.keySet()) {
                DependencyMap thisMap = (DependencyMap)this.dependencies.get(dKey);
                ArrayList thisList = thisMap.getGroupList();
                PropertyMap dMap = (PropertyMap)thisList.get(0);
                htmlSelect.addGroup(dMap.getDisplayName());
                for (String propertyName : dMap.getProperties().keySet()) {
                    Property thisProperty = (Property)dMap.getProperties().get(propertyName);
                    if (!thisProperty.getIsForPrompting() || "".equals(StringUtils.toString(thisProperty.getDisplayName()))) continue;
                    htmlSelect.addItem(thisProperty.getUniqueName(), thisProperty.getDisplayName());
                }
            }
        }
        return htmlSelect.getHtml(field, defaultKey);
    }

    public String getGroupHtmlSelect(String selectName, int defaultKey, String groupType) {
        HtmlSelect htmlSelect = new HtmlSelect();
        htmlSelect.setSelectName(selectName);
        htmlSelect.addAttribute("id", selectName);
        for (int i = 1; i < 11; ++i) {
            htmlSelect.addItem(String.valueOf(i), (groupType != null ? groupType : "Group") + i);
        }
        return htmlSelect.getHtml(selectName, defaultKey);
    }
}

