/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.reader.netdescisions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.aspcfs.apps.transfer.DataReader;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.contacts.base.ContactPhoneNumberList;

public class NetDescAccountsReader
implements DataReader {
    private DataWriter writer = null;
    private PropertyMapList mappings = null;
    private String excelFile = "ActToCFS22Jan03.xls";
    private boolean ignoreRow1 = true;
    private String propertyFile = null;

    public void setExcelFile(String tmp) {
        this.excelFile = tmp;
    }

    public void setIgnoreRow1(boolean tmp) {
        this.ignoreRow1 = tmp;
    }

    public void setPropertyFile(String tmp) {
        this.propertyFile = tmp;
    }

    public String getExcelFile() {
        return this.excelFile;
    }

    public boolean getIgnoreRow1() {
        return this.ignoreRow1;
    }

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "Excel NetDescisions Accounts Transfer Reader";
    }

    public String getDescription() {
        return "Reads data from an Excel file formatted with Account Contacts data";
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public boolean isConfigured() {
        logger.info("Checking Reader Configuration");
        if (this.excelFile == null || "".equals(this.excelFile)) {
            logger.info("Reader Configuration FAILED -- Excel File not specified ");
            return false;
        }
        File testFile = new File(this.excelFile);
        if (!testFile.exists()) {
            logger.info("Reader Configuration FAILED -- Excel File does not exist ");
            return false;
        }
        try {
            this.mappings = new PropertyMapList(this.propertyFile, new ArrayList());
        }
        catch (Exception e) {
            logger.info(e.toString());
            return false;
        }
        return true;
    }

    public boolean execute(DataWriter writer) {
        this.writer = writer;
        boolean processOK = true;
        logger.info("Processing excel file" + this.excelFile);
        try {
            int userId = 1;
            DataRecord newUserRecord = new DataRecord();
            newUserRecord.setName("user");
            newUserRecord.setAction("insert");
            newUserRecord.addField("guid", userId);
            newUserRecord.addField("username", "Electronic Importer");
            newUserRecord.addField("contactId", 1030);
            newUserRecord.addField("encryptedPassword", "none");
            writer.save(newUserRecord);
            HashMap accounts = new HashMap();
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(this.excelFile));
            System.out.println("INFO: Created FileSystem");
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            System.out.println("INFO: Created WorkBook");
            HSSFSheet sheet = wb.getSheetAt(0);
            System.out.println("INFO: Got Sheet");
            int rows = sheet.getLastRowNum();
            int beginningRow = 0;
            if (this.ignoreRow1) {
                ++beginningRow;
            }
            for (int r = beginningRow; r < rows + 1; ++r) {
                HSSFRow row = sheet.getRow(r);
                if (row == null) continue;
                logger.info("ROW " + row.getRowNum());
                short firstCellNum = row.getFirstCellNum();
                logger.info("Processing Account " + this.getCellValue(row.getCell(firstCellNum)));
                int orgId = r;
                logger.info("Adding Contact " + this.getCellValue(row.getCell((short)(firstCellNum + 2))));
                Contact cfsContact = null;
                if (!"".equals(this.getCellValue(row.getCell((short)(firstCellNum + 2))))) {
                    cfsContact = new Contact();
                    cfsContact.setId(r);
                    String contactInfo = this.getCellValue(row.getCell((short)(firstCellNum + 2)));
                    if (!"".equals(contactInfo)) {
                        StringTokenizer st = new StringTokenizer(contactInfo, ",");
                        if (st.countTokens() > 1) {
                            cfsContact.setNameLast(st.nextToken());
                            cfsContact.setNameFirst(st.nextToken());
                        } else {
                            StringTokenizer st1 = new StringTokenizer(contactInfo, " ");
                            cfsContact.setNameFirst(st1.nextToken());
                            if (st1.hasMoreTokens()) {
                                String middleName = "";
                                while (st1.hasMoreTokens()) {
                                    if (st1.countTokens() == 1) {
                                        cfsContact.setNameMiddle(middleName);
                                        cfsContact.setNameLast(st1.nextToken());
                                        continue;
                                    }
                                    middleName = middleName + st1.nextToken();
                                    if (st1.countTokens() <= 1) continue;
                                    middleName = middleName + " ";
                                }
                            } else {
                                cfsContact.setNameLast(cfsContact.getNameFirst());
                                cfsContact.setNameFirst("");
                            }
                        }
                    }
                    cfsContact.setTitle(this.getCellValue(row.getCell((short)(firstCellNum + 13))));
                    cfsContact.setNameSalutation(this.getCellValue(row.getCell((short)(firstCellNum + 12))));
                    cfsContact.setEnteredBy(userId);
                    cfsContact.setOwner(userId);
                    cfsContact.setModifiedBy(userId);
                    cfsContact.setCompany(this.getCellValue(row.getCell(firstCellNum)));
                } else {
                    logger.info("INVALID RECORD : No Contact Name Associated with " + r);
                }
                ContactAddress cfsAddress = null;
                if (!"".equals(this.getCellValue(row.getCell((short)(firstCellNum + 3))))) {
                    logger.info("Adding Contact Address ");
                    cfsAddress = new ContactAddress();
                    String addressLine1 = this.getCellValue(row.getCell((short)(firstCellNum + 3)));
                    String city = this.getCellValue(row.getCell((short)(firstCellNum + 4)));
                    if (!(addressLine1 == null || city == null || "".equals(addressLine1) || "".equals(city) || addressLine1.indexOf(city) == -1 || "NA".equals(addressLine1) || "NA".equals(city) || !(addressLine1 = addressLine1.substring(0, addressLine1.indexOf(city) - 1)).endsWith(","))) {
                        addressLine1 = addressLine1.substring(0, addressLine1.length() - 1);
                    }
                    cfsAddress.setStreetAddressLine1(addressLine1);
                    cfsAddress.setType(1);
                    cfsAddress.setCity(this.getCellValue(row.getCell((short)(firstCellNum + 4))));
                    cfsAddress.setState(this.getCellValue(row.getCell((short)(firstCellNum + 5))).toUpperCase());
                    cfsAddress.setZip(this.getCellValue(row.getCell((short)(firstCellNum + 6))));
                    cfsAddress.setCountry(this.getCellValue(row.getCell((short)(firstCellNum + 7))));
                    cfsAddress.setContactId(r);
                    cfsAddress.setEnteredBy(userId);
                    cfsAddress.setModifiedBy(userId);
                }
                ContactPhoneNumberList cfsContPhList = new ContactPhoneNumberList();
                String NetDescComPN = this.getCellValue(row.getCell((short)(firstCellNum + 9)));
                if (!"".equals(NetDescComPN)) {
                    StringTokenizer st = new StringTokenizer(NetDescComPN, "/");
                    while (st.hasMoreTokens()) {
                        ContactPhoneNumber cfsPhNumber = new ContactPhoneNumber();
                        cfsPhNumber.setType(1);
                        cfsPhNumber.setNumber(st.nextToken());
                        cfsPhNumber.setContactId(r);
                        cfsPhNumber.setEnteredBy(userId);
                        cfsPhNumber.setModifiedBy(userId);
                        cfsContPhList.add(cfsPhNumber);
                    }
                }
                logger.info("Contact Phone Numbers ");
                String NetDescContPN = this.getCellValue(row.getCell((short)(firstCellNum + 8)));
                if (!"".equals(NetDescContPN)) {
                    StringTokenizer st = new StringTokenizer(NetDescContPN, "/");
                    while (st.hasMoreTokens()) {
                        ContactPhoneNumber cfsPhNumber = new ContactPhoneNumber();
                        cfsPhNumber.setType(1);
                        StringTokenizer st1 = new StringTokenizer(st.nextToken(), "x");
                        String number = st1.nextToken();
                        logger.info("Primary -- " + number);
                        cfsPhNumber.setNumber(number);
                        if (st1.hasMoreTokens()) {
                            cfsPhNumber.setExtension(st1.nextToken());
                        }
                        cfsPhNumber.setEnteredBy(userId);
                        cfsPhNumber.setModifiedBy(userId);
                        cfsPhNumber.setContactId(r);
                        cfsContPhList.add(cfsPhNumber);
                    }
                }
                ContactPhoneNumber cfsFaxPhNumber = null;
                if (!"".equals(this.getCellValue(row.getCell((short)(firstCellNum + 10))))) {
                    cfsFaxPhNumber = new ContactPhoneNumber();
                    cfsFaxPhNumber.setType(3);
                    cfsFaxPhNumber.setEnteredBy(userId);
                    cfsFaxPhNumber.setModifiedBy(userId);
                    String number = this.getCellValue(row.getCell((short)(firstCellNum + 10)));
                    logger.info("Fax -- " + number);
                    cfsFaxPhNumber.setNumber(number);
                    cfsFaxPhNumber.setContactId(r);
                    cfsContPhList.add(cfsFaxPhNumber);
                }
                ContactPhoneNumber cfsMobilePhNumber = null;
                if (!"".equals(this.getCellValue(row.getCell((short)(firstCellNum + 11))))) {
                    cfsMobilePhNumber = new ContactPhoneNumber();
                    cfsMobilePhNumber.setType(7);
                    cfsMobilePhNumber.setEnteredBy(userId);
                    cfsMobilePhNumber.setModifiedBy(userId);
                    String number = this.getCellValue(row.getCell((short)(firstCellNum + 11)));
                    logger.info("Mobile -- " + number);
                    cfsMobilePhNumber.setNumber(number);
                    cfsMobilePhNumber.setContactId(r);
                    cfsContPhList.add(cfsMobilePhNumber);
                }
                logger.info("EmailAddress -- " + this.getCellValue(row.getCell((short)(firstCellNum + 15))));
                ContactEmailAddress cfsEmailAddress = null;
                if (!"".equals(this.getCellValue(row.getCell((short)(firstCellNum + 15))))) {
                    cfsEmailAddress = new ContactEmailAddress();
                    cfsEmailAddress.setType(1);
                    cfsEmailAddress.setEmail(this.getCellValue(row.getCell((short)(firstCellNum + 15))));
                    cfsEmailAddress.setContactId(r);
                    cfsEmailAddress.setEnteredBy(userId);
                    cfsEmailAddress.setModifiedBy(userId);
                }
                logger.info("ImportAccounts --> Saving Contact ");
                if (cfsContact != null) {
                    DataRecord emailRecord;
                    DataRecord addRecord;
                    DataRecord contRecord = this.mappings.createDataRecord((Object)cfsContact, "insert");
                    if (!writer.save(contRecord)) {
                        processOK = false;
                    }
                    if (cfsAddress != null && !writer.save(addRecord = this.mappings.createDataRecord(cfsAddress, "insert"))) {
                        processOK = false;
                    }
                    if (cfsContPhList != null) {
                        processOK = this.mappings.saveList(writer, cfsContPhList, "insert");
                    }
                    if (cfsEmailAddress != null && !writer.save(emailRecord = this.mappings.createDataRecord((Object)cfsEmailAddress, "insert"))) {
                        processOK = false;
                    }
                }
                if (processOK) continue;
                return false;
            }
        }
        catch (IOException io) {
            io.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private String getCellValue(HSSFCell cell) {
        String value = null;
        switch (cell.getCellType()) {
            case 3: {
                value = "";
                break;
            }
            case 4: {
                value = Boolean.toString(cell.getBooleanCellValue());
                break;
            }
            case 0: {
                value = Double.toString(cell.getNumericCellValue()).trim();
                break;
            }
            case 1: {
                value = cell.getStringCellValue().trim();
                break;
            }
            default: {
                value = "";
            }
        }
        return value;
    }
}

