/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.writer;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.aspcfs.apps.transfer.DataField;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.utils.DatabaseUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CFSXMLWriter
implements DataWriter {
    private String lastResponse = null;
    private String filename = null;
    private PrintWriter out = null;
    private boolean overwrite = true;
    private int recordCount = 0;
    TransformerFactory transformerFactory = null;
    Transformer transformer = null;

    public String getLastResponse() {
        return this.lastResponse;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String tmp) {
        this.filename = tmp;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean tmp) {
        this.overwrite = tmp;
    }

    public void setOverwrite(String tmp) {
        this.overwrite = DatabaseUtils.parseBoolean(tmp);
    }

    public void setAutoCommit(boolean flag) {
    }

    public String getName() {
        return "CFS XML Writer";
    }

    public String getDescription() {
        return "Generates an XML representation of data as specified";
    }

    public boolean isConfigured() {
        if (this.filename == null) {
            return false;
        }
        try {
            this.transformerFactory = TransformerFactory.newInstance();
            this.transformer = this.transformerFactory.newTransformer();
            this.transformer.setOutputProperty("encoding", "UTF-8");
            this.transformer.setOutputProperty("method", "xml");
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(this.filename, !this.overwrite)));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        this.out.println("<aspcfs>");
        this.out.println(" <cfsdata>");
        return true;
    }

    public boolean save(DataRecord record) {
        ++this.recordCount;
        try {
            StreamResult result = new StreamResult(this.out);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.newDocument();
            Element drecord = document.createElement("dataRecord");
            drecord.setAttribute("name", record.getName());
            drecord.setAttribute("action", record.getAction());
            drecord.setAttribute("shareKey", String.valueOf(record.getShareKey()));
            for (DataField thisField : record) {
                Element dfield = document.createElement("dataField");
                dfield.setAttribute("name", thisField.getName());
                if (thisField.getAlias() != null) {
                    dfield.setAttribute("alias", thisField.getAlias());
                }
                if (thisField.getValueLookup() != null) {
                    dfield.setAttribute("valueLookup", thisField.getValueLookup());
                }
                if (thisField.getValue() != null) {
                    dfield.appendChild(document.createTextNode(thisField.getValue()));
                }
                drecord.appendChild(dfield);
            }
            DOMSource source = new DOMSource(drecord);
            this.transformer.transform(source, result);
        }
        catch (Exception e) {
            logger.info(e.toString());
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean commit() {
        return true;
    }

    public boolean rollback() {
        return false;
    }

    public boolean close() {
        this.out.println(" </cfsdata>");
        this.out.println("</aspcfs>");
        if (this.out != null) {
            this.out.close();
        }
        return true;
    }

    public void initialize() {
    }

    public double getVersion() {
        return 1.0;
    }

    public boolean load(DataRecord record) {
        return false;
    }
}

