/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.writer;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import org.aspcfs.apps.transfer.DataField;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;

public class TextWriter
implements DataWriter {
    private String lastResponse = null;
    private String filename = null;
    private boolean overwrite = true;
    private String fieldSeparator = null;
    private boolean showColumnNames = true;
    private PrintWriter out = null;
    private int recordCount = 0;

    public void setFilename(String tmp) {
        this.filename = tmp;
    }

    public void setOverwrite(boolean tmp) {
        this.overwrite = tmp;
    }

    public void setOverwrite(String tmp) {
        this.overwrite = "true".equals(tmp);
    }

    public void setFieldSeparator(String tmp) {
        this.fieldSeparator = tmp;
    }

    public void setShowColumnNames(boolean tmp) {
        this.showColumnNames = tmp;
    }

    public void setShowColumnNames(String tmp) {
        this.showColumnNames = "true".equals(tmp);
    }

    public void setAutoCommit(boolean flag) {
    }

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "Text Writer";
    }

    public String getDescription() {
        return "Generates a text representation of data as specified";
    }

    public String getLastResponse() {
        return this.lastResponse;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public boolean getShowColumnNames() {
        return this.showColumnNames;
    }

    public boolean isConfigured() {
        if (this.filename == null) {
            return false;
        }
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(this.filename, !this.overwrite)));
        }
        catch (IOException io) {
            io.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public void initialize() {
        this.showColumnNames = true;
        this.recordCount = 0;
    }

    private String escape(String input) {
        if (input == null) {
            return "";
        }
        if (",".equals(this.fieldSeparator)) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < input.length(); ++i) {
                if (input.charAt(i) == '\"') {
                    result.append("\"\"");
                }
                result.append(input.charAt(i));
            }
            input = result.toString().trim();
            if (input.indexOf(",") > -1) {
                input = "\"" + input + "\"";
            }
        }
        return input;
    }

    public boolean save(DataRecord record) {
        ++this.recordCount;
        try {
            DataField thisField;
            Iterator fieldItems;
            if (this.recordCount == 1 && this.showColumnNames) {
                fieldItems = record.iterator();
                while (fieldItems.hasNext()) {
                    thisField = (DataField)fieldItems.next();
                    this.out.print(thisField.getName());
                    if (!fieldItems.hasNext() || this.fieldSeparator == null) continue;
                    this.out.print(this.fieldSeparator);
                }
                this.out.println("");
            }
            fieldItems = record.iterator();
            while (fieldItems.hasNext()) {
                thisField = (DataField)fieldItems.next();
                this.out.print(this.escape(thisField.getValue()));
                if (!fieldItems.hasNext() || this.fieldSeparator == null) continue;
                this.out.print(this.fieldSeparator);
            }
            this.out.println("");
        }
        catch (Exception ex) {
            logger.info(ex.toString());
            ex.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean commit() {
        return true;
    }

    public boolean rollback() {
        return false;
    }

    public boolean load(DataRecord record) {
        return false;
    }

    public boolean close() {
        if (this.out != null) {
            this.out.close();
        }
        return true;
    }
}

