/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.writer.cfsdatabasewriter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.modules.service.base.PacketContext;
import org.aspcfs.modules.service.base.SyncClientManager;
import org.aspcfs.modules.service.base.SyncTableList;
import org.aspcfs.modules.service.base.Transaction;

public class CFSXMLDatabaseWriter
implements DataWriter {
    private String lastResponse = null;
    private Connection connection = null;
    private Connection connectionLookup = null;
    private int clientId = -1;
    private PacketContext packetContext = new PacketContext();

    public Connection getConnectionLookup() {
        return this.connectionLookup;
    }

    public void setConnectionLookup(Connection tmp) {
        this.connectionLookup = tmp;
    }

    public String getLastResponse() {
        return this.lastResponse;
    }

    public void setLastResponse(String tmp) {
        this.lastResponse = tmp;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection tmp) {
        this.connection = tmp;
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int tmp) {
        this.clientId = tmp;
    }

    public void setClientId(String tmp) {
        this.clientId = Integer.parseInt(tmp);
    }

    public String getName() {
        return "CFS XML Database Writer";
    }

    public String getDescription() {
        return "Writes data records to the database";
    }

    public void setAutoCommit(boolean flag) {
    }

    public boolean isConfigured() {
        return true;
    }

    private HashMap getObjectMap(Connection db, AuthenticationItem auth) {
        SyncTableList systemObjectMap = new SyncTableList();
        systemObjectMap.setBuildTextFields(false);
        try {
            systemObjectMap.buildList(db);
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
        }
        return systemObjectMap.getObjectMapping(auth.getSystemId());
    }

    public void initialize() {
        AuthenticationItem auth = new AuthenticationItem();
        auth.setClientId(this.clientId);
        auth.setSystemId(4);
        this.packetContext.setAuthenticationItem(auth);
        try {
            SyncClientManager clientManager = new SyncClientManager();
            clientManager.addClient(this.connection, auth.getClientId());
            this.packetContext.setClientManager(clientManager);
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
        }
        HashMap objectMap = this.getObjectMap(this.connection, auth);
        this.packetContext.setObjectMap(objectMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(DataRecord record) {
        int statusCode;
        block12: {
            statusCode = 1;
            String action = record.getAction();
            Transaction transaction = new Transaction();
            transaction.setPacketContext(this.packetContext);
            transaction.setValidateObject(false);
            transaction.build(record);
            try {
                if (!action.startsWith("insert") && !action.equals("insert") && !action.equals("update")) break block12;
                boolean commit = this.connection.getAutoCommit();
                try {
                    if (commit) {
                        this.connection.setAutoCommit(false);
                    }
                    statusCode = transaction.execute(this.connection, this.connectionLookup);
                    if (commit) {
                        this.connection.commit();
                    }
                    if (transaction.hasError()) {
                        logger.info("ERROR: " + transaction.getErrorMessage());
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace(System.out);
                    if (commit) {
                        this.connection.rollback();
                    }
                }
                finally {
                    if (commit) {
                        this.connection.setAutoCommit(true);
                    }
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace(System.out);
            }
        }
        return statusCode == 0;
    }

    public boolean commit() {
        return true;
    }

    public boolean rollback() {
        return false;
    }

    public boolean close() {
        return true;
    }

    public double getVersion() {
        return 1.0;
    }

    public boolean load(DataRecord record) {
        return false;
    }
}

