/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.writer.cfsdatabasewriter;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import com.zeroio.webdav.base.WebdavModule;
import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.PlanEditor;
import org.aspcfs.modules.admin.base.CategoryEditor;
import org.aspcfs.modules.admin.base.CustomListViewEditor;
import org.aspcfs.modules.admin.base.Permission;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.admin.base.Role;
import org.aspcfs.modules.admin.base.RolePermission;
import org.aspcfs.modules.base.ModuleFieldCategoryLink;
import org.aspcfs.modules.reports.base.Report;
import org.aspcfs.utils.web.LookupListElement;

public class PermissionsAndRolesWriter
implements DataWriter {
    private ConnectionPool sqlDriver = null;
    private Connection db = null;
    private int id = -1;
    private String driver = null;
    private String url = null;
    private String user = null;
    private String pass = null;

    public void setDriver(String tmp) {
        this.driver = tmp;
    }

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setUser(String tmp) {
        this.user = tmp;
    }

    public void setPass(String tmp) {
        this.pass = tmp;
    }

    public void setAutoCommit(boolean flag) {
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "Permissions and Roles Writer";
    }

    public String getDescription() {
        return "Inserts data directly into a Centric CRM database";
    }

    public void setDb(Connection db) {
        this.db = db;
    }

    public String getLastResponse() {
        return String.valueOf(this.id);
    }

    public boolean isConfigured() {
        String tmpPass;
        String tmpUser;
        String tmpDriver;
        String tmpUrl = System.getProperty("url");
        if (tmpUrl != null) {
            this.url = tmpUrl;
        }
        if ((tmpDriver = System.getProperty("driver")) != null) {
            this.driver = tmpDriver;
        }
        if ((tmpUser = System.getProperty("user")) != null) {
            this.user = tmpUser;
        }
        if ((tmpPass = System.getProperty("pass")) != null) {
            this.pass = tmpPass;
        }
        if (this.url == null) {
            return false;
        }
        try {
            this.sqlDriver = new ConnectionPool();
            this.sqlDriver.setForceClose(false);
            this.sqlDriver.setMaxConnections(1);
            ConnectionElement thisElement = new ConnectionElement(this.url, this.user, this.pass);
            thisElement.setDriver(this.driver);
            this.db = this.sqlDriver.getConnection(thisElement);
        }
        catch (SQLException e) {
            logger.info("Could not get database connection" + e.toString());
            return false;
        }
        return true;
    }

    public boolean save(DataRecord record) {
        block14: {
            try {
                if (record.getName().equals("permissionCategory")) {
                    PermissionCategory thisCategory = new PermissionCategory();
                    thisCategory.setConstant(record.getValue("constant"));
                    thisCategory.setCategory(record.getValue("category"));
                    thisCategory.setLevel(Integer.parseInt(record.getValue("level")));
                    thisCategory.setEnabled(record.getValue("enabled"));
                    thisCategory.setActive(record.getValue("active"));
                    thisCategory.setFolders(record.getValue("folders"));
                    thisCategory.setLookups(record.getValue("lookups"));
                    thisCategory.setViewpoints(record.getValue("viewpoints"));
                    thisCategory.setReports(record.getValue("reports"));
                    thisCategory.setCategories(record.getValue("categories"));
                    thisCategory.setScheduledEvents(record.getValue("scheduledEvents"));
                    thisCategory.setObjectEvents(record.getValue("objectEvents"));
                    thisCategory.setWebdav(record.getValue("webdav"));
                    thisCategory.setLogos(record.getValue("logos"));
                    thisCategory.setActionPlans(record.getValue("actionPlans"));
                    thisCategory.insert(this.db);
                    this.id = thisCategory.getId();
                    return true;
                }
                if (record.getName().equals("permission")) {
                    Permission thisPermission = new Permission();
                    thisPermission.setCategoryId(record.getValue("categoryId"));
                    thisPermission.setPermissionLevel(record.getValue("permissionLevel"));
                    thisPermission.setName(record.getValue("name"));
                    thisPermission.setDescription(record.getValue("description"));
                    thisPermission.setView(record.getValue("view"));
                    thisPermission.setAdd(record.getValue("add"));
                    thisPermission.setEdit(record.getValue("edit"));
                    thisPermission.setDelete(record.getValue("delete"));
                    thisPermission.setEnabled(record.getValue("enabled"));
                    thisPermission.setActive(record.getValue("active"));
                    thisPermission.setViewpoints(record.getValue("viewpoints"));
                    thisPermission.insert(this.db);
                    this.id = thisPermission.getId();
                    return true;
                }
                if (record.getName().equals("folder")) {
                    ModuleFieldCategoryLink categoryLink = new ModuleFieldCategoryLink();
                    categoryLink.setModuleId(record.getIntValue("moduleId"));
                    categoryLink.setCategoryId(record.getIntValue("categoryId"));
                    categoryLink.setLevel(record.getIntValue("level"));
                    categoryLink.setDescription(record.getValue("description"));
                    categoryLink.insert(this.db);
                    return true;
                }
                if (record.getName().equals("planEditor")) {
                    PlanEditor editor = new PlanEditor();
                    editor.setModuleId(record.getIntValue("moduleId"));
                    editor.setConstantId(ActionPlan.getMapIdGivenConstantId(this.db, record.getIntValue("constantId")));
                    editor.setLevel(record.getIntValue("level"));
                    editor.setDescription(record.getValue("description"));
                    editor.setCategoryId(record.getIntValue("categoryId"));
                    editor.insert(this.db);
                    return true;
                }
                if (record.getName().equals("lookup")) {
                    LookupListElement lookupList = new LookupListElement();
                    lookupList.setModuleId(record.getIntValue("moduleId"));
                    lookupList.setLookupId(record.getIntValue("lookupId"));
                    lookupList.setClassName(record.getValue("class"));
                    lookupList.setTableName(record.getValue("table"));
                    lookupList.setLevel(record.getIntValue("level"));
                    lookupList.setDescription(record.getValue("description"));
                    lookupList.setCategoryId(record.getIntValue("categoryId"));
                    lookupList.insert(this.db);
                    this.id = lookupList.getId();
                    return true;
                }
                if (record.getName().equals("report")) {
                    Report report = new Report();
                    report.setCategoryId(record.getIntValue("categoryId"));
                    report.setPermissionId(record.getIntValue("permissionId"));
                    report.setFilename(record.getValue("file"));
                    report.setType(record.getIntValue("type"));
                    report.setTitle(record.getValue("title"));
                    report.setDescription(record.getValue("description"));
                    report.setEnteredBy(record.getIntValue("enteredBy"));
                    report.setModifiedBy(record.getIntValue("modifiedBy"));
                    report.insert(this.db);
                    this.id = report.getId();
                    return true;
                }
                if (record.getName().equals("multipleCategory")) {
                    CategoryEditor categoryEditor = new CategoryEditor();
                    categoryEditor.setModuleId(record.getIntValue("moduleId"));
                    categoryEditor.setConstantId(record.getIntValue("constantId"));
                    categoryEditor.setTableName(record.getValue("table"));
                    categoryEditor.setLevel(record.getIntValue("level"));
                    categoryEditor.setDescription(record.getValue("description"));
                    categoryEditor.setCategoryId(record.getIntValue("categoryId"));
                    categoryEditor.setMaxLevels(record.getIntValue("maxLevels"));
                    categoryEditor.insert(this.db);
                    return true;
                }
                if (record.getName().equals("customListViewCategory")) {
                    CustomListViewEditor listViewEditor = new CustomListViewEditor();
                    listViewEditor.setModuleId(record.getIntValue("moduleId"));
                    listViewEditor.setConstantId(record.getIntValue("constantId"));
                    listViewEditor.setDescription(record.getValue("description"));
                    listViewEditor.setCategoryId(record.getIntValue("categoryId"));
                    listViewEditor.insert(this.db);
                    return true;
                }
                if (record.getName().equals("role")) {
                    Role thisRole = new Role();
                    thisRole.setRole(record.getValue("role"));
                    thisRole.setDescription(record.getValue("description"));
                    thisRole.setRoleType(record.getValue("type"));
                    thisRole.setEnteredBy(0);
                    thisRole.setModifiedBy(0);
                    thisRole.setEnabled(record.getValue("enabled"));
                    thisRole.insert(this.db);
                    this.id = thisRole.getId();
                    return true;
                }
                if (record.getName().equals("rolePermission")) {
                    RolePermission thisRolePermission = new RolePermission();
                    thisRolePermission.setRoleId(record.getValue("roleId"));
                    thisRolePermission.setPermissionId(record.getValue("permissionId"));
                    thisRolePermission.setView(record.getValue("view"));
                    thisRolePermission.setAdd(record.getValue("add"));
                    thisRolePermission.setEdit(record.getValue("edit"));
                    thisRolePermission.setDelete(record.getValue("delete"));
                    thisRolePermission.insert(this.db);
                    this.id = thisRolePermission.getId();
                    return true;
                }
                if (!record.getName().equals("webdav")) break block14;
                try {
                    WebdavModule webdav = new WebdavModule();
                    webdav.setCategoryId(record.getIntValue("categoryId"));
                    webdav.setClassName(record.getValue("class"));
                    webdav.setEnteredBy(0);
                    webdav.setModifiedBy(0);
                    webdav.insert(this.db);
                    this.id = webdav.getId();
                }
                catch (SQLException e) {
                    e.printStackTrace(System.out);
                    return false;
                }
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                logger.info(ex.toString());
                return false;
            }
        }
        return true;
    }

    public boolean commit() {
        return true;
    }

    public boolean rollback() {
        return true;
    }

    public boolean load(DataRecord record) {
        return false;
    }

    public boolean close() {
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public void initialize() {
    }
}

